<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

    class account extends CI_Controller {

        var $min_username = 4;
        var $max_username = 50;
        var $min_password = 4;
        var $max_password = 20;

        public function __construct() {
            parent::__construct();
            $this->load->library('form_validation');
            $this->load->model('mod_vcount');
        }

        private function check_permission($role_id) {
            if ($role_id == 1) {
                /* Go to page administrator */
                redirect('admin/index', 'location');
            } elseif ($role_id == 2) {
                /* Go to page Seeker */
                redirect('web_master/user/index','location');
            } elseif ($role_id == 3) {
                /* Go to page resume */
                redirect('seeker/account','location');
            } elseif ($role_id == 4) {
                $array = array();
                /* set employer_id session*/
                $this->session->set_userdata($array);
                $this->load->model("model_employer");
                $employer_id=$this->model_employer->employer_id($this->dx_auth->get_user_id())->row();
                $newdata = array('employer_id'=>$employer_id->employer_id );
                
                $this->session->set_userdata($newdata);

                /* Go to page employer */
                redirect('employer-login-page','location');
            } elseif ($role_id == 5) {
                /* Go to page training */
                redirect('jobshop/training/index','location');
            } elseif ($role_id == 6 OR $role_id == 7) {
                /* Go to page job center */
                redirect('jobshop/center/index', 'location');
            } elseif ($role_id == 9) {
                /* Go to page Career guidance */
                redirect('career_gui/career_guidance/view_career', 'location');
            } elseif ($role_id == 8) {
                /* Go to page Library Admin */

                redirect("library/center", "location");
            }
        }
        
        function _show_option() {
            
            /* Get Language */
            $data['lang_status']=$this->lang->lang();
            
            $data['likes_count']  = $this->mod_vcount->getFacebookDetails()[0]['like_count'];
            $data['youtube_views_count']  = $this->mod_vcount->youtube_view_count_channel()['viewCount'];
            return $data;
                    
        }
        
        public function login() {

            if ( ! $this->dx_auth->is_logged_in()) {

                $val = $this->form_validation;

                $val->set_error_delimiters('<p class="text-danger">', '</p>');
                $val->set_rules('txtusername', $this->lang->line('label_username'), 'trim|required|xss_clean|min_length['.$this->min_username.']|max_length['.$this->max_username.']');
                $val->set_rules('txtpassword', $this->lang->line('label_password'), 'trim|required|xss_clean|min_length['.$this->min_password.']|max_length['.$this->max_password.']');

                //$val->set_message('required', 'Your custom message here');

                if ($val->run() AND $this->dx_auth->login(strtolower($this->input->post('txtusername')), $this->input->post('txtpassword'), FALSE)) {
                    $this->check_permission($this->dx_auth->get_role_id());
                } else {

                    /*
                Page title and social share
            */
                    $data = $this->_show_option();
                    $data['page_title'] = $this->lang->line("label_nea_gov_kh")." - ".$this->lang->line("logo_in_form");
                    $data['share_title'] = "National Employment Agency - Login Information";
                    $data['share_url'] = site_url("account/login");
                    $data['share_image'] = "account.png";
                    
                    $this->load->view('account/login', $data);
                }

            } else {
                $this->check_permission($this->dx_auth->get_role_id());
            }
        }

        public function logout() {
            $this->dx_auth->logout();

            /*
             * Go NEA Home Page
             */
            redirect('','location');
        }
         public function re_login() {
            $this->dx_auth->logout();

            /*
             * Go NEA Home Page
             */
            redirect('account/login','location');
        }

        public function activate($username, $key) {
            $this->dx_auth->activate($username, $key);

            /*
             * Go NEA Home Page
             */
            redirect('','location');
        }

    }
?>