<?php  if (!defined('BASEPATH')) exit('No direct script access allowed');

    Class library extends CI_Controller{
        public function __construct() {

            parent::__construct();

            /* Assign language */
            $this->lang->load('dic');
            $this->lang->load('library');


            /* Load Library */
            $this->load->library('form_validation');
            $this->load->library('DX_Auth');
            $this->load->library('user_agent');

            // Load model
            $this->load->model("library/model_categories", "lib_category");
            $this->load->model("library/model_books", "lib_book");
            $this->load->model("library/model_author", "lib_author");
            $this->load->model("library/model_book_center", "lib_center");

        }

        public function index(){

            // Page title
            $data['page_title'] = "National Employment Agency - Job Library Management";

            // List Category
            $data['list_categories'] = $this->lib_category->select_all();

            // Get Latest Book
            $data['Latest_book'] = $this->lib_book->get_latest_book();

            $this->load->view('library/index', $data);
        }

        public function category($cate_id, $offset="0") {

            if ((int)$cate_id <= 0) {

                redirect("library/library", "location");

            }

            $view_cate = $this->lib_category->select_one($cate_id);

            if ($view_cate->num_rows() <= 0) {
                redirect("library/library", "location");
            }

            $data['view_cate'] = $view_cate->row();

            // Page title
            $data['page_title'] = "National Employment Agency - Job Library Management";

            // List Category
            $data['list_categories'] = $this->lib_category->select_all();

            $limit = 20;

            // retrieve to total record of table
			$total = $this->lib_book->get_category_total_books($cate_id);

            // Prepare create pagination
			$config['base_url'] = site_url('library/library/category/'.$cate_id);
			$config['total_rows'] = $total;
			$config['per_page'] = $limit;
			$config['uri_segment'] = 6;

			$config['num_links'] = 5;

			$this->pagination->initialize($config);

            $data['page_links'] = $this->pagination->create_links();

            // Get data
            $data['list_book'] = $this->lib_book->get_book_by_cate($cate_id, $limit, $offset);

            $this->load->view('library/category', $data);

        }

        public function book($book_id) {

            $view_book = $this->lib_book->select_one($book_id);

            if ($view_book->num_rows() <=0 ) {
                redirect("library/library", "location");
            }

            $data['view_book'] = $view_book->row();

            // Page title
            $data['page_title'] = "National Employment Agency - Job Library Management";

            // List Category
            $data['list_categories'] = $this->lib_category->select_all();

            // List Book Center

            $data["list_center"] = $this->lib_center->select_book_center($book_id);

            // Load view
            $this->load->view("library/book", $data);
        }

        public function author($auth_id, $offset="0") {

            $view_author = $this->lib_author->select_one($auth_id);

            if ($view_author->num_rows() <= 0) {
                redirect("library/library", "location");
            }

            $data['view_author'] = $view_author->row();

            // Page title
            $data['page_title'] = "National Employment Agency - Job Library Management";

            // List Category
            $data['list_categories'] = $this->lib_category->select_all();

            $limit = 20;

            // retrieve to total record of table
			$total = $this->lib_book->get_author_total_books($auth_id);

            // Prepare create pagination
			$config['base_url'] = site_url('library/library/author/'.$auth_id);
			$config['total_rows'] = $total;
			$config['per_page'] = $limit;
			$config['uri_segment'] = 6;

			$config['num_links'] = 5;

			$this->pagination->initialize($config);

            $data['page_links'] = $this->pagination->create_links();

            // Get data
            $data['list_book'] = $this->lib_book->get_book_by_author($auth_id, $limit, $offset);

            $this->load->view('library/author', $data);

        }

        public function year($year, $offset="0") {

            if ((int)$year <= 0 OR strlen($year) != 4 ) {
                redirect("library/library", "location");
            }

            // Page title
            $data['page_title'] = "National Employment Agency - Job Library Management";

            // List Category
            $data['list_categories'] = $this->lib_category->select_all();

            $limit = 20;

            // retrieve to total record of table
			$total = $this->lib_book->get_year_total_books($year);

            // Prepare create pagination
			$config['base_url'] = site_url('library/library/author/'.$year);
			$config['total_rows'] = $total;
			$config['per_page'] = $limit;
			$config['uri_segment'] = 6;

			$config['num_links'] = 5;

			$this->pagination->initialize($config);

            $data['page_links'] = $this->pagination->create_links();

            // Get data
            $data['list_book'] = $this->lib_book->get_book_by_year($year, $limit, $offset);

            $this->load->view('library/year', $data);
        }

        public function confirm() {

            $text = $this->input->post("txtkeyword");

            if ($text == "") {
                redirect("library/library", "location");
            } else {
                redirect("library/library/result/".rawurlencode($text), "location");
            }
        }

        public function result($keyword, $offset="0") {

            if (rawurldecode($keyword) == "") {
                redirect("library/library", "location");
            }

            // Page title
            $data['page_title'] = "National Employment Agency - Job Library Management";

            // List Category
            $data['list_categories'] = $this->lib_category->select_all();

            $limit = 20;

            // retrieve to total record of table
			$total = $this->lib_book->get_search_total_books(rawurldecode($keyword));

            // Prepare create pagination
			$config['base_url'] = site_url('library/library/result/'.$keyword);
			$config['total_rows'] = $total;
			$config['per_page'] = $limit;
			$config['uri_segment'] = 6;

			$config['num_links'] = 5;

			$this->pagination->initialize($config);

            $data['page_links'] = $this->pagination->create_links();

            // Get data
            $data['list_book'] = $this->lib_book->get_book_by_search(rawurldecode($keyword), $limit, $offset);

            // Load view
            $this->load->view("library/result", $data);

        }

    }
?>