<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class rest_api extends CI_Controller
{
    var $key_api = 'sd062508617885092134676135471224';

    public function __construct()
    {
        parent::__construct();

        /*
         * load model
         */
        $this->load->model('model_savada_api_v1');
    }

    function index()
    {
        $response = array();

        // no products found
        $response["success"] = 0;
        $response["message"] = "Required field(s) is missing";

        // echo no users JSON
        echo json_encode($response);


    }
    function v1($key_values='0')
    {
        $this->output->set_content_type('application/json');
      //  $key_values=$this->input->post('key_api');

        $response = array();
        if ($this->key_api == $key_values) {

            $result = $this->model_savada_api_v1->get_all_jobs_api();
            $result_number_rows = $result->num_rows();
            if ($result_number_rows > 0) {
                // looping through all results
                // products node
                $response["nea_job_vacancies"] = array();
                foreach ($result->result() as $row) {
                    // temp user array
                    $product = array();
                    $product["vacancy_id"] = $row->job_id;
                    $product["vacancy_title"] = $row->job_name;
                    $product["vacancy_closed_date"] = $row->close_date;
                    $product["vacancy_employer_name"] = $row->employer;
                    $product["vacancy_location"] = $row->location;
                    $product["vacancy_salary"] = $row->salary;
                    $product["vacancy_team_of_employ"] = $row->job_term_name;
                    $product["vacancy_num"] = $row->vacancy_num;

                    $duration = $row->duration_day;

                    if ($duration < 0) {
                        $duration = "New";
                    } else if ($duration == 0) {
                        $duration = "Today";
                    } else if ($duration == 1) {
                        $duration = "Yesterday";
                    } else if ($duration > 30) {
                        $duration = 30 . " Days+ ";
                    } else {
                        $duration = $duration . " Days";
                    }

                    $product["post_date_time"] = $duration;
                    // push single product into final response array
                    array_push($response["nea_job_vacancies"], $product);

                }
                // success
                $response["success"] = 1;
                $response["num_rows"] = $result_number_rows;

                // echoing JSON response
               //header('Content-Type: application/json');
                echo json_encode($response);

            } else {
                // no products found
                $response["success"] = 0;
                $response["message"] = "No vacancy found";

                // echo no users JSON
                echo json_encode($response);
            }
        } else {
            // required field is missing
            $response["success"] = 0;
            $response["message"] = "Required field(s) is missing";

            // echoing JSON response
            echo json_encode($response);
        }


    }

    function v1_get_all_jobs_kh()
    {
        $this->output->set_content_type('application/json');
        $response = array();
        $result = $this->model_savada_api_v1->get_all_jobs_api_kh();
        $result_number_rows = $result->num_rows();
        if ($result_number_rows > 0) {
            // looping through all results
            // products node
            $response["products"] = array();

            foreach ($result->result() as $row) {
                // temp user array
                $product = array();
                $product["pid"] = $row->job_id;
                $product["name"] = $row->job_name;
                $product["close_date"] = $row->close_date;
                $product["employer"] = $row->employer;
                $product["location"] = $row->location;
                $product["salary"] = $row->salary;
                $product["job_term_name"] = $row->job_term_name;
                $product["vacancy_num"] = $row->vacancy_num;

                $duration = $row->duration_day;

                if ($duration < 0) {
                    $duration = "<font color='#FF3C1F'>ថ្មី</font>";
                } else if ($duration == 0) {
                    $duration = "<font color='#ddaa3b'>ថ្ងៃនេះ</font>";
                } else if ($duration == 1) {
                    $duration = "កាលពីម្សិល";
                } else if ($duration > 30) {
                    $duration = 30 . " ថ្ងៃ + ";
                } else {
                    $duration = $duration . " ថ្ងៃ";
                }

                $product["duration_day"] = $duration;
                // push single product into final response array
                array_push($response["products"], $product);

            }
            // success
            $response["success"] = 1;
            $response["num_rows"] = $result_number_rows;

            // echoing JSON response
            echo json_encode($response);
        } else {
            // no products found
            $response["success"] = 0;
            $response["message"] = "No products found";

            // echo no users JSON
            echo json_encode($response);
        }
    }


    function v1_vacancy_detail($key_values='0',$job_id='0')
    {
        $this->output->set_content_type('application/json');
        // check for post data
        $response = array();
      //  if (isset($_GET['vacancy_id'])) {
            //$job_id = $this->input->get('vacancy_id');
            // For insert log requests
/*
            $ip_add = $_SERVER['REMOTE_ADDR'];
            // -> "Mountain View"
            $data_insert = array(
                'job_id' => $job_id,
                'ip_address_remote' => $ip_add,

            );
*/
            //   $this->model_savada_api_v1->insert_log_request($data_insert);
            //----------------------------------------------------------------

        if ($this->key_api == $key_values){

            $result = $this->model_savada_api_v1->get_job_by_id_api($job_id);

            if (!empty($result)) {
                // check for empty result
                if ($result->num_rows() > 0) {

                    $result = $result->row();
                    $product = array();
                    $product["vacancy_id"] = $result->job_id;
                    $product["vacancy_title"] = $result->job_name;
                    // Employer profile
                    $product["employer_name"] = $result->employer;
                    $product["employer_address"] = strip_tags($this->strip_tags_content($result->employer_address, '<br>', TRUE));
                    $product["employer_profile_detail"] = strip_tags($this->strip_tags_content($result->employer_profile_details, '<br>', TRUE));
                    //----------------------------
                    $product["close_date"] = $result->close_date;
                    $product["vacancy_location"] = $result->location;
                    $product["vacancy_num"] = $result->vacancy_num;
                    $product["vacancy_salary"] = $result->salary . " USD";
                    $product["vacancy_team_of_employment"] = $result->job_term_name;
                    $product["vacancy_start_working"] = $result->job_start_working;

                    // Convert HTML to Texts
                    $product["vacancy_desc"] =   strip_tags($this->strip_tags_content($result->description, '<br>', TRUE));
                    $product["vacancy_other_requirement"] =  strip_tags($this->strip_tags_content($result->other_requirement, '<br>', TRUE));
                    $product["vacancy_req_language"] = $result->job_language;
                    $product["vacancy_req_language_level"] = $result->job_language_level;
                    $product["vacancy_req_education"] = $result->job_education;
                    $product["vacancy_req_major"] = $result->job_major;
                    $product["vacancy_how_to_apply"] = strip_tags($this->strip_tags_content($result->how_to_apply, '<br>', TRUE));

                    // Job Center Blog
                    $product["vacancy_jc_office_name"] = $result->jc_office_name;
                    $product["vacancy_jc_contacts"] = $result->jc_contacts;
                    $product["vacancy_jc_email"] = $result->jc_email;
                    $product["vacancy_jc_address"] = $result->jc_address;
                    echo json_encode($product);

                    // success
                 //   $response["success"] = 1;

                    // user node
                  //  $response["vacancy_detail"] = array();

                 //  echo array_push($response["vacancy_detail"], $product);

                    // echoing JSON response
                 // echo json_encode($response);
                } else {
                    // no product found
                    $response["success"] = 0;
                    $response["message"] = "No product found";

                    // echo no users JSON
                    echo json_encode($response);
                }
            } else {
                // no product found
                $response["success"] = 0;
                $response["message"] = "No product found";

                // echo no users JSON
                echo json_encode($response);
            }
        } else {
            // required field is missing
            $response["success"] = 0;
            $response["message"] = "Required field(s) is missing";

            // echoing JSON response
            echo json_encode($response);
        }
    }

    function get_job_detail_kh()
    {
        // check for post data
        $response = array();
        if (isset($_GET["pid"])) {
            $job_id = $_GET['pid'];
            // For insert log requests

            $ip_add = $_SERVER['REMOTE_ADDR'];
            // -> "Mountain View"
            $data_insert = array(
                'job_id' => $job_id,
                'ip_address_remote' => $ip_add,

            );
            //   $this->model_savada_api_v1->insert_log_request($data_insert);
            //----------------------------------------------------------------
            $result = $this->model_savada_api_v1->get_job_by_id_api_kh($job_id);

            if (!empty($result)) {
                // check for empty result
                if ($result->num_rows() > 0) {

                    $result = $result->row();
                    $product = array();
                    $product["pid"] = $result->job_id;
                    $product["name"] = $result->job_name;
                    // Employer profile
                    $product["employer"] = $result->employer;
                    $product["employer_address"] = 'Address:' . strip_tags($result->employer_address);
                    $product["employer_profile_detail"] = 'Profile Detail:' . strip_tags($result->employer_profile_details);
                    //----------------------------
                    $product["close_date"] = $result->close_date;
                    $product["location"] = $result->location;
                    $product["vacancy_num"] = $result->vacancy_num;
                    $product["salary"] = $result->salary . "   ដុល្លា";
                    $product["job_term_name"] = $result->job_term_name;
                    $product["job_start_working"] = $result->job_start_working;
                    $product["description"] = $result->description;
                    $product["other_requirement"] = $result->other_requirement;
                    $product["job_language"] = $result->job_language;
                    $product["job_language_level"] = $result->job_language_level;
                    $product["job_education"] = $result->job_education;
                    $product["job_major"] = $result->job_major;
                    $product["how_to_apply"] = $result->how_to_apply;

                    // Job Center Blog
                    $product["jc_office_name"] = $result->jc_office_name;
                    $product["jc_contacts"] = $result->jc_contacts;
                    $product["jc_email"] = $result->jc_email;
                    $product["jc_address"] = $result->jc_address;


                    // success
                    $response["success"] = 1;

                    // user node
                    $response["product"] = array();

                    array_push($response["product"], $product);

                    // echoing JSON response
                    echo json_encode($response);
                } else {
                    // no product found
                    $response["success"] = 0;
                    $response["message"] = "No product found";

                    // echo no users JSON
                    echo json_encode($response);
                }
            } else {
                // no product found
                $response["success"] = 0;
                $response["message"] = "No product found";

                // echo no users JSON
                echo json_encode($response);
            }
        } else {
            // required field is missing
            $response["success"] = 0;
            $response["message"] = "Required field(s) is missing";

            // echoing JSON response
            echo json_encode($response);
        }
    }
    function strip_tags_content($text, $tags = '', $invert = FALSE)
    {

        preg_match_all('/<(.+?)[\s]*\/?[\s]*>/si', trim($tags), $tags);
        $tags = array_unique($tags[1]);

        if (is_array($tags) AND count($tags) > 0) {
            if ($invert == FALSE) {
                return preg_replace('@<(?!(?:' . implode('|', $tags) . ')\b)(\w+)\b.*?>.*?</\1>@sin', '', $text);
            } else {
                return preg_replace('@<(' . implode('|', $tags) . ')\b.*?>.*?</\1>@si', '', $text);
            }
        } elseif ($invert == FALSE) {
            return preg_replace('@<(\w+)\b.*?>.*?</\1>@si', '', $text);
        }
        return $text;
    }

}

