<?php
    Class model_book_center extends CI_Model {

        public function insert($data) {

            $this->db->trans_start();
            $this->db->insert("lib_book_center", $data);
            $this->db->trans_complete();
            return '';
        }

        public function update($center_id, $book_id, $total_book) {
            $this->db->trans_start();
            $sql = "UPDATE lib_book_center SET total_book = total_book + ? WHERE center_id = ? AND book_id =?";
            $this->db->query($sql, array($total_book, $center_id, $book_id));
            $this->db->trans_complete();
        }

        public function get_total_book_by_center($center_id) {
            $this->db->from("lib_book_center");
            $this->db->where("center_id", $center_id);
            return $this->db->count_all_results();
        }

        public function get_book_by_center($center_id, $limit, $offset) {

            $this->db->limit($limit, $offset);
            $this->db->select("A.*, B.total_book");
            $this->db->from("lib_books A, lib_book_center B");
            $where = "B.book_id = A.id";
            $this->db->where($where);
            $this->db->where("B.center_id", $center_id);
            $this->db->order_by("B.id", 'DESC');
            return $this->db->get();

        }

        public function check_have_book($center_id, $book_id) {

            $this->db->select("*");
            $this->db->from("lib_book_center");
            $this->db->where("center_id", $center_id);
            $this->db->where("book_id", $book_id);

            return $this->db->count_all_results();
        }

        public function select_one($center_id, $book_id) {

            $this->db->select("*");
            $this->db->from("lib_book_center");
            $this->db->where("center_id", $center_id);
            $this->db->where("book_id", $book_id);

            return $this->db->get();
        }

        public function select_book_center($book_id) {

            $this->db->select("B.center_address, B.center_contact, C.location_name, C.location_name_khmer");
            $this->db->from("lib_book_center A, nea_center B, nea_location_history C");
            $this->db->where("A.book_id", $book_id);
            $where = "A.center_id = B.center_id AND A.user_id = B.user_id AND A.center_id = C.location_id";
            $this->db->where($where);
            return $this->db->get();
        }


    }
?>