<?php

/**
 * Created by PhpStorm.
 * User: asus
 * Date: 3/16/2015
 * Time: 11:05 AM
 */
class model_jobapi_v1 extends CI_Model
{
    function __construct()
    {
        parent::__construct();
    }
    
    // -- Mark get news feeds ordering
    
      function get_news_feeds_all($news_id){

        //$this->db->where('ordering >=',$ordering);
        $this->db->where('news_feeds_id <=',$news_id);
        $this->db->where_not_in('status','0');
        $this->db->order_by('ordering', 'asc');
        $this->db->limit('15','0');
        return $this->db->get('tb_news_feeds');
    }

    

    
    function get_news_feeds_3($ordering){
        $this->db->select("news_feeds_id");
        $this->db->select("title_kh");
        $this->db->select("title_en");
        $this->db->select("news_feeds_body_kh");
        $this->db->select("description_5line_kh");
        $this->db->select("source_en");
        $this->db->select("source_kh");
        $this->db->select("pictures");
        
        $this->db->select("create_date");
        $this->db->select("update_date");
      
        // $this->db->where('ordering >=',$ordering);
        $this->db->where_not_in('status','0');
        $this->db->order_by('news_feeds_id', 'DESC');
        $this->db->group_by('news_feeds_id');
        $this->db->limit('3','0');
        return $this->db->get('tb_news_feeds');
    }
    
    //---Mark Employer Proile //----- Updated
	function get_employer_detail($job_id=0){
	
	    $sqlStr=" SELECT
				  a.employer_id         AS org_id,
				  a.name                AS org_name,
				  c.name_english        AS industry_en,
				  d.name_english        AS org_type_en,
				  a.registration_number	AS org_reg_num,
				  a.patent_number       AS org_patent_num,
				  a.total_employee      AS org_num_employ,
				  a.main_job_title      AS org_main_occup,
				  a.address          	AS org_address,
				  a.profile 	    	AS org_background,
				  E.contact_person      AS org_cont_person,
				  E.office_phone   	    AS org_office_phone,
				  E.fax            	    AS org_fax,
				  E.mobile_phone        AS org_mobile,
				  E.email             	AS org_email,
				  E.website          	AS org_website,
				  a.profile ,
				  a.address_longitude   AS org_long,
				  a.address_latitude    AS org_let,
				  a.pictures            AS image_logo
				  
				FROM employer a
					 LEFT JOIN vacancy b ON  b.employer_id = a.employer_id 
					 LEFT JOIN isic c ON c.isic_id = a.sector_isic_id
					 LEFT JOIN employer_type d ON d.employer_type_id = a.employer_type_id
					 LEFT JOIN employer_reference E ON E.employer_id = a.employer_id 
				WHERE b.vacancy_id='$job_id'
				GROUP BY a.employer_id ";
		 return $query = $this->db->query($sqlStr);		
	}
	
	  //---Mark Employer Proile in Khmer //----- Updated
	function get_employer_detail_kh($job_id=''){
	
	    $sqlStr="SELECT
				  a.employer_id         AS org_id,
				  a.name                AS org_name,
				  c.name_khmer          AS industry_khmer,
				  d.name_khmer          AS org_type_khmer,
				  a.registration_number	AS org_reg_num,
				  a.patent_number       AS org_patent_num,
				  a.total_employee      AS org_num_employ,
				  a.main_job_title      AS org_main_occup,
				  a.address          	AS org_address,
				  a.profile 		    AS org_background,
				  E.contact_person      AS org_cont_person,
				  E.office_phone   	    AS org_office_phone,
				  E.fax            	    AS org_fax,
				  E.mobile_phone        AS org_mobile,
				  E.email            	AS org_email,
				  E.website         	AS org_website,
				  a.address_longitude   AS org_long,
				  a.address_latitude    AS org_lat
				  
				FROM employer a
					 LEFT JOIN vacancy b ON  b.employer_id = a.employer_id 
					 LEFT JOIN isic c ON c.isic_id = a.sector_isic_id
					 LEFT JOIN employer_type d ON d.employer_type_id = a.employer_type_id
					 LEFT JOIN employer_reference E ON E.employer_id = a.employer_id 
				 
					 
				WHERE b.vacancy_id='$job_id'
				GROUP BY a.employer_id ";
		 return $query = $this->db->query($sqlStr);		
	}
    function get_all_jobs_api()
    {
        $sqlStr = " SELECT "."     
                            vacancy_id AS 'job_id',
                            job_title AS 'job_title',
                            isco_name_eng AS 'job_name',
                            isco_name_kh AS 'job_name_kh',
                            ORG_NAME AS 'employer',
                            total_vacancy AS 'vacancy_num',
                            duration_day AS 'duration_day',
                            DATE_FORMAT(job_start_working , '%d/%m/%Y') AS 'job_start_working',
                            DATE_FORMAT(closing_date, '%d/%m/%Y')	AS  'close_date',
                            job_salary AS 'salary',
                            job_term_name AS 'job_term_name',
                            job_term_name_khmer AS 'job_term_name_khmer',
                            REPLACE(job_location_eng, '###', ' ,')  as 'location',
                            REPLACE(job_location_kh, '###', ' ,')  as 'location_khmer'
                            FROM jobshop_vacancies
                            WHERE closing_date>=CURDATE() ";
	           $sqlStr .= " GROUP BY vacancy_id
                            ORDER BY vacancy_id DESC
                            LIMIT 0,100 ";
        return $query = $this->db->query($sqlStr);

    }
	
	
	 function get_all_jobs_api_kh()
    {
         $sqlStr = " SELECT "."     
                            vacancy_id AS 'job_id',
                            job_title AS 'job_title',
                            isco_name_eng AS 'job_name',
                            isco_name_kh AS 'job_name_kh',
                            ORG_NAME AS 'employer',
                            total_vacancy AS 'vacancy_num',
                            duration_day AS 'duration_day',
                            DATE_FORMAT(job_start_working , '%d/%m/%Y') AS 'job_start_working',
                            DATE_FORMAT(closing_date, '%d/%m/%Y')	AS  'close_date',
                            job_salary AS 'salary',
                            job_term_name AS 'job_term_name',
                            job_term_name_khmer AS 'job_term_name_khmer',
                            REPLACE(job_location_eng, '###', ' ,')  as 'location',
                            REPLACE(job_location_kh, '###', ' ,')  as 'location_khmer'
                            FROM jobshop_vacancies
                            WHERE closing_date>=CURDATE() ";
	           $sqlStr .= " GROUP BY vacancy_id
                            ORDER BY vacancy_id DESC
                            ";
        return $query = $this->db->query($sqlStr);

    }

    
    /* Mark ---  api from latest databas*/
   
    function get_all_latest_jobs_api()
    {
    //D.name_english AS 'job_name' ISOC,
        $sqlStr = " SELECT "."     
                            vacancy_id AS 'job_id',
                            job_title AS 'job_title',
                            isco_name_eng AS 'job_name',
                            isco_name_kh AS 'job_name_kh',
                            ORG_NAME AS 'employer',
                            total_vacancy AS 'vacancy_num',
                            duration_day AS 'duration_day',
                            DATE_FORMAT(job_start_working , '%d/%m/%Y') AS 'job_start_working',
                            DATE_FORMAT(closing_date, '%d/%m/%Y')	AS  'close_date',
                            job_salary AS 'salary',
                            job_term_name AS 'job_term_name',
                            job_term_name_khmer AS 'job_term_name_khmer',
                            REPLACE(job_location_eng, '###', ' ,')  as 'location',
                            REPLACE(job_location_kh, '###', ' ,')  as 'location_khmer'
                            FROM jobshop_vacancies
                            WHERE closing_date>=CURDATE() ";
	           $sqlStr .= " GROUP BY vacancy_id
                            ORDER BY vacancy_id DESC
                            LIMIT 0,10 ";
        return $query = $this->db->query($sqlStr);

    }
	
 function get_job_by_detail_api()
    {
        $sqlStr = " SELECT A.job_id, GROUP_CONCAT(B.job_location ) AS location_id, ". "
              GROUP_CONCAT(LH.location_name,'(', B.job_no_vacancy, ') ') AS location ,
             A.job_salary AS salary,
             A.job_description AS description,
             A.job_other_requirement AS other_requirement,
             DATE_FORMAT(A.job_start_working, '%d/%m/%Y') AS job_start_working,

             CO.email AS 'jc_email',
             CO.office_name_english AS 'jc_office_name',
             CO.address AS 'jc_address',
             TRIM(TRAILING ', , ' FROM TRIM(TRAILING ', , , ' FROM  (CONCAT(CO.contact_no1,', ',CO.contact_no2,', ', CO.contact_no3,', ', CO.contact_no4)))) AS 'jc_contacts',

          (SELECT lang_name AS job_language FROM nea_language  L WHERE L.lang_id=A.job_lang) AS job_language,
          (SELECT lang_level_name AS job_languge_level FROM nea_language_level  LL WHERE LL.lang_level_id= A.job_lang_level) AS job_language_level,
          (SELECT degree_name AS job_education FROM nea_degree_equal  edu WHERE edu.degree_id=A.job_degree) AS job_education,
          (SELECT major_eng AS job_major  FROM nea_major  major WHERE major.major_id=A.job_major) AS job_major,

    (SELECT title_en AS job_name FROM isco_definition WHERE A.job_title=isco_definition.isco_code) AS job_name,
    (SELECT job_term_name AS job_term_name FROM nea_job_term_history T WHERE T.job_term_id=A.job_term) AS job_term_name,
     A.job_no_vacancy AS vacancy_num,
     DATE_FORMAT(job_close_date, '%d/%m/%Y') AS close_date,
        A.job_how_apply   AS how_to_apply,
     (SELECT org_name AS employer FROM nea_organization_profile org WHERE org.user_id=A.user_id )AS employer,
     (SELECT org_address  AS employer_address FROM nea_organization_profile org WHERE org.user_id=A.user_id )AS employer_address,
     (SELECT org_profile_details  AS employer_profile_details FROM nea_organization_profile org WHERE org.user_id=A.user_id )AS employer_profile_details
     FROM
            nea_job A
            LEFT JOIN nea_job_location B ON B.job_id=A.job_id
            LEFT JOIN nea_location_history LH ON LH.location_id=B.job_location
            LEFT JOIN  nea_job_center_office CO ON CO.location_id=LH.jc_refer


     WHERE  A.job_close_date  >= CURDATE() 
	 ORDER BY A.job_create_date DESC LIMIT 0,10 
			GROUP BY A.vacancy_id 
			ORDER BY A.job_create_date DESC
			LIMIT 0,10";
			

        return $query = $this->db->query($sqlStr);
    }

//Back up old version
/*
    function get_job_by_id_api($job_id = '')
    {
        $sqlStr = " SELECT A.job_id, GROUP_CONCAT(B.job_location ) AS location_id, ". "
              GROUP_CONCAT(LH.location_name,'(', B.job_no_vacancy, ') ') AS location ,
             A.job_salary AS salary,
             A.job_description AS description,
             A.job_other_requirement AS other_requirement,
             DATE_FORMAT(A.job_start_working, '%d/%m/%Y') AS job_start_working,

             CO.email AS 'jc_email',
             CO.office_name_english AS 'jc_office_name',
             CO.address AS 'jc_address',
             TRIM(TRAILING ', , ' FROM TRIM(TRAILING ', , , ' FROM  (CONCAT(CO.contact_no1,', ',CO.contact_no2,', ', CO.contact_no3,', ', CO.contact_no4)))) AS 'jc_contacts',

          (SELECT lang_name AS job_language FROM nea_language  L WHERE L.lang_id=A.job_lang) AS job_language,
          (SELECT lang_level_name AS job_languge_level FROM nea_language_level  LL WHERE LL.lang_level_id= A.job_lang_level) AS job_language_level,
          (SELECT degree_name AS job_education FROM nea_degree_equal  edu WHERE edu.degree_id=A.job_degree) AS job_education,
          (SELECT major_eng AS job_major  FROM nea_major  major WHERE major.major_id=A.job_major) AS job_major,

    (SELECT title_en AS job_name FROM isco_definition WHERE A.job_title=isco_definition.isco_code) AS job_name,
    (SELECT job_term_name AS job_term_name FROM nea_job_term_history T WHERE T.job_term_id=A.job_term) AS job_term_name,
     A.job_no_vacancy AS vacancy_num,
     DATE_FORMAT(job_close_date, '%d/%m/%Y') AS close_date,
        A.job_how_apply   AS how_to_apply,
     (SELECT org_name AS employer FROM nea_organization_profile org WHERE org.user_id=A.user_id )AS employer,
     (SELECT org_address  AS employer_address FROM nea_organization_profile org WHERE org.user_id=A.user_id )AS employer_address,
     (SELECT org_profile_details  AS employer_profile_details FROM nea_organization_profile org WHERE org.user_id=A.user_id )AS employer_profile_details
     FROM
            nea_job A
            LEFT JOIN nea_job_location B ON B.job_id=A.job_id
            LEFT JOIN nea_location_history LH ON LH.location_id=B.job_location
            LEFT JOIN  nea_job_center_office CO ON CO.location_id=LH.jc_refer


     WHERE A.job_id = '$job_id'";


        return $query = $this->db->query($sqlStr);
    }
    */
//Mark new version 
    function get_job_by_id_api($job_id = '')
    {
        $sqlStr = " SELECT " . " 
			    A.vacancy_id as job_id,
			    A.job_title AS job_name,
 				REPLACE(B.job_location_eng, '###', ' ,')  as 'location',
			    A.base_wage_min AS salary,
			    A.job_description AS description,
			    A.other_skill_requirement AS other_requirement,
			    DATE_FORMAT(A.working_date, '%d/%m/%Y') AS job_start_working,
			    CO.email AS 'jc_email',
			    CO.office_name_english AS 'jc_office_name',
			    CO.address AS 'jc_address',
			   	CONCAT(CO.contact_no1,',',CO.contact_no2,',',CO.contact_no3,
			                    ', ',
			                    CO.contact_no4) AS 'jc_contacts',
				GROUP_CONCAT((select name_english as job_language from language where language.language_id=LL.language_id)) AS job_language,
						GROUP_CONCAT((select name_english as job_language_level from language_level where language_level.language_level_id=LL.language_level_id )) AS job_language_level,
			
			    EDU.name_english AS job_education,
			    
			(SELECT 
			         name_english AS job_major FROM isced WHERE isced.isced_id=A.isced_id) AS job_major,
			
			    (SELECT 
			            job_term_name AS job_term_name
			        FROM
			            nea_job_term_history T
			        WHERE
			            T.job_term_id = A.hour_of_work) AS job_term_name,
			    (SELECT 
			            SUM(B.number_vacancy) AS 'vacancy_num'
			        FROM
			            vacancy_location B
			        WHERE
			            A.vacancy_id = B.vacancy_id) AS 'vacancy_num',
			    DATE_FORMAT(A.closing_date, '%d/%m/%Y') AS close_date,
			    A.how_to_apply AS how_to_apply,
				em.name AS employer,
			    em.address AS employer_address,
			    em.profile AS employer_profile_details
			FROM vacancy A
				LEFT JOIN
					jobshop_vacancies B ON B.vacancy_id = A.vacancy_id
				LEFT JOIN
					vacancy_language LL ON LL.vacancy_id = A.vacancy_id
			    LEFT JOIN 
					nea_job_center_office CO ON CO.location_id = A.jc_id
					OR (CO.jc_id  = 0 )

			    LEFT JOIN employer em ON em.employer_id = A.employer_id
				LEFT JOIN education_degree EDU ON EDU.education_degree_id=A.minimum_education_degree_id 
			WHERE
			  
			    A.vacancy_id = '$job_id' ";
        return $query = $this->db->query($sqlStr);
    }
	
	// --- Mark vacancy detail // updated 
	function get_job_by_id_api_kh($job_id = '')
    {
        $sqlStr = " SELECT  
			    A.vacancy_id as job_id,
			    A.job_title AS job_name,
 				REPLACE(B.job_location_kh, '###', ' ,')  as 'location',
			    A.base_wage_min AS salary,
			    A.job_description AS description,
			    A.other_skill_requirement AS other_requirement,
			    DATE_FORMAT(A.working_date, '%d/%m/%Y') AS job_start_working,
			    CO.email AS 'jc_email',
			    CO.office_name_khmer AS 'jc_office_name',
			    CO.address_khmer AS 'jc_address',
			   	CONCAT(CO.contact_no1,',',CO.contact_no2,',',CO.contact_no3,
			                    ', ',
			                    CO.contact_no4) AS 'jc_contacts',
				CONCAT((select name_khmer as job_language from language where language.language_id=LL.language_id)) AS job_language,
						CONCAT((select name_khmer as job_language_level from language_level where language_level.language_level_id=LL.language_level_id)) AS job_language_level,
			
			    EDU.name_khmer AS job_education,
			    
			(SELECT 
			         name_khmer AS job_major FROM isced WHERE isced.isced_id=A.isced_id) AS job_major,
			
			    (SELECT 
			            job_term_name_khmer AS job_term_name
			        FROM
			            nea_job_term_history T
			        WHERE
			            T.job_term_id = A.hour_of_work) AS job_term_name,
			    (SELECT 
			            SUM(B.number_vacancy) AS 'vacancy_num'
			        FROM
			            vacancy_location B
			        WHERE
			            A.vacancy_id = B.vacancy_id) AS 'vacancy_num',
			    DATE_FORMAT(A.closing_date, '%d/%m/%Y') AS close_date,
			    A.how_to_apply AS how_to_apply,
				em.name AS employer,
			    em.address AS employer_address,
			    em.profile AS employer_profile_details
			FROM vacancy A
				LEFT JOIN
					jobshop_vacancies B ON B.vacancy_id = A.vacancy_id
				LEFT JOIN
					vacancy_language LL ON LL.vacancy_id = A.vacancy_id
			    LEFT JOIN 
					nea_job_center_office CO ON CO.location_id = A.jc_id
					OR (CO.jc_id  = 0 )

			    LEFT JOIN employer em ON em.employer_id = A.employer_id
				LEFT JOIN education_degree EDU ON EDU.education_degree_id=A.minimum_education_degree_id 
			WHERE
			  
			    A.vacancy_id = '$job_id'
			GROUP BY A.vacancy_id

				";


        return $query = $this->db->query($sqlStr);
    }
    /* -- Mark BACK UP
    function get_job_by_id_api_kh($job_id = '')
    {
        $sqlStr = " SELECT A.job_id, GROUP_CONCAT(B.job_location ) AS location_id, ". "
              GROUP_CONCAT(LH.location_name_khmer,'(', B.job_no_vacancy, ') ') AS location ,
             A.job_salary AS salary,
             A.job_description AS description,
             A.job_other_requirement AS other_requirement,
             DATE_FORMAT(A.job_start_working, '%d/%m/%Y') AS job_start_working,

             CO.email AS 'jc_email',
             CO.office_name_khmer AS 'jc_office_name',
             CO.address_khmer AS 'jc_address',
             TRIM(TRAILING ', , ' FROM TRIM(TRAILING ', , , ' FROM  (CONCAT(CO.contact_no1,', ',CO.contact_no2,', ', CO.contact_no3,', ', CO.contact_no4)))) AS 'jc_contacts',

          (SELECT lang_name_khmer AS job_language FROM nea_language  L WHERE L.lang_id=A.job_lang) AS job_language,
          (SELECT lang_level_name_khmer AS job_languge_level FROM nea_language_level  LL WHERE LL.lang_level_id= A.job_lang_level) AS job_language_level,
          (SELECT degree_name_khmer AS job_education FROM nea_degree_equal  edu WHERE edu.degree_id=A.job_degree) AS job_education,
          (SELECT major_kh AS job_major  FROM nea_major  major WHERE major.major_id=A.job_major) AS job_major,

	(SELECT title_kh AS job_name_khmer FROM isco_definition WHERE A.job_title=isco_definition.isco_code) AS job_name,
    (SELECT job_term_name_khmer AS job_term_name FROM nea_job_term_history T WHERE T.job_term_id=A.job_term) AS job_term_name,
     A.job_no_vacancy AS vacancy_num,
     DATE_FORMAT(job_close_date, '%d/%m/%Y') AS close_date,
        A.job_how_apply   AS how_to_apply,
     (SELECT org_name AS employer FROM nea_organization_profile org WHERE org.user_id=A.user_id )AS employer,
     (SELECT org_address  AS employer_address FROM nea_organization_profile org WHERE org.user_id=A.user_id )AS employer_address,
     (SELECT org_profile_details  AS employer_profile_details FROM nea_organization_profile org WHERE org.user_id=A.user_id )AS employer_profile_details
     FROM
            nea_job A
            LEFT JOIN nea_job_location B ON B.job_id=A.job_id
            LEFT JOIN nea_location_history LH ON LH.location_id=B.job_location
            LEFT JOIN  nea_job_center_office CO ON CO.location_id=LH.jc_refer


     WHERE A.job_id = '$job_id'";


        return $query = $this->db->query($sqlStr);
    }
*/

// Mark --- new api
    function get_job_by_jobtitle_industry_location_api($jobtitle='',$jobindustry='',$joblocationid=''){
        $sqlStr = " SELECT ".
        " nea_organization_profile . org_name  AS  employer , ".
        "  nea_job . job_id                     AS  job_id ,
          nea_job . user_id                    AS  user_id ,
          isco_definition . title_en           AS  job_name ,
          isco_definition . title_kh           AS  job_name_kh ,
          nea_job . job_no_vacancy             AS  vacancy_num ,
           DATEDIFF(CURDATE(),nea_job.job_create_date) AS duration_day,
          nea_job.job_salary 			       AS salary,
          (SELECT job_term_name AS job_term_name FROM nea_job_term_history T WHERE T.job_term_id=nea_job.job_term) AS job_term_name,
          DATE_FORMAT(nea_job . job_close_date, '%d/%m/%Y')	AS  close_date ,
	      GROUP_CONCAT(  nea_location_history . location_name ,' (',  nea_job_location . job_no_vacancy ,')' SEPARATOR ',') AS  location
      FROM
       (((((
       nea_job_location LEFT JOIN  nea_job ON ((  nea_job_location . job_id  =   nea_job . job_id )))
        LEFT JOIN  isco_definition ON ((  nea_job . job_title  =   isco_definition . isco_code )))
        LEFT JOIN  nea_location_history ON ((  nea_job_location . job_location  =   nea_location_history . location_id )))
        LEFT JOIN  nea_organization_profile ON ((  nea_job . user_id  =   nea_organization_profile . user_id )))
	    LEFT JOIN  nea_industry_category ON ((  nea_industry_category .indus_cat_id  =   nea_organization_profile . org_industry )))

      WHERE    ";
        // For job title isco level 1 and 2 task
        if ($jobtitle!='') {
            if($jobtitle<=9){
                $sqlStr .= "  SUBSTRING(nea_job.job_title,1,1) LIKE '%$jobtitle%' ";
            }
            else{
                $sqlStr .= "  SUBSTRING(nea_job.job_title,1,2) LIKE '%$jobtitle%' ";
            }
        }
        else{
            $sqlStr .= "   nea_job.job_title LIKE '%$jobtitle%' ";
        }
        if ($jobindustry!='') {
            if($jobindustry<=9) {
                $sqlStr .= "   AND  SUBSTRING(nea_organization_profile.org_industry,1,1) LIKE '%$jobindustry%' ";
            }
            else{
                $sqlStr .= "   AND  SUBSTRING(nea_organization_profile.org_industry,1,2) LIKE '%$jobindustry%' ";
            }

        }
        else{
            $sqlStr .= " ";
        }
        if ($joblocationid !='') {

            $sqlStr .= " AND nea_job_location.job_location = '$joblocationid'";
        } else {
            $sqlStr .= " ";
        }
        $sqlStr .= " AND nea_job.job_close_date>=CURDATE() ";
        $sqlStr .= " GROUP BY  nea_job . job_id  ORDER BY nea_job.job_create_date DESC LIMIT 0,100 ";
        return $query = $this->db->query($sqlStr);

    }
    
    // Working 13/09/2017
     function get_job_by_jobtitle_industry_location_api_bk($jobtitle='',$jobindustry='',$joblocationid=''){
        $sqlStr = " SELECT      
			A.vacancy_id AS 'job_id',
			E.job_title,
			E.job_title AS 'job_name',
			D.name_khmer AS 'job_name_kh',
			C.name AS 'employer',
			(SELECT SUM(B.number_vacancy) AS 'vacancy_num' FROM vacancy_location B WHERE A.vacancy_id=B.vacancy_id) AS   'vacancy_num',
			DATEDIFF(CURDATE(),A.job_create_date) AS 'duration_day', 
			DATE_FORMAT(A.working_date , '%d/%m/%Y') AS 'job_start_working',
			  DATE_FORMAT(A.closing_date, '%d/%m/%Y')	AS  close_date , 
			CONCAT( A.base_wage_min, ' ', A.base_wage_max) AS 'salary',	
(SELECT job_term_name AS job_term_name FROM nea_job_term_history T WHERE T.job_term_id=A.hour_of_work) AS job_term_name,		
(SELECT job_term_name_khmer AS job_term_name_khmer FROM nea_job_term_history T WHERE T.job_term_id=A.hour_of_work) AS job_term_name_khmer,
			 REPLACE(E.job_location_eng, '###', ' ,')  as 'location',
REPLACE(E.job_location_kh, '###', ' ,')  as 'location_khmer'
				 
			FROM vacancy A 
			INNER JOIN vacancy_location B ON A.vacancy_id=B.vacancy_id
			INNER JOIN employer C ON A.employer_id = C.employer_id
			INNER JOIN isco D ON A.job_title_isco_id = D.isco_id 
			INNER JOIN jobshop_vacancies E ON E.vacancy_id=A.vacancy_id 
			INNER JOIN isic F ON C.sector_isic_id = F.isic_id 
			INNER JOIN location_new G ON G.id=B.location_id  ".
			
	" WHERE    ";
        // For job title isco level 1 and 2 task
        if ($jobtitle!='') {
        
        if($jobtitle<=9){
                $sqlStr .= "  SUBSTRING(D.isco_code,1,1) LIKE '%$jobtitle%'";
            }
            else{
                $sqlStr .= "  SUBSTRING(D.isco_code,1,4) LIKE '%$jobtitle%' AND D.level=4 ";
            }
        }
        else{
            $sqlStr .= " ";
        }
        /*
        if ($jobindustry!='') {
            if($jobindustry<=21) {
                $sqlStr .= "   AND  F.isic_id_api LIKE '%$jobindustry%' AND F.level=1 ";
            }
            else{
                $sqlStr .= " SUBSTRING(D.isco_code,1,4) LIKE '%$jobtitle%'  ";
            }
        }
        else{
            $sqlStr .= " ";
        }
        */
        if ($joblocationid !='') {
        	$var_location = "";
        
          switch ($joblocationid) {
		    case 1:
		        $var_location=101;
		        break;
		   case 2:
		        $var_location=102;
		        break;
		   case 3:
		        $var_location=103;
		        break;
		   case 4:
		        $var_location=104;
		        break;
		   case 5:
		        $var_location=105;
		        break;
		   case 6:
		        $var_location=106;
		        break;
		   case 7:
		        $var_location=107;
		        break;
		   case 8:
		        $var_location=108;
		        break;
		   case 9:
		        $var_location=123;
		        break;
		   case 10:
		        $var_location=109;
		        break;
		   case 11:
		        $var_location=110;
		        break;
		   case 12:
		        $var_location=111;
		        break;
		   case 13:
		        $var_location=122;
		        break;
		   case 14:
		        $var_location=124;
		        break;
		   case 15:
		        $var_location=112;
		        break;
		   case 16:
		        $var_location=118;
		        break;
		   case 17:
		        $var_location=113;
		        break;
		   case 18:
		        $var_location=114;
		        break;
		   case 19:
		        $var_location=115;
		        break;
		   case 20:
		        $var_location=116;
		        break;
		   case 21:
		        $var_location=117;
		        break;
		   case 22:
		        $var_location=119;
		        break;
		   case 23:
		        $var_location=120;
		        break;
		   case 24:
		        $var_location=121;
		        break;
		   case 25:
		        $var_location=125;
		        break;
		    default:
		    	$var_location=112;
        
		}
		
		
	    //if($jobtitle=="" && $jobindustry=="" ){
	    if($jobtitle=="" ){
	    
                  $sqlStr .= " SUBSTRING(B.location_id,1,3) LIKE '%$var_location%'  ";
            }
            else{
                   $sqlStr .= " AND SUBSTRING(B.location_id,1,3) LIKE '%$var_location%'  ";
            }
            	
        } else {
            $sqlStr .= " ";
        }
        $sqlStr .= " AND A.closing_date>=CURDATE()  ";
        $sqlStr .= " GROUP BY A.vacancy_id  ORDER BY A.vacancy_id DESC LIMIT 0,100 ";
        return $query = $this->db->query($sqlStr);

    }
	 function get_job_by_jobtitle_industry_location_api_kh($jobtitle='',$jobindustry='',$joblocationid=''){
        $sqlStr = " SELECT ".
        " nea_organization_profile . org_name  AS  employer , ".
        "  nea_job . job_id                     AS  job_id ,
          nea_job . user_id                    AS  user_id ,
          isco_definition . title_kh           AS  job_name ,
          nea_job . job_no_vacancy             AS  vacancy_num ,
           DATEDIFF(CURDATE(),nea_job.job_create_date) AS duration_day,
          nea_job.job_salary 			       AS salary,
          (SELECT job_term_name_khmer AS job_term_name FROM nea_job_term_history T WHERE T.job_term_id=nea_job.job_term) AS job_term_name,
          DATE_FORMAT(nea_job . job_close_date, '%d/%m/%Y')	AS  close_date ,
	      GROUP_CONCAT(  nea_location_history . location_name_khmer ,' (',  nea_job_location . job_no_vacancy ,')' SEPARATOR ',') AS  location
      FROM
       (((((
       nea_job_location LEFT JOIN  nea_job ON ((  nea_job_location . job_id  =   nea_job . job_id )))
        LEFT JOIN  isco_definition ON ((  nea_job . job_title  =   isco_definition . isco_code )))
        LEFT JOIN  nea_location_history ON ((  nea_job_location . job_location  =   nea_location_history . location_id )))
        LEFT JOIN  nea_organization_profile ON ((  nea_job . user_id  =   nea_organization_profile . user_id )))
	    LEFT JOIN  nea_industry_category ON ((  nea_industry_category .indus_cat_id  =   nea_organization_profile . org_industry )))

      WHERE    ";
        // For job title isco level 1 and 2 task
        if ($jobtitle!='') {
            if($jobtitle<=9){
                $sqlStr .= "  SUBSTRING(nea_job.job_title,1,1) LIKE '%$jobtitle%' ";
            }
            else{
                $sqlStr .= "  SUBSTRING(nea_job.job_title,1,2) LIKE '%$jobtitle%' ";
            }
        }
        else{
            $sqlStr .= "   nea_job.job_title LIKE '%$jobtitle%' ";
        }
        if ($jobindustry!='') {
            if($jobindustry<=9) {
                $sqlStr .= "   AND  SUBSTRING(nea_organization_profile.org_industry,1,1) LIKE '%$jobindustry%' ";
            }
            else{
                $sqlStr .= "   AND  SUBSTRING(nea_organization_profile.org_industry,1,2) LIKE '%$jobindustry%' ";
            }

        }
        else{
            $sqlStr .= " ";
        }
        if ($joblocationid !='') {

            $sqlStr .= " AND nea_job_location.job_location = '$joblocationid'";
        } else {
            $sqlStr .= " ";
        }
        $sqlStr .= " AND nea_job.job_close_date>=CURDATE() ";
        $sqlStr .= " GROUP BY  nea_job . job_id  ORDER BY nea_job.job_create_date DESC LIMIT 0,100 ";
        return $query = $this->db->query($sqlStr);

    }

    function live_vacancies(){
     //-- MARK OLD DATABASE $sqlStr=" SELECT SUM(job_no_vacancy) AS total_vacancy FROM nea_job WHERE job_close_date  >= CURDATE()"; OLD BACKUP
     
        $sqlStr="  SELECT SUM(B.number_vacancy) AS 'total_vacancy' FROM vacancy A LEFT JOIN vacancy_location B ON A.vacancy_id=B.vacancy_id WHERE A.closing_date>=CURDATE()";
        return $query = $this->db->query($sqlStr);
    }

    function get_contact_us_api(){
        $sqlStr ="SELECT A.*, TRIM(TRAILING ', , ' FROM TRIM(TRAILING ', , , ' FROM  (CONCAT(A.contact_no1,', ',A.contact_no2,', ',A.contact_no3,', ',A.contact_no4)))) AS 'contacts' FROM nea_job_center_office A ORDER BY A.id ASC ";
        return $query = $this->db->query($sqlStr);
    }

    function insert_log_request($data){
        $this->db->insert('nea_android_job_log',$data);
    }
    
    /* Mark --- Retrive job seeker by occupation */
    
    function get_js_by_isco_1($var=0){
	    $sqlStr=" SELECT A.isco_id, A.isco_code, A.name_english, A.name_khmer,A.level, ".
	    " IF(A.level = 4, (SELECT COUNT(*) FROM resume_job_wanted B WHERE B.occupation_isco_id = 	A.isco_id), (SELECT COUNT(*) FROM resume_job_wanted C WHERE C.occupation_isco_id IN (SELECT D.isco_id FROM isco D WHERE D.level_code LIKE CONCAT(A.level_code,'=>%')))) AS 'total_seeker' ". 
	    " FROM isco A WHERE A.level IN ($var) ORDER BY A.isco_id ASC ";
    return $query = $this->db->query($sqlStr);
    }
    
    
    /* Mark --- retrived job seekers by Location */
    function get_js_by_location(){
   	 $sqlStr =" SELECT location_id,location_en,location_kh,total_job FROM jobshop_location ORDER BY total_job DESC ";
   	 return $query = $this->db->query($sqlStr);
    }
    	
    /* Mark --- retrived job seekers by Education */
    function get_js_by_education(){
   	 $sqlStr =" SELECT education_degree_id as 'edu_id', name_english, name_khmer, total_education as 'total_js',types FROM jobshop_seeker_by_education ";
   	 return $query = $this->db->query($sqlStr);
    }
    
    //Mark--- Working on 7/12/2017
     function get_job_by_jobtitle_industry_location_api_jobtitle_location($jobtitle='',$joblocationid=''){
        $sqlStr = " SELECT      
			A.vacancy_id AS 'job_id',
			A.job_title,
			E.job_title AS 'job_name',
			E.isco_name_eng AS 'job_name',
			E.isco_name_kh AS  'job_name_kh',
			C.name AS 'employer',
			(SELECT SUM(B.number_vacancy) AS 'vacancy_num' FROM vacancy_location B WHERE A.vacancy_id=B.vacancy_id) AS   'vacancy_num',
			DATEDIFF(CURDATE(),A.job_create_date) AS 'duration_day', 
			DATE_FORMAT(A.working_date , '%d/%m/%Y') AS 'working_date',
			  DATE_FORMAT(A.closing_date, '%d/%m/%Y')	AS  close_date , 
			CONCAT( A.base_wage_min, ' ', A.base_wage_max) AS 'salary',	
			(SELECT job_term_name AS job_term_name FROM nea_job_term_history T WHERE T.job_term_id=A.hour_of_work) AS job_term_name,		
			(SELECT job_term_name_khmer AS job_term_name_khmer FROM nea_job_term_history T WHERE T.job_term_id=A.hour_of_work) AS job_term_name_khmer,
						 REPLACE(E.job_location_eng, '###', ' ,')  as 'location',
			REPLACE(E.job_location_kh, '###', ' ,')  as 'location_khmer'			 
			FROM vacancy A 
			INNER JOIN vacancy_location B ON A.vacancy_id=B.vacancy_id
			INNER JOIN employer C ON A.employer_id = C.employer_id
			INNER JOIN isco D ON A.job_title_isco_id = D.isco_id 
			INNER JOIN jobshop_vacancies E ON E.vacancy_id=A.vacancy_id 
			INNER JOIN isic F ON C.sector_isic_id = F.isic_id 
			INNER JOIN location_new G ON G.id=B.location_id  ".
			
	" WHERE    ";
        // For job title isco level 1 and 2 task
        if ($jobtitle!='') {
                $sqlStr .= " A.job_title LIKE '%$jobtitle%'";
            }
        else{
            $sqlStr .= " ";
        }
        
      if ($joblocationid !='') {
        	$var_location = "";
        
          switch ($joblocationid) {
		    case 1:
		        $var_location=101;
		        break;
		   case 2:
		        $var_location=102;
		        break;
		   case 3:
		        $var_location=103;
		        break;
		   case 4:
		        $var_location=104;
		        break;
		   case 5:
		        $var_location=105;
		        break;
		   case 6:
		        $var_location=106;
		        break;
		   case 7:
		        $var_location=107;
		        break;
		   case 8:
		        $var_location=108;
		        break;
		   case 9:
		        $var_location=109;
		        break;
		   case 10:
		        $var_location=110;
		        break;
		   case 11:
		        $var_location=111;
		        break;
		   case 12:
		        $var_location=112;
		        break;
		   case 13:
		        $var_location=113;
		        break;
		   case 14:
		        $var_location=114;
		        break;
		   case 15:
		        $var_location=115;
		        break;
		   case 16:
		        $var_location=116;
		        break;
		   case 17:
		        $var_location=117;
		        break;
		   case 18:
		        $var_location=118;
		        break;
		   case 19:
		        $var_location=119;
		        break;
		   case 20:
		        $var_location=120;
		        break;
		   case 21:
		        $var_location=121;
		        break;
		   case 22:
		        $var_location=122;
		        break;
		   case 23:
		        $var_location=123;
		        break;
		   case 24:
		        $var_location=124;
		        break;
		   case 25:
		        $var_location=125;
		        break;
		    default:
		    	$var_location=112;
        
		}
		
		
	    //if($jobtitle=="" && $jobindustry=="" ){
	    if($jobtitle=="" ){
	    
                  $sqlStr .= " FIND_IN_SET($var_location, B.location_id)>0  ";
            }
            else{
                   $sqlStr .= " AND FIND_IN_SET($var_location, B.location_id)>0  ";
            }
            	
            	
        } else { $sqlStr .= " ";}
        $sqlStr .= " AND A.closing_date>=CURDATE()  ";
        $sqlStr .= " GROUP BY A.vacancy_id  ORDER BY A.vacancy_id DESC LIMIT 0,50 ";
        return $query = $this->db->query($sqlStr);

    }
    
/*--Mark --
- Create date: 2017-12-22
- Get latest training course  
*/
    function get_latest_training_course($limit=10,$status=0){
       $sqlStr = " SELECT ". "  
            A.course_id AS ID,
	    A.course_title AS title,
    	    DATE_FORMAT(A.course_enroll_start,'%d/%m/%Y') AS start_enroll,
    	    DATE_FORMAT(A.course_enroll_end,'%d/%m/%Y') AS end_enroll,
	    DATE_FORMAT(A.course_study_start,'%d/%m/%Y') AS start_studying , 
            B.degree_name,
	    B.degree_name_khmer,
	    A.course_fee, 
	    C.inst_name,   
	    L.location_name,
	    L.location_name_khmer  
	FROM nea_training_course A 
	LEFT JOIN nea_degree_history B ON A.course_degree = B.degree_id  
	LEFT JOIN nea_location_history L on A.course_location= L.location_id    
	LEFT JOIN nea_institution_profile C ON C.inst_profile_id =A.inst_id 
	WHERE  A.course_enroll_end  >= CURDATE() 
	AND   A.status  = $status
	ORDER BY A.course_id DESC  
	LIMIT  $limit ";
	return $query = $this->db->query($sqlStr);
    }
   
 
/*--Mark --
- Create date: 2017-12-22
- Get latest scholarship
*/
    function get_latest_scholarship($limit=10,$status=0){
       $sqlStr = " SELECT " .
        "A.scholar_id AS ID,
	    A.scholar_name AS title,
    	DATE_FORMAT(A.scholar_enroll_start,'%d/%m/%Y') AS start_enroll,
    	DATE_FORMAT(A.scholar_enroll_end,'%d/%m/%Y') AS end_enroll,
	    DATE_FORMAT(A.scholar_study_start,'%d/%m/%Y') AS start_studying , 
        B.degree_name,
	    B.degree_name_khmer,
	    A.sponsor_by as sponsor, 
	    C.inst_name,   
	    L.location_name,
	    L.location_name_khmer  
	FROM nea_scholarships A 
	LEFT JOIN nea_degree_history B ON A.scholar_degree = B.degree_id  
	LEFT JOIN nea_location_history L on A.scholar_location= L.location_id    
	LEFT JOIN nea_institution_profile C ON C.inst_profile_id =A.inst_id 
	WHERE  A.scholar_enroll_end  >= CURDATE() 
	AND   A.status  = $status
	ORDER BY A.scholar_id DESC  
	LIMIT  $limit ";
	return $query = $this->db->query($sqlStr);
    }
    
/*--Mark -- Training program and course
- Create date: 2018-08-20
- 
*/ 
    function get_view_course($course_id)
    {
        $sql_str = "SELECT A.*, B.degree_name, B.degree_name_khmer, " .
            " C.location_name, C.location_name_khmer, " .
            " D.major_eng,D.major_kh," .
            " E.institution_eng, E.institution_kh," .
            " F.job_cat_name, F.job_cat_name_khmer," .
            " H.* 
                        FROM nea_training_course A JOIN nea_degree_history B ON A.course_degree = B.degree_id 
                            INNER JOIN nea_location_history C ON A.course_location = C.location_id
                            INNER JOIN nea_major D ON A.course_major = D.major_id 
                            INNER JOIN nea_institution_type E ON A.course_type = E.institution_id
                            INNER JOIN nea_job_category_history F ON A.course_category = F.job_cat_id 
                            INNER JOIN users G ON A.user_id = G.id 
                            LEFT JOIN  nea_institution_profile H ON A. inst_id = H. inst_profile_id 
                        WHERE  course_id = '$course_id' ";

        return $this->db->query($sql_str);
    }
    
    /* Mark created on 17-03-2018 
    Get how_to_apply_by_jobid from table vacancy
    */ 
    
    function get_how_to_apply_by_jobid($job_id=0){
        $this->db->select("*");
        $this->db->where("vacancy_id", $job_id);
        $query = $this->db->get("vacancy",1,0);
        
        if($query->num_rows() > 0) {
            $variable = $query->row("how_to_apply");
            return $variable;    
        } else {
            return FALSE;
        }
    }
    
       /* Mark created on 17-03-2018 
    Get Job description by job id from table vacancy
    */ 
    
    function get_job_description_by_jobid($job_id=0){
        $this->db->select("*");
        $this->db->where("vacancy_id", $job_id);
        $query = $this->db->get("vacancy",1,0);
        
        if($query->num_rows() > 0) {
            $variable = $query->row("job_description");
            return $variable;    
        } else {
            return FALSE;
        }
    }
     function get_province_id_by_jobid($job_id=0){
        $this->db->select("*");
        $this->db->where("vacancy_id", $job_id);
        $query = $this->db->get("vacancy_location",1,0);
        
        if($query->num_rows() > 0) {
            $variable = $query->row("location_id");
            // return substr($variable, 1, 2); 
           // return $variable ;//$this->get_province_id_level_code($variable);
            
            return $this->get_jc_info(substr($variable, 1, 2));
            
        } else {
            return false;
        }
    }
    
    function get_jc_info($code=0){
         $this->db->select("*");
        $this->db->where("jc_id", $code);
        $query = $this->db->get("nea_job_center_office",1,0);
        if($query->num_rows() > 0) {
          return $query->result(); 
            
       } else {
           $this->db->where("jc_id", 12);
           $query = $this->db->get("nea_job_center_office",1,0);
           return $query->result(); 
       }
    }
    
    function getLanguageBy_jobID($job_id=0){
                    $sqlString= " SELECT B.name_english AS 'lang_name_en',B.name_khmer AS 'lang_name_kh',C.name_english as 'lang_name_level_en',C.name_khmer AS 'lang_name_level_kh' FROM vacancy_language AS A left join language B ON A.language_id= B.language_id LEFT JOIN language_level C on C.language_level_id = A.language_level_id WHERE A.vacancy_id= $job_id ";
                    return $query = $this->db->query($sqlString);
    }
    function get_program_course_latest($limit=10){
        $sqlString = " SELECT A.course_id AS 'ID', ". "  
                            A.course_title AS 'title', 
                            A.course_enroll_start AS 'start_enroll' , 
                            A.course_enroll_end AS 'end_enroll', 
                            A.course_study_start AS 'start_studying', 
                            A.course_study_end AS 'end_studying', 
                            A.course_daytime_offer, 
                            A.course_target_audience, 
                            A.course_admission, 
                            A.course_fee, 
                            A.course_description, 
                            A.course_how_enroll, 
                            A.course_date, 
                            B.degree_name,
                            B.degree_name_khmer, 
                            C.location_name, 
                            C.location_name_khmer, 
                            D.major_eng,
                            D.major_kh,
                            E.institution_eng, 
                            E.institution_kh, 
                            F.job_cat_name, 
                            F.job_cat_name_khmer,
                            H.inst_name, 
                            H.inst_address, 
                            H.inst_profile_details, 
                            H.inst_cont_person, 
                            H.inst_office_phone, 
                            H.inst_mobile_phone,
                            H.inst_fax, 
                            H.inst_email, 
                            H.inst_website, 
                            H.inst_photo
                        FROM nea_training_course A 
                            JOIN nea_degree_history B ON A.course_degree = B.degree_id 
                            INNER JOIN nea_location_history C ON A.course_location = C.location_id
                            INNER JOIN nea_major D ON A.course_major = D.major_id 
                            INNER JOIN nea_institution_type E ON A.course_type = E.institution_id
                            INNER JOIN nea_job_category_history F ON A.course_category = F.job_cat_id 
                            INNER JOIN users G ON A.user_id = G.id 
                            LEFT  JOIN nea_institution_profile H ON A.inst_id = H.inst_profile_id
                            WHERE A.course_enroll_end >= CURDATE() ORDER BY A.course_id DESC LIMIT  $limit ";
                    	return $query = $this->db->query($sqlString);
    }
    
  
     function get_latest_scholarship_model($limit=10)
    {
                $this->db->select('A.*');
                $this->db->select(' B.degree_name, B.degree_name_khmer, C.major_eng, C.major_kh, D.location_name, D.location_name_khmer');
                $this->db->select('F.inst_name,F.inst_address,F.inst_email,F.inst_website,F.inst_profile_details');
                $this->db->select('G.institution_eng,G.institution_kh');
        
                $this->db->from('nea_scholarships A');
                $this->db->join('nea_degree_history B', 'A.scholar_degree = B.degree_id', 'LEFT');
                $this->db->join('nea_major C', 'A.scholar_major = C.major_id', 'left');
                $this->db->join('nea_location_history D', 'A.scholar_location = D.location_id', 'LEFT');
                $this->db->join('users E', 'E.id=A.user_id', 'LEFT');
                $this->db->join('nea_institution_profile F', 'F.inst_profile_id=A.inst_id', 'LEFT');
                $this->db->join('nea_institution_type G', 'G.institution_id=F.inst_type', 'LEFT');
                $this->db->where('A.scholar_enroll_end >=',date('y-m-d'));
               // $this->db->where('A.user_id', $user_id);
               
                $this->db->order_by('A.scholar_id  DESC');
                $this->db->limit($limit);
            
                return $this->db->get();
    }
//  MARK ---------------------------- Get all Location  ----------------------------------
    function get_all_location_app(){
        $this->db->select("A.locationID"); 
        $this->db->select("A.locationNameKh");
        $this->db->select("A.locationNameEn");
        $this->db->select("A.jcRef,A.mapLatLong,A.mapZome");
        $this->db->from("location_app A");
        $this->db->order_by("A.locationID ASC");
        return $this->db->get();
    }
      //  MARK ---------------------------- Get all Sector ----------------------------------
      function get_all_valiad_job_app_model($limit=10,$offset=0){
        $this->db->select("A.vacancy_id");
        $this->db->select("A.job_title,A.job_title_isco_code, A.isco_name_eng");
        $this->db->select("A.isco_name_kh,A.job_location_eng,A.job_location_kh");
        $this->db->select("A.languages,A.closing_date,A.ORG_NAME,A.employer_id");
        $this->db->select("A.total_vacancy,A.job_start_working,A.duration_day");
        $this->db->select("A.job_salary"); 
        $this->db->select("B.base_wage_min");
        $this->db->select("B.job_create_date");
        $this->db->select("B.other_skill_requirement");
        $this->db->select("B.other_preference");
        $this->db->select("B.job_description");
        $this->db->select("B.how_to_apply");
        $this->db->select("C.degree_name");
        $this->db->select("C.degree_name_khmer");
        $this->db->select("D.name_english AS isced_name");
        $this->db->select("D.name_khmer   AS isced_name_kh");
        $this->db->select("B.minimum_work_experience AS minWorkExp");
        $this->db->select("E.name_english AS isic_name");
        $this->db->select("F.name_english AS form_employment_name");
        $this->db->select("F.name_khmer AS form_employment_name_kh");
        $this->db->select("G.job_term_name AS job_term_name,G.job_term_name_khmer AS job_term_name_khmer,");
        $this->db->select("A.pictures");
        $this->db->from("jobshop_vacancies A");
        $this->db->join("vacancy B","A.vacancy_id = B.vacancy_id","LEFT");
        $this->db->join("nea_degree_history C", "C.degree_id = B.minimum_education_degree_id", "Left");
        $this->db->join("isced D","B.isced_id=D.isced_id","left");
        $this->db->join("isic E", "E.isic_id=B.work_experience_isic_id","left");
        $this->db->join("form_of_employment F "," F.form_of_employment_id = B.form_of_employment_id" , "Left");
        $this->db->join("nea_job_term_history G"," G.job_term_id=B.term_of_employment_contract","Left");
        $this->db->order_by("A.vacancy_id DESC");
        $this->db->group_by("A.vacancy_id");
        $this->db->limit($limit,$offset);
        return $this->db->get();
    }
    
  //  MARK ---------------------------- Get all Sector ----------------------------------
      function get_all_valiad_job_model_by_education($limit=10,$offset=0, $edu){
        $this->db->select("A.vacancy_id");
        $this->db->select("A.job_title,A.job_title_isco_code, A.isco_name_eng");
        $this->db->select("A.isco_name_kh,A.job_location_eng,A.job_location_kh");
        $this->db->select("A.languages,A.closing_date,A.ORG_NAME,A.employer_id");
        $this->db->select("A.total_vacancy,A.job_start_working,A.duration_day");
        $this->db->select("A.job_salary"); 
        $this->db->select("B.base_wage_min");
        $this->db->select("B.job_create_date");
        $this->db->select("B.other_skill_requirement");
        $this->db->select("B.other_preference");
        $this->db->select("B.job_description");
        $this->db->select("B.how_to_apply");
        $this->db->select("C.degree_name");
        $this->db->select("C.degree_name_khmer");
        $this->db->select("D.name_english AS isced_name");
        $this->db->select("D.name_khmer   AS isced_name_kh");
        $this->db->select("B.minimum_work_experience AS minWorkExp");
        $this->db->select("E.name_english AS isic_name");
        $this->db->select("F.name_english AS form_employment_name");
        $this->db->select("F.name_khmer AS form_employment_name_kh");
        $this->db->select("G.job_term_name AS job_term_name,G.job_term_name_khmer AS job_term_name_khmer,");
        $this->db->select("A.pictures");
        $this->db->from("jobshop_vacancies A");
        $this->db->join("vacancy B","A.vacancy_id = B.vacancy_id","LEFT");
        $this->db->join("nea_degree_history C", "C.degree_id = B.minimum_education_degree_id", "Left");
        $this->db->join("isced D","B.isced_id=D.isced_id","left");
        $this->db->join("isic E", "E.isic_id=B.work_experience_isic_id","left");
        $this->db->join("form_of_employment F "," F.form_of_employment_id = B.form_of_employment_id" , "Left");
        $this->db->join("nea_job_term_history G"," G.job_term_id=B.term_of_employment_contract","Left");
        $this->db->where("C.degree_id", $edu);
        // $this->db->like("B.minimum_education_degree_id", $edu);
        $this->db->order_by("A.vacancy_id DESC");
        $this->db->group_by("A.vacancy_id");
        $this->db->limit($limit,$offset);
        return $this->db->get();
    }
    
    
    //  MARK ---------------------------- Get all Sector ----------------------------------
      function get_all_valiad_job_model_by_sector($limit=10,$offset=0, $keyId){
        $this->db->select("A.vacancy_id");
        $this->db->select("A.job_title,A.job_title_isco_code, A.isco_name_eng");
        $this->db->select("A.isco_name_kh,A.job_location_eng,A.job_location_kh");
        $this->db->select("A.languages,A.closing_date,A.ORG_NAME,A.employer_id");
        $this->db->select("A.total_vacancy,A.job_start_working,A.duration_day");
        $this->db->select("A.job_salary"); 
        $this->db->select("B.base_wage_min");
        $this->db->select("B.job_create_date");
        $this->db->select("B.other_skill_requirement");
        $this->db->select("B.other_preference");
        $this->db->select("B.job_description");
        $this->db->select("B.how_to_apply");
        $this->db->select("C.degree_name");
        $this->db->select("C.degree_name_khmer");
        $this->db->select("D.name_english AS isced_name");
        $this->db->select("D.name_khmer   AS isced_name_kh");
        $this->db->select("B.minimum_work_experience AS minWorkExp");
        $this->db->select("E.name_english AS isic_name");
        $this->db->select("F.name_english AS form_employment_name");
        $this->db->select("F.name_khmer AS form_employment_name_kh");
        $this->db->select("G.job_term_name AS job_term_name,G.job_term_name_khmer AS job_term_name_khmer,");
        $this->db->select("A.pictures");
        $this->db->from("jobshop_vacancies A");
        $this->db->join("vacancy B","A.vacancy_id = B.vacancy_id","LEFT");
        $this->db->join("nea_degree_history C", "C.degree_id = B.minimum_education_degree_id", "Left");
        $this->db->join("isced D","B.isced_id=D.isced_id","left");
        $this->db->join("isic E", "E.isic_id=B.work_experience_isic_id","left");
        $this->db->join("form_of_employment F "," F.form_of_employment_id = B.form_of_employment_id" , "Left");
        $this->db->join("nea_job_term_history G"," G.job_term_id=B.term_of_employment_contract","Left");
        // $this->db->where("A.job_title_isco_code", $keyId);
        $this->db->like("A.isic_level_code", $keyId);
        $this->db->order_by("A.vacancy_id DESC");
        $this->db->group_by("A.vacancy_id");
        $this->db->limit($limit,$offset);
        return $this->db->get();
    }
    
//  MARK ---------------------------- Get all By SECTOR 30-10-2019    ----------------------------------
      function get_all_valiad_job_occu($limit=10,$offset=0,$isco_level){
        $this->db->select("A.vacancy_id");
        $this->db->select("A.job_title,A.job_title_isco_code, A.isco_name_eng");
        $this->db->select("A.isco_name_kh,A.job_location_eng,A.job_location_kh");
        $this->db->select("A.languages,A.closing_date,A.ORG_NAME,A.employer_id");
        $this->db->select("A.total_vacancy,A.job_start_working,A.duration_day");
        $this->db->select("A.job_salary"); 
        $this->db->select("B.base_wage_min");
        $this->db->select("B.job_create_date");
        $this->db->select("B.other_skill_requirement");
        $this->db->select("B.other_preference");
        $this->db->select("B.job_description");
        $this->db->select("B.how_to_apply");
        $this->db->select("C.degree_name");
        $this->db->select("C.degree_name_khmer");
        $this->db->select("D.name_english AS isced_name");
        $this->db->select("D.name_khmer   AS isced_name_kh");
        $this->db->select("B.minimum_work_experience AS minWorkExp");
        $this->db->select("E.name_english AS isic_name");
        $this->db->select("F.name_english AS form_employment_name");
        $this->db->select("F.name_khmer AS form_employment_name_kh");
        $this->db->select("G.job_term_name AS job_term_name,G.job_term_name_khmer AS job_term_name_khmer,");
        $this->db->select("A.pictures");
        $this->db->from("jobshop_vacancies A");
        $this->db->join("vacancy B","A.vacancy_id = B.vacancy_id","LEFT");
        $this->db->join("isco Z","A.job_title_isco_code = Z.isco_id","LEFT");
        $this->db->join("nea_degree_history C", "C.degree_id = B.minimum_education_degree_id", "Left");
        $this->db->join("isced D","B.isced_id=D.isced_id","left");
        $this->db->join("isic E", "E.isic_id=B.work_experience_isic_id","left");
        $this->db->join("form_of_employment F "," F.form_of_employment_id = B.form_of_employment_id" , "Left");
        $this->db->join("nea_job_term_history G"," G.job_term_id=B.term_of_employment_contract","Left");
        // $this->db->where('Z.level_code',$isco_level);
        $this->db->like('Z.level_code',$isco_level);
        $this->db->order_by("A.vacancy_id DESC");
        $this->db->group_by("A.vacancy_id");
        $this->db->limit($limit,$offset);
        return $this->db->get();
    }
    
    //  MARK ---------------------------- Get all Sector ----------------------------------
      function get_all_valiad_job_model_by_location($limit=10,$offset=0, $keyId){
        $this->db->select("A.vacancy_id");
        $this->db->select("A.job_title,A.job_title_isco_code, A.isco_name_eng");
        $this->db->select("A.isco_name_kh,A.job_location_eng,A.job_location_kh");
        $this->db->select("A.languages,A.closing_date,A.ORG_NAME,A.employer_id");
        $this->db->select("A.total_vacancy,A.job_start_working,A.duration_day");
        $this->db->select("A.job_salary"); 
        $this->db->select("B.base_wage_min");
        $this->db->select("B.job_create_date");
        $this->db->select("B.other_skill_requirement");
        $this->db->select("B.other_preference");
        $this->db->select("B.job_description");
        $this->db->select("B.how_to_apply");
        $this->db->select("C.degree_name");
        $this->db->select("C.degree_name_khmer");
        $this->db->select("D.name_english AS isced_name");
        $this->db->select("D.name_khmer   AS isced_name_kh");
        $this->db->select("B.minimum_work_experience AS minWorkExp");
        $this->db->select("E.name_english AS isic_name");
        $this->db->select("F.name_english AS form_employment_name");
        $this->db->select("F.name_khmer AS form_employment_name_kh");
        $this->db->select("G.job_term_name AS job_term_name,G.job_term_name_khmer AS job_term_name_khmer,");
        $this->db->select("A.pictures");
        $this->db->from("jobshop_vacancies A");
        $this->db->join("vacancy B","A.vacancy_id = B.vacancy_id","LEFT");
        $this->db->join("nea_degree_history C", "C.degree_id = B.minimum_education_degree_id", "Left");
        $this->db->join("isced D","B.isced_id=D.isced_id","left");
        $this->db->join("isic E", "E.isic_id=B.work_experience_isic_id","left");
        $this->db->join("form_of_employment F "," F.form_of_employment_id = B.form_of_employment_id" , "Left");
        $this->db->join("nea_job_term_history G"," G.job_term_id=B.term_of_employment_contract","Left");
        $this->db->where("A.job_location_id", $keyId);
        $this->db->order_by("A.vacancy_id DESC");
        $this->db->group_by("A.vacancy_id");
        $this->db->limit($limit,$offset);
        return $this->db->get();
    }
    
        //  MARK ---------------------------- Get all Sector ----------------------------------
      function get_all_valiad_job_model_by_occu($limit=10,$offset=0, $keyId){
        $this->db->select("A.vacancy_id");
        $this->db->select("A.job_title,A.job_title_isco_code, A.isco_name_eng");
        $this->db->select("A.isco_name_kh,A.job_location_eng,A.job_location_kh");
        $this->db->select("A.languages,A.closing_date,A.ORG_NAME,A.employer_id");
        $this->db->select("A.total_vacancy,A.job_start_working,A.duration_day");
        $this->db->select("A.job_salary"); 
        $this->db->select("B.base_wage_min");
        $this->db->select("B.job_create_date");
        $this->db->select("B.other_skill_requirement");
        $this->db->select("B.other_preference");
        $this->db->select("B.job_description");
        $this->db->select("B.how_to_apply");
        $this->db->select("C.degree_name");
        $this->db->select("C.degree_name_khmer");
        $this->db->select("D.name_english AS isced_name");
        $this->db->select("D.name_khmer   AS isced_name_kh");
        $this->db->select("B.minimum_work_experience AS minWorkExp");
        $this->db->select("E.name_english AS isic_name");
        $this->db->select("F.name_english AS form_employment_name");
        $this->db->select("F.name_khmer AS form_employment_name_kh");
        $this->db->select("G.job_term_name AS job_term_name,G.job_term_name_khmer AS job_term_name_khmer,");
        $this->db->select("A.pictures");
        $this->db->from("jobshop_vacancies A");
        $this->db->join("vacancy B","A.vacancy_id = B.vacancy_id","LEFT");
        $this->db->join("nea_degree_history C", "C.degree_id = B.minimum_education_degree_id", "Left");
        $this->db->join("isced D","B.isced_id=D.isced_id","left");
        $this->db->join("isic E", "E.isic_id=B.work_experience_isic_id","left");
        $this->db->join("form_of_employment F "," F.form_of_employment_id = B.form_of_employment_id" , "Left");
        $this->db->join("nea_job_term_history G"," G.job_term_id=B.term_of_employment_contract","Left");
        $this->db->where("A.isic_level_code", $keyId);
        $this->db->order_by("A.vacancy_id DESC");
        $this->db->group_by("A.vacancy_id");
        $this->db->limit($limit,$offset);
        return $this->db->get();
    }
    
    function getJobCenterInfoByJOBID($job_id=0){
   
      
        $this->db->select("*");
        $this->db->where("vacancy_id", $job_id);
        $query = $this->db->get("vacancy_location",1,0);
        $variable = $query->row("location_id");
        if($query->num_rows() > 0) {
            return $this->get_jc_info_by_location_id(substr($variable, 1, 2));
        } else {
            return  $this->get_jc_info_by_location_id(12);
        }
    }
    
    function getJobCenterByJobID($job_id=0){
        $this->db->select("*");
        $this->db->where("vacancy_id", $job_id);
        $query = $this->db->get("vacancy_location",1,0);
        $variable = $query->row("location_id");
        if($query->num_rows() > 0) {
            return $this->get_jc_info_by_location_id(substr($variable, 1, 2));
        } else {
            return $this->get_jc_info_by_location_id(substr(112, 1, 2));
        }
    }
	
    function get_jc_info_by_location_id($code=0){
        
            if( in_array($code, array(4,5,8,9,10,11,13,15,16,19,22,23,24,25)) ){
                  $code = 12 ;// Phnom Penh Job Center 
            }else{
              $code = $code;  
            }
        
         $this->db->select("A.office_name_english AS JcName");
         $this->db->select("A.office_name_khmer AS JcNameKh");
         $this->db->select("A.address AS JcAdd");
         $this->db->select("A.address_khmer AS JcAddKh");
         $this->db->select("A.contact_no1 AS JcContac1");
         $this->db->select("A.contact_no2 AS JcContac2");
         $this->db->select("A.contact_no3 AS JcContac3");
         $this->db->select("A.email AS JcEmail");
         $this->db->select("A.image AS JcImage");
         $this->db->select("A.let AS JcLat");
         $this->db->select("A.lon AS JcLong");
         
        
         $query = $this->db->get("nea_job_center_office A",1,0);
        if($query->num_rows() > 0) {
          $this->db->where("jc_id", $code);
         $query = $this->db->get("nea_job_center_office A",1,0);
         return $query->result();  
       } else {
           $this->db->where("jc_id", 12);
              $query = $this->db->get("nea_job_center_office A",1,0);
         return $query->result(); 
       }
       
    
    }
    //--- Mark Employer Infomation 
    
    //---Mark Employer Proile //----- Updated
	function getEmployerInfoByJobIDModel($job_id=0){
	
	    $sqlStr=" SELECT
				  a.employer_id         AS org_id,
				  a.name                AS org_name,
				  c.name_english        AS org_sector,
				  d.name_english        AS org_type_en,
				  a.patent_number       AS org_patent_num,
				  a.total_employee      AS org_num_employ,
				  a.main_job_title      AS org_main_occup,
				  a.address          	AS org_address,
				  a.profile 	    	AS org_background,
				  E.contact_person      AS org_cont_person,
				  E.office_phone   	    AS org_office_phone,
				  E.fax            	    AS org_fax,
				  E.mobile_phone        AS org_mobile,
				  E.email             	AS org_email,
				  E.website          	AS org_website,
				  a.profile ,
				  a.address_longitude   AS org_long,
				  a.address_latitude    AS org_let,
				  a.pictures            AS image_logo
				  
				FROM employer a
					 INNER JOIN vacancy b ON  b.employer_id = a.employer_id 
					 LEFT JOIN isic c ON c.isic_id = a.sector_isic_id
					 LEFT JOIN employer_type d ON d.employer_type_id = a.employer_type_id
					 LEFT JOIN employer_reference E ON E.employer_id = a.employer_id 
				WHERE b.vacancy_id='$job_id'
				GROUP BY a.employer_id ";
		 return $query = $this->db->query($sqlStr);		
	}

	// Plan for job search next 
	 function get_all_search_job_app_model($limit=10,$offset=0,$keywork=''){
        $this->db->select("A.vacancy_id");
        $this->db->select("A.job_title,A.job_title_isco_code, A.isco_name_eng");
        $this->db->select("A.isco_name_kh,A.job_location_eng,A.job_location_kh");
        $this->db->select("A.languages,A.closing_date,A.ORG_NAME,A.employer_id");
        $this->db->select("A.total_vacancy,A.job_start_working,A.duration_day");
        $this->db->select("A.job_term_name,A.job_term_name_khmer,A.job_salary"); 
        $this->db->select("B.job_create_date");
        $this->db->select("B.other_skill_requirement");
        $this->db->select("B.other_preference");
        $this->db->select("B.job_description");
        $this->db->select("B.how_to_apply");
        $this->db->select("C.degree_name");
        $this->db->select("C.degree_name_khmer");
        $this->db->select("D.name_english AS isced_name");
        $this->db->select("D.name_khmer   AS isced_name_kh");
        $this->db->select("B.minimum_work_experience AS minWorkExp");
        $this->db->select("E.name_english AS isic_name");
        $this->db->select("F.name_english AS form_employment_name");
        $this->db->select("F.name_khmer AS from_employment_name_kh");
        $this->db->select("A.pictures");
        $this->db->from("jobshop_vacancies A");
        $this->db->join("vacancy B","A.vacancy_id = B.vacancy_id","LEFT");
        $this->db->join("nea_degree_history C", "C.degree_id = B.minimum_education_degree_id", "Left");
        $this->db->join("isced D","B.isced_id=D.isced_id","left");
        $this->db->join("isic E", "E.isic_id=B.work_experience_isic_id","left");
        $this->db->join("form_of_employment F "," F.form_of_employment_id = B.form_of_employment_id" , "Left");
        $this->db->order_by("A.vacancy_id DESC");
        $this->db->group_by("A.vacancy_id");
        $this->db->limit($limit,$offset);
        return $this->db->get();
    }
    	
	function searchJobTitle($search=''){
	    
	    $search_exploded = explode ( " ", $search ); $x = 0;
	    foreach( $search_exploded as $search_each ) {
	        $x++; $construct = " "; 
	        if( $x == 1 ) $construct .= " job_title LIKE '%$search_each%' OR  isco_name_eng LIKE '%$search_each%' "; 
	        else $construct .= " AND job_title LIKE '%$search_each%' ";
	     }


	    $sqlStr = " select * from jobshop_vacancies where  $construct      limit 5 ";
	    return $query = $this->db->query($sqlStr);	
	}
	
	//  MARK ---------------------------- Get all latest jobs ----------------------------------
      function get_all_valiad_job_app_model_Search_Location1($limit=10,$offset=0){
       
         $search_exploded = explode ( " ", $search ); $x = 0;
	    foreach( $search_exploded as $search_each ) {
	        $x++; $construct = " "; 
	        if( $x == 1 ) $construct .= " job_title LIKE '%$search_each%' OR  isco_name_eng LIKE '%$search_each%' "; 
	        else $construct .= " AND job_title LIKE '%$search_each%' ";
	     }
	     
        $this->db->select("A.vacancy_id");
        $this->db->select("A.job_title,A.job_title_isco_code, A.isco_name_eng");
        $this->db->select("A.isco_name_kh,A.job_location_eng,A.job_location_kh");
        $this->db->select("A.languages,A.closing_date,A.ORG_NAME,A.employer_id");
        $this->db->select("A.total_vacancy,A.job_start_working,A.duration_day");
        $this->db->select("A.job_salary"); 
        $this->db->select("B.base_wage_min");
        $this->db->select("B.job_create_date");
        $this->db->select("B.other_skill_requirement");
        $this->db->select("B.other_preference");
        $this->db->select("B.job_description");
        $this->db->select("B.how_to_apply");
        $this->db->select("C.degree_name");
        $this->db->select("C.degree_name_khmer");
        $this->db->select("D.name_english AS isced_name");
        $this->db->select("D.name_khmer   AS isced_name_kh");
        $this->db->select("B.minimum_work_experience AS minWorkExp");
        $this->db->select("E.name_english AS isic_name");
        $this->db->select("F.name_english AS form_employment_name");
        $this->db->select("F.name_khmer AS form_employment_name_kh");
        $this->db->select("G.job_term_name AS job_term_name,G.job_term_name_khmer AS job_term_name_khmer,");
        $this->db->select("A.pictures");
        $this->db->from("jobshop_vacancies A");
        $this->db->join("vacancy B","A.vacancy_id = B.vacancy_id","LEFT");
        $this->db->join("nea_degree_history C", "C.degree_id = B.minimum_education_degree_id", "Left");
        $this->db->join("isced D","B.isced_id=D.isced_id","left");
        $this->db->join("isic E", "E.isic_id=B.work_experience_isic_id","left");
        $this->db->join("form_of_employment F "," F.form_of_employment_id = B.form_of_employment_id" , "Left");
        $this->db->join("nea_job_term_history G"," G.job_term_id=B.term_of_employment_contract","Left");
        $this->db->order_by("A.vacancy_id DESC");
        $this->db->group_by("A.vacancy_id");
        $this->db->limit($limit,$offset);
        return $this->db->get();
    }
    
        //Mark--- Working on 13/09/2019
     function Job_Search_Location_Model($jobtitle='',$joblocationid=''){
            $date = date('Y/m/d');
        $sqlStr = " SELECT      
                    		A.vacancy_id,
                            A.job_title,
                            A.job_title_isco_code,
                            A.isco_name_eng,
                            A.isco_name_kh,
                            A.job_location_eng,
                            A.job_location_kh,
                            A.languages,
                            A.closing_date,
                            A.ORG_NAME,
                            A.employer_id,
                            A.total_vacancy,
                            A.job_start_working,
                            A.duration_day,
                            A.job_salary, 
                            B.base_wage_min,
                            B.job_create_date,
                            B.other_skill_requirement,
                            B.other_preference,
                            B.job_description,
                            B.how_to_apply,
                            C.degree_name,
                            C.degree_name_khmer,
                            D.name_english AS isced_name,
                            D.name_khmer   AS isced_name_kh,
                            B.minimum_work_experience AS minWorkExp,
                            E.name_english AS isic_name,
                            F.name_english AS form_employment_name,
                            F.name_khmer AS form_employment_name_kh,
                            G.job_term_name AS job_term_name,
                            G.job_term_name_khmer AS job_term_name_khmer,
                            A.pictures
        
			FROM  jobshop_vacancies A
            LEFT JOIN vacancy B ON A.vacancy_id = B.vacancy_id 
            LEFT JOIN nea_degree_history C ON C.degree_id = B.minimum_education_degree_id 
            LEFT JOIN isced D ON B.isced_id = D.isced_id 
            LEFT JOIN isic E ON E.isic_id = B.work_experience_isic_id 
            LEFT JOIN form_of_employment F ON  F.form_of_employment_id = B.form_of_employment_id 
            LEFT JOIN nea_job_term_history G ON  G.job_term_id = B.term_of_employment_contract 
             " .
            //LEFT JOIN vacancy_location H ON H.vacancy_id = A.vacancy_id " .
	        " WHERE ";
             // For job title isco level 1 and 2 task
                 if ($jobtitle!='') {
              //  $sqlStr .= " A.job_title LIKE '%$jobtitle%'";
              
                 $search_exploded = explode ( " ", $jobtitle ); $x = 0;
	            foreach( $search_exploded as $search_each ) {
            	        $x++; $construct = " "; 
            	        if( $x == 1 ) $construct .= " A.job_title LIKE '%$search_each%'  "; // OR  A.isco_name_eng LIKE '%$search_each%'
            	        else $construct .= " OR A.job_title LIKE '%$search_each%' ";
	        
	                     $sqlStr .= $construct;
	                 }
                  }
                else{
                 $sqlStr .= " ";
                }
        
             if ($joblocationid !='') {
         
        	    $var_location =  $joblocationid;

	        if($jobtitle=="" ){
	    
              $sqlStr .= "  A.job_location_id = '$var_location'  ";
            }
            else{
                   $sqlStr .= " AND  A.job_location_id =  '$var_location'   ";
            }
            	
        } else { 
            $sqlStr .= " "; 
            
        }
        
      //  $sqlStr .= " AND A.closing_date >= $date";
      //  $sqlStr .= " ORDER BY A.vacancy_id DESC LIMIT 0, 20 ";
        return $query = $this->db->query($sqlStr);
        
    }
    function getISICListModel($level1,$level4){
        $this->db->select("isic_id AS ISICID,
                            name_english AS ISICName,
                            name_khmer AS ISICNameKh, 
                            section  ");

         $this->db->from("isic");
         $this->db->where("level",$level1);
          if (!empty($level4)){
             $this->db->or_where("level",$level4);
          }
         return $this->db->get();
    }
    
    
    
    function getISCOListModel(){
        $this->db->select("isco_id,isco_code,name_english,name_khmer");
        $this->db->from("isco");
    
        $this->db->where("level",1);
         $this->db->or_where("level",4);
        $this->db->group_by("isco_code");
        $this->db->limit(400);
        return $this->db->get();
    }
    function getISCOListModelSearch($name=''){
        $this->db->select("isco_id as iscoID,isco_code as iscoCode,name_english as iscoName,name_khmer as iscoNameKh");
        $this->db->from("isco");
    
        $this->db->where("level",1);
         $this->db->or_where("level",4);
         $this->db->like('name_english', $name);
        $this->db->group_by("isco_code");
        $this->db->limit(400);
        return $this->db->get();
    }
    
    function getJobTitleModelSearch($jobtitle=''){
       // SELECT vacancy_id,job_title, isco_name_eng FROM `jobshop_vacancies` WHERE closing_date>=now()
       $sqlStr = " SELECT      
                    		A.vacancy_id AS VacID,
                            A.job_title AS VacTitle,
                            A.isco_name_eng AS VacISCOTitle,
                            A.job_location_eng AS VacJobLocation
                        	FROM  jobshop_vacancies A WHERE ";
        if ($jobtitle!='') {
              
              
                 $search_exploded = explode ( " ", $jobtitle ); $x = 0;
	            foreach( $search_exploded as $search_each ) {
            	        $x++; $construct = " "; 
            	        if( $x == 1 ) $construct .= " A.job_title LIKE '%$search_each%'  "; 
            	        else $construct .= " AND A.isco_name_eng LIKE '%$search_each%'  ";
	        
	                     $sqlStr .= $construct;
	                 }
	                 
	         $sqlStr .= " AND ";
            }
        else{
             $sqlStr .= " ";
            }
            
          $sqlStr .= "   A.closing_date>=CURDATE()  ";
          $sqlStr .= " GROUP BY A.job_title ";
        return $query = $this->db->query($sqlStr);
    }
    
    
    
    
    
    
    
    
       //Mark--- Working on 13/09/2019
     function get_job_by_title_loc_isco_sector_bk($keyword,$location, $isco,$sector){
       $this->db->select("A.vacancy_id");
        $this->db->select("A.job_title,A.job_title_isco_code, A.isco_name_eng");
        $this->db->select("A.isco_name_kh,A.job_location_eng,A.job_location_kh");
        $this->db->select("A.languages,A.closing_date,A.ORG_NAME,A.employer_id");
        $this->db->select("A.total_vacancy,A.job_start_working,A.duration_day");
        $this->db->select("A.job_salary"); 
        $this->db->select("B.base_wage_min");
        $this->db->select("B.job_create_date");
        $this->db->select("B.other_skill_requirement");
        $this->db->select("B.other_preference");
        $this->db->select("B.job_description");
        $this->db->select("B.how_to_apply");
        $this->db->select("C.degree_name");
        $this->db->select("C.degree_name_khmer");
        $this->db->select("D.name_english AS isced_name");
        $this->db->select("D.name_khmer   AS isced_name_kh");
        $this->db->select("B.minimum_work_experience AS minWorkExp");
        $this->db->select("E.name_english AS isic_name");
        $this->db->select("F.name_english AS form_employment_name");
        $this->db->select("F.name_khmer AS form_employment_name_kh");
        $this->db->select("G.job_term_name AS job_term_name,G.job_term_name_khmer AS job_term_name_khmer,");
        $this->db->select("A.pictures");
        $this->db->from("jobshop_vacancies A");
        $this->db->join("vacancy B","A.vacancy_id = B.vacancy_id");
        
        $this->db->join("nea_degree_history C", "C.degree_id = B.minimum_education_degree_id");
        $this->db->join("isced D","B.isced_id=D.isced_id","left");
        $this->db->join("isic E", "E.isic_id=B.work_experience_isic_id","left");
        $this->db->join("form_of_employment F "," F.form_of_employment_id = B.form_of_employment_id" );
        $this->db->join("nea_job_term_history G"," G.job_term_id=B.term_of_employment_contract");
        $this->db->join("vacancy_location H"," A.vacancy_id=H.vacancy_id");
        
                if(!empty($keyword)) {
                    
                /*if($location == '0' AND empty($sector)){
                        $this->db->or_like('B.other_preference', $keyword);
                        $this->db->or_like('B.job_description', $keyword);
                        $this->db->or_like('A.isco_name_eng', $keyword);
                         $this->db->or_like('A.isco_name_kh', $keyword);
                 }else{
                 */
                    $this->db->or_like('A.job_title', $keyword, 'both');
                    $this->db->or_like('A.isco_name_eng', $keyword, 'both');
                   $this->db->or_like('A.isco_name_kh', $keyword, 'both');
                    $this->db->or_like("B.job_description", $keyword, 'both');
                    $this->db->or_like("A.job_location_eng", $keyword, 'both');
               
                }
                
            
            if (!empty($isco)){
            $this->db->like('A.isco_name_eng', $isco); 
            }
          
            if(!empty($sector)){
                    $var_str = "A.isic_level_code";
                    $this->db->like('A.isic_level_code', $sector);
             }
        
        
      
    
    
       /* if(!empty($keyword)) {
               // $this->db->group_start();
              
               // $this->db->group_end();
         }
         */
         
     
        if($location > '0'){
                $this->db->like('H.location_id',$location);
            
            }
    
            // $this->db->where('A.closing_date >=',date('y-m-d', false));
            $this->db->where('A.closing_date >=',date('Y-m-d'));
            $this->db->order_by("A.vacancy_id DESC");
            $this->db->group_by("A.vacancy_id");
            //$this->db->limit(30);
        return $this->db->get();
    

    }
    
    function getEventSoftSkill($type=0){
        $this->db->select("A.event_id as id");
          $this->db->select("A.event_type as type");
            $this->db->select("A.title_kh as titleKh");
              $this->db->select("A.title_en as titleEn");
                $this->db->select("A.location_kh as locationKh");
                  $this->db->select("A.location_en as locationEn");
                  $this->db->select("A.event_body_kh as eventBodyKh");
                  $this->db->select("A.event_body_en as eventBodyEn");
                  $this->db->select("A.event_date as eventDate");
                  $this->db->select("A.event_date_end as eventDateEnd");
                  $this->db->select("A.source_kh as source");
                  $this->db->select("A.picture_banner as imageBanner");
                  $this->db->select("A.pictures as image");
        $this->db->from("tb_upcoming_event A");
        
        $this->db->where("A.event_type",$type);
               $this->db->order_by("A.event_id","DESC");
       // $this->db->where('A.event_date >=',date('y-m-d'));
        $this->db->limit(5);
        return $this->db->get();
    }
    
    function getEventSoftSkill_V1($type=0){
        $this->db->select("A.event_id as id");
          $this->db->select("A.event_type as type");
            $this->db->select("A.title_kh as titleKh");
              $this->db->select("A.title_en as titleEn");
                $this->db->select("A.location_kh as softSkillTypeKh");
                  $this->db->select("A.location_en as softSkillTypeEn");
                  $this->db->select("A.event_body_kh as eventBodyKh");
                  $this->db->select("A.event_body_en as eventBodyEn");
                  $this->db->select("A.event_date as eventDate");
                  $this->db->select("A.event_date_end as eventDateEnd");
                  $this->db->select("A.source_kh as source");
                  $this->db->select("A.picture_banner as imageBanner");
                  $this->db->select("A.pictures as image");
        $this->db->from("tb_upcoming_event A");
        
        $this->db->where("A.event_type",$type);
               $this->db->order_by("A.event_id","DESC");
       // $this->db->where('A.event_date >=',date('y-m-d'));
        $this->db->limit(5);
        return $this->db->get();
    }
    
    
    function getJobSectorList(){
                    $this->db->select(" isic_id AS ISICID,
                            name_english AS ISICTitle,
                            name_khmer AS ISICTitleKh,
                            total_job AS ISICTotal,
                            isic_code AS ISICSetor");
                    $this->db->from("jobshop_vacancies_by_isic A");
                 return $this->db->get();
    }
    
     function get_source_api(){
        $sqlStr ="SELECT A.*   FROM resource_nea_doc A ORDER BY A.id ASC ";
        return $query = $this->db->query($sqlStr);
    }
    
    function JobId_onsearch_Model($vi) {
        $this->db->select("A.vacancy_id");
        $this->db->select("A.job_title,A.job_title_isco_code, A.isco_name_eng");
        $this->db->select("A.isco_name_kh,A.job_location_eng,A.job_location_kh");
        $this->db->select("A.languages,A.closing_date,A.ORG_NAME,A.employer_id");
        $this->db->select("A.total_vacancy,A.job_start_working,A.duration_day");
        $this->db->select("A.job_salary"); 
        $this->db->select("B.base_wage_min");
        $this->db->select("B.job_create_date");
        $this->db->select("B.other_skill_requirement");
        $this->db->select("B.other_preference");
        $this->db->select("B.job_description");
        $this->db->select("B.how_to_apply");
        $this->db->select("C.degree_name");
        $this->db->select("C.degree_name_khmer");
        $this->db->select("D.name_english AS isced_name");
        $this->db->select("D.name_khmer   AS isced_name_kh");
        $this->db->select("B.minimum_work_experience AS minWorkExp");
        $this->db->select("E.name_english AS isic_name");
        $this->db->select("F.name_english AS form_employment_name");
        $this->db->select("F.name_khmer AS form_employment_name_kh");
        $this->db->select("G.job_term_name AS job_term_name,G.job_term_name_khmer AS job_term_name_khmer,");
        $this->db->select("A.pictures");
        $this->db->from("jobshop_vacancies A");
        $this->db->join("vacancy B","A.vacancy_id = B.vacancy_id","LEFT");
        $this->db->join("nea_degree_history C", "C.degree_id = B.minimum_education_degree_id", "Left");
        $this->db->join("isced D","B.isced_id=D.isced_id","left");
        $this->db->join("isic E", "E.isic_id=B.work_experience_isic_id","left");
        $this->db->join("form_of_employment F "," F.form_of_employment_id = B.form_of_employment_id" , "Left");
        $this->db->join("nea_job_term_history G"," G.job_term_id=B.term_of_employment_contract","Left");
        $this->db->where('A.vacancy_id', $vi);
        $this->db->order_by("A.vacancy_id DESC");
        $this->db->group_by("A.vacancy_id");

        return $this->db->get();
        
    }
    
    function GetAllUpcomingEvent() {
	    $sqlStr=" SELECT
				  a.event_id                     AS eventId,
				  a.event_type                   AS eventtype,
				  a.title_kh                     AS titleKh,
				  a.title_en                     AS titleEn,
				  a.location_kh                  AS locationKh,
				  a.event_body_kh               AS eventBodyKh,
				  a.event_date                  AS eventDate,
				  a.event_date_end          	AS eventDateEnd,
				  a.source_kh 	               	AS sourceKh,
				  a.source_en                   AS sourceEn,
				  a.pictures   	                AS pictures
	
				FROM tb_upcoming_event a

				WHERE a.event_type = 42 AND a.event_date >= CURDATE() ";
				
		 return $query = $this->db->query($sqlStr);
    }
    
    function UpcomingEvent() {

	    $sqlStr=" SELECT
				  a.event_id                     AS eventId,
				  a.event_type                   AS eventtype,
				  a.title_kh                     AS titleKh,
				  a.title_en                     AS titleEn,
				  a.location_kh                  AS locationKh,
				  a.event_body_kh               AS eventBodyKh,
				  a.event_date                  AS eventDate,
				  a.event_date_end          	AS eventDateEnd,
				  a.source_kh 	               	AS sourceKh,
				  a.source_en                   AS sourceEn,
				  a.pictures   	                AS pictures
		
				  
				FROM tb_upcoming_event a

				WHERE a.event_type = 41 AND a.event_date >= CURDATE() ";
				
		 return $query = $this->db->query($sqlStr);
    }
    
    
       //Mark--- Working on 13/09/2019
     function get_job_by_title_loc_isco_sector($keyword,$location, $isco,$sector){
       $this->db->select("A.vacancy_id");
        $this->db->select("A.job_title,A.job_title_isco_code, A.isco_name_eng");
        $this->db->select("A.isco_name_kh,A.job_location_eng,A.job_location_kh");
        $this->db->select("A.languages,A.closing_date,A.ORG_NAME,A.employer_id");
        $this->db->select("A.total_vacancy,A.job_start_working,A.duration_day");
        $this->db->select("A.job_salary"); 
        $this->db->select("B.base_wage_min");
        $this->db->select("B.job_create_date");
        $this->db->select("B.other_skill_requirement");
        $this->db->select("B.other_preference");
        $this->db->select("B.job_description");
        $this->db->select("B.how_to_apply");
        $this->db->select("C.degree_name");
        $this->db->select("C.degree_name_khmer");
        $this->db->select("D.name_english AS isced_name");
        $this->db->select("D.name_khmer   AS isced_name_kh");
        $this->db->select("B.minimum_work_experience AS minWorkExp, B.minimum_education_degree_id AS degree_id");
        $this->db->select("B.form_of_employment_id");
        $this->db->select("B.term_of_employment_contract");
         $this->db->select("B.term_of_employment_contract  AS employment_contract");
        
        $this->db->select("E.name_english AS isic_name");
        $this->db->select("F.name_english AS form_employment_name");
        $this->db->select("F.name_khmer AS form_employment_name_kh");
        $this->db->select("G.job_term_name AS job_term_name,G.job_term_name_khmer AS job_term_name_khmer,");
        $this->db->select("A.pictures");
        $this->db->from("jobshop_vacancies A");
        $this->db->join("vacancy B","A.vacancy_id = B.vacancy_id");
        
        $this->db->join("nea_degree_history C", "C.degree_id = B.minimum_education_degree_id");
        $this->db->join("isced D","B.isced_id=D.isced_id","left");
        $this->db->join("isic E", "E.isic_id=B.work_experience_isic_id","left");
         $this->db->join("form_of_employment F "," F.form_of_employment_id = B.form_of_employment_id" );
        $this->db->join("nea_job_term_history G"," G.job_term_id=B.term_of_employment_contract");
        $this->db->join("vacancy_location H"," A.vacancy_id=H.vacancy_id");
        
                if(!empty($keyword)) {
                    
                /*if($location == '0' AND empty($sector)){
                        $this->db->or_like('B.other_preference', $keyword);
                        $this->db->or_like('B.job_description', $keyword);
                        $this->db->or_like('A.isco_name_eng', $keyword);
                         $this->db->or_like('A.isco_name_kh', $keyword);
                 }else{
                 */
                       $this->db->like('A.job_title', $keyword);
               
                }
                
            
            if (!empty($isco)){
            $this->db->like('A.isco_name_eng', $isco); 
            }
          
            if(!empty($sector)){
                    $var_str = "A.isic_level_code";
                    $this->db->like('A.isic_level_code', $sector);
             }
        
        
      
    
    
       /* if(!empty($keyword)) {
               // $this->db->group_start();
              
               // $this->db->group_end();
         }
         */
         
     
        if($location > '0'){
                $this->db->like('H.location_id',$location);
            
            }
    
            // $this->db->where('A.closing_date >=',date('y-m-d', false));
            $this->db->where('A.closing_date >=',date('Y-m-d'));
            $this->db->order_by("A.vacancy_id DESC");
            $this->db->group_by("A.vacancy_id");
            //$this->db->limit(10);
        return $this->db->get();
    

    }
    
    function get_degree_history($field_id){
        if (!empty($field_id )) {
            $sqlStr ="SELECT degree_name, degree_name_khmer    FROM nea_degree_history WHERE degree_id = ".$field_id;
            $query = $this->db->query($sqlStr);
             return $ret = $query->row();
        }     
    }
    
    
    function get_employment($field_id){
        if (!empty($field_id )) {
            $sqlStr ="SELECT name_english, name_khmer FROM form_of_employment WHERE form_of_employment_id = ".$field_id;
            $query = $this->db->query($sqlStr);
             return $ret = $query->row();
        }
    }
    
    
    function get_term_of_employment($field_id){
        if (!empty($field_id )) {
            $sqlStr ="SELECT job_term_name, job_term_name_khmer FROM nea_job_term_history WHERE job_term_id = ".$field_id;
            $query = $this->db->query($sqlStr);
             return $ret = $query->row();
        }
    }
    
    
    function get_job_center_api($begin,$perpage){
        $sqlStr ="SELECT A.*, TRIM(TRAILING ', , ' FROM TRIM(TRAILING ', , , ' FROM  (CONCAT(A.contact_no1,', ',A.contact_no2,', ',A.contact_no3,', ',A.contact_no4)))) AS 'contacts' FROM nea_job_center_office A ORDER BY A.id ASC  LIMIT $begin  OFFSET $perpage ";
        return $query = $this->db->query($sqlStr);
    }
    
      //Mark--- Working on 20/01/2020
     function get_job_by_title_loc_isco_sectorPage($begin,$perpage,$keyword,$location, $isco,$sector){
       $this->db->select("A.vacancy_id");
        $this->db->select("A.job_title,A.job_title_isco_code, A.isco_name_eng");
        $this->db->select("A.isco_name_kh,A.job_location_eng,A.job_location_kh");
        $this->db->select("A.languages,A.closing_date,A.ORG_NAME,A.employer_id");
        $this->db->select("A.total_vacancy,A.job_start_working,A.duration_day");
        $this->db->select("A.job_salary"); 
        $this->db->select("B.base_wage_min");
        $this->db->select("B.job_create_date");
        $this->db->select("B.other_skill_requirement");
        $this->db->select("B.other_preference");
        $this->db->select("B.job_description");
        $this->db->select("B.how_to_apply");
        $this->db->select("C.degree_name");
        $this->db->select("C.degree_name_khmer");
        $this->db->select("D.name_english AS isced_name");
        $this->db->select("D.name_khmer   AS isced_name_kh");
        $this->db->select("B.minimum_work_experience AS minWorkExp, B.minimum_education_degree_id AS degree_id");
        $this->db->select("B.form_of_employment_id");
        $this->db->select("B.term_of_employment_contract");
         $this->db->select("B.term_of_employment_contract  AS employment_contract");
        
        $this->db->select("E.name_english AS isic_name");
        $this->db->select("F.name_english AS form_employment_name");
        $this->db->select("F.name_khmer AS form_employment_name_kh");
        $this->db->select("G.job_term_name AS job_term_name,G.job_term_name_khmer AS job_term_name_khmer,");
        $this->db->select("A.pictures");
        $this->db->from("jobshop_vacancies A");
        $this->db->join("vacancy B","A.vacancy_id = B.vacancy_id");
        
        $this->db->join("nea_degree_history C", "C.degree_id = B.minimum_education_degree_id");
        $this->db->join("isced D","B.isced_id=D.isced_id","left");
        $this->db->join("isic E", "E.isic_id=B.work_experience_isic_id","left");
         $this->db->join("form_of_employment F "," F.form_of_employment_id = B.form_of_employment_id" );
        $this->db->join("nea_job_term_history G"," G.job_term_id=B.term_of_employment_contract");
        $this->db->join("vacancy_location H"," A.vacancy_id=H.vacancy_id");
        
                if(!empty($keyword)) {
                    
                /*if($location == '0' AND empty($sector)){
                        $this->db->or_like('B.other_preference', $keyword);
                        $this->db->or_like('B.job_description', $keyword);
                        $this->db->or_like('A.isco_name_eng', $keyword);
                         $this->db->or_like('A.isco_name_kh', $keyword);
                 }else{
                 */
                       $this->db->like('A.job_title', $keyword);
               
                }
                
            
            if (!empty($isco)){
            $this->db->like('A.isco_name_eng', $isco); 
            }
          
            if(!empty($sector)){
                    $var_str = "A.isic_level_code";
                    $this->db->like('A.isic_level_code', $sector);
             }
        
        
      
    
    
       /* if(!empty($keyword)) {
               // $this->db->group_start();
              
               // $this->db->group_end();
         }
         */
         
     
        if($location > '0'){
                $this->db->like('H.location_id',$location);
            
            }
    
            // $this->db->where('A.closing_date >=',date('y-m-d', false));
            $this->db->where('A.closing_date >=',date('Y-m-d'));
            $this->db->order_by("A.vacancy_id DESC");
            $this->db->group_by("A.vacancy_id");
         // $this->db->limit(20);
         
           // if ($begin != '' && $perpage != '') {
                 $this->db->limit($perpage,$begin);
          //  }else{
           //       $this->db->limit(20);
                
           // }
          
          
        return $this->db->get();
    

    }
    
    
    
 }
?>