<?php
/**
 * Created by PhpStorm.
 * User: kimsea
 * Date: 6/19/14
 * Time: 10:52 AM
 */
    class model_location extends CI_Model {


        /*
         *  Select only location level one
         */
        public function select_location_level_one() {

            $this->db->select("level_code, name_english, name_khmer");
            $this->db->from("location_new");
                $this->db->where("level", "1");

            return $this->db->get();
        }

        public function select_location_level_one_two() {

            $this->db->select("*");
            $this->db->from("location_new");
            $where_level = array(1,2);
            $this->db->where_in('level', $where_level);
            $this->db->order_by('level', 'ASC');

            return $this->db->get();
        }

        public function select_location_level($id, $level) {

            $this->db->select("*");
            $this->db->like("level_code",$id."=>", 'after');
            $this->db->where('level',$level);
            $this->db->from("location");

            return $this->db->get();
        }

        public function select_location_one($code) {
            $this->db->select("*");
            $this->db->from("location_new");
            $this->db->where('level_code', $code);

            return $this->db->get();
        }
        
        public function select_nationality() {
            $this->db->select("*");
            $this->db->from("nationality");

            return $this->db->get();
        }

        public function select_all_location() {
            $this->db->select("*");
            $this->db->from("location");

            return $this->db->get();
        }

        public function update($location_id, $data) {
            $this->db->trans_start();
            $this->db->where('location_id', $location_id);
            $this->db->update('location', $data);
            $this->db->trans_complete();
        }

        public function select_province($country_id) {
            $this->db->select("level_code, name_english, name_khmer");
            $this->db->from("location_new");
            $this->db->where("country_id", $country_id);
            $this->db->where("level", "2");
            $this->db->order_by('level', 'ASC');

            return $this->db->get();
        }

        public function select_district($id) {

            $country_id = substr($id, 0, 1);
            $province_id = substr($id, 1, 2);
            $province_id = (int)$province_id;

            $this->db->select("level_code, name_english, name_khmer");
            $this->db->from("location_new");
            $this->db->where("country_id", $country_id);
            $this->db->where("province_id", $province_id);
            $this->db->where("level", "3");
            $this->db->order_by('level', 'ASC');

            return $this->db->get();
        }

        public function select_commune($id) {
            $country_id = substr($id, 0, 1);
            $province_id = substr($id, 1, 2);
            $province_id = (int)$province_id;
            $district_id = substr($id, 3, 2);
            $district_id = (int)$district_id;
            $this->db->order_by('level', 'ASC');

            $this->db->select("level_code, name_english, name_khmer");
            $this->db->from("location_new");
            $this->db->where("country_id", $country_id);
            $this->db->where("province_id", $province_id);
            $this->db->where("district_id", $district_id);
            $this->db->where("level", "4");
            $this->db->order_by('level', 'ASC');

            return $this->db->get();
        }

        public function select_village($id) {
            $country_id = substr($id, 0, 1);
            $province_id = substr($id, 1, 2);
            $province_id = (int)$province_id;
            $district_id = substr($id, 3, 2);
            $district_id = (int)$district_id;
            $commune_id = substr($id, 5, 2);
            $commune_id = (int)$commune_id;

            $this->db->select("level_code, name_english, name_khmer");
            $this->db->from("location_new");
            $this->db->where("country_id", $country_id);
            $this->db->where("province_id", $province_id);
            $this->db->where("district_id", $district_id);
            $this->db->where("commune_id", $commune_id);
            $this->db->where("level", "5");
            $this->db->order_by('level', 'ASC');

            return $this->db->get();
        }
    }