<!doctype html>
<!--[if lt IE 7]>      <html class="no-js lt-ie9 lt-ie8 lt-ie7"> <![endif]-->
<!--[if IE 7]>         <html class="no-js lt-ie9 lt-ie8"> <![endif]-->
<!--[if IE 8]>         <html class="no-js lt-ie9"> <![endif]-->
<!--[if gt IE 8]><!--> <html class="no-js"> <!--<![endif]-->
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
  <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1">
  <?php 
    echo meta('Content-type', 'text/html; charset=utf-8', 'equiv'); 
    echo doctype('html5');
  ?>
  <title><?php echo $page_title ?></title>
  <link rel="shortcut icon" type="image/x-icon" href="<?php echo base_url() ?>images/favicon.ico"/>
  <link rel="apple-touch-icon" href="<?php echo base_url() ?>g-master/apple-icons/apple-touch-icon-precomposed.png" />
  <link rel="apple-touch-icon" sizes="57x57" href="<?php echo base_url() ?>g-master/apple-icons/apple-touch-icon-57x57-precomposed.png" />
  <link rel="apple-touch-icon" sizes="72x72" href="<?php echo base_url() ?>g-master/apple-icons/apple-touch-icon-72x72-precomposed.png" />
  <link rel="apple-touch-icon" sizes="114x114" href="<?php echo base_url() ?>g-master/apple-icons/apple-touch-icon-114x114-precomposed.png" />
  <link rel="apple-touch-icon" sizes="144x144" href="<?php echo base_url() ?>g-master/apple-icons/apple-touch-icon-144x144-precomposed.png" />
  <!-- Modernizr -->
  <script src="<?php echo base_url() ?>g-master/assets/js/libs/modernizr-2.6.2.min.js"></script>
  <!-- jQuery -->
  <script type="text/javascript" src="<?php echo base_url() ?>g-master/assets/js/libs/jquery-1.8.2.min.js"></script>
  <!-- GroundworkCSS -->
  <link type="text/css" rel="stylesheet" href="<?php echo base_url() ?>g-master/assets/css/groundwork.css">
  <!--[if IE]>
  <link type="text/css" rel="stylesheet" href="<?php echo base_url() ?>g-master/assets/css/groundwork-ie.css">
  <![endif]-->
  <!--[if lt IE 9]>
  <script type="text/javascript" src="<?php echo base_url() ?>g-master/assets/js/libs/html5shiv.min.js"></script>
  <![endif]-->
  <!--[if IE 7]>
  <link type="text/css" rel="stylesheet" href="<?php echo base_url() ?>g-master/assets/css/font-awesome-ie7.min.css">
  <![endif]-->
  <script type="text/javascript">
    // extend Modernizr to have datauri test
    (function(){
      var datauri = new Image();
      datauri.onerror = function() {
          Modernizr.addTest('datauri', function () { return false; });
      };
      datauri.onload = function() {
          Modernizr.addTest('datauri', function () { return (datauri.width == 1 && datauri.height == 1); });
          Modernizr.load({
            test: Modernizr.datauri,
            nope: '<?php echo base_url() ?>g-master/assets/css/no-datauri.css'
          });
      };
      datauri.src = "data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==";
    })();
    // fallback if SVG unsupported
    Modernizr.load({
      test: Modernizr.inlinesvg,
      nope: [
        '<?php echo base_url() ?>g-master/assets/css/no-svg.css'
      ]
    });
    // polyfill for HTML5 placeholders
    Modernizr.load({
      test: Modernizr.input.placeholder,
      nope: [
        '<?php echo base_url() ?>g-master/assets/css/placeholder_polyfill.css',
        '<?php echo base_url() ?>g-master/assets/js/libs/placeholder_polyfill.jquery.js'
      ]
    });
  </script>
</head>
<body>
  <header class="white band">
    <div class="container" style="height: 150px;">
        <div style="position: absolute; margin: 13px 0px 0px -36px;">
            <?php echo img(base_url().'images/head1.png') ?>
        </div>
        <br /><br /><br />
        
            <nav class="one third right-two">
                <div class="two third"><input type="text" placeholder="search news" /></div>
                <div class="one third align-right"><button class="block">ស្វែងរក <i class="icon-search"></i></button></div>
                
            </nav>
        
            <nav class="small-tablet pad-top">
              <ul class="nine tenth right-one row">
                <li class="one small-tablet sixth"><a href="#nowhere" title="Lorum ipsum dolor sit amet">NEA</a></li>
                <li class="menu one small-tablet sixth"><a href="#nowhere" title="Aliquam tincidunt mauris eu risus">Job Shop</a>
                  <ul style="display: none;">
                    <li><a href="#nowhere" title="Pellentesque fermentum dolor">Pellentesque</a></li>
                    <li><a href="#nowhere" title="Aliquam tincidunt mauris eu risus">Aliquam</a></li>
                    <li><a href="#nowhere" title="Lorum ipsum dolor sit amet">Lorem</a></li>
                    <li><a href="#nowhere" title="Morbi in sem quis dui placerat ornare">Morbi</a></li>
                  </ul>
                </li>
                <li class="one small-tablet sixth"><a href="#nowhere" title="Praesent dapibus, neque id cursus faucibus">Job Center</a></li>
                <li class="one small-tablet sixth"><a href="#nowhere" title="Praesent dapibus, neque id cursus faucibus">Job Center</a></li>
                <li class="one small-tablet sixth"><a href="#nowhere" title="Morbi in sem quis dui placerat ornare">មគ្គុទេសអាជីព</a></li>
                <li class="one small-tablet sixth"><a href="#nowhere" title="Morbi in sem quis dui placerat ornare">Job Library</a></li>
              </ul>
            </nav>
            
            <div class="seven tenth right-one row">
                <marquee behavior="scroll" onmouseover="this.stop()" onmouseout="this.start()" direction="left" scrollamount="3" style="font-size: 14px;" width="100%" >
                    <a href="#" style="color: white;">This is the news marquy.</a>
                    <a href="#" style="color: green;">This is the news marquy.</a>
                </marquee>
            </div>
        
    </div>
  </header>
  
  <div class="container">

    <article class="row">
      <aside class="one third right-two">
        <?php $this->load->view('lmis/home_graph');?>
      </aside>
      <section class="two third left-one">
          <div class="slider">
            <img src="<?php echo base_url() ?>images/slide2/slide-1.jpg" alt=""/>
            <img src="<?php echo base_url() ?>images/slide2/slide-2.jpg" alt=""/>
            <img src="<?php echo base_url() ?>images/slide2/slide-3.jpg" alt=""/>
            <img src="<?php echo base_url() ?>images/slide2/slide-4.jpg" alt=""/>
            <img src="<?php echo base_url() ?>images/slide2/slide-5.jpg" alt=""/>
            <img src="<?php echo base_url() ?>images/slide2/slide-6.jpg" alt=""/>
            <img src="<?php echo base_url() ?>images/slide2/slide-7.jpg" alt=""/>
          </div>
      </section>
    </article>
    
    <article class="row">
      <section class="one third pad-right pad-bottom">
         <h6><?php echo lang('international_news') ?></h6><hr />
        <?php $i=1; foreach($news_inter->result() as $row) { ?>
            <p style="font-size: 0.9em ;"><span class="icon-double-angle-right"> </span><a href="<?php echo site_url('home_page/home/news_view/'.'12') ?>"><?php echo $row->title_kh;//substr($row->title_kh,0,140);?></a></p>
        <?php if($i>4){break;} $i++; }?>
      </section>
      <section class="one third pad-right pad-bottom">
        <h6><?php echo $this->lang->line('domestic_news') ?></h6><hr />
        <?php $i=1; foreach($news_domes->result() as $row) { ?>
            <p style="font-size: 0.9em ;"><span class="icon-double-angle-right"> </span><a href="<?php echo site_url('home_page/home/news_view/'.'11') ?>"><?php echo substr($row->title_kh,0,140);?></a></p>
        <?php if($i>4){break;} $i++; }?>
      </section>
      <section class="one third pad-bottom">
        <div class="success message" style="background: url(<?php echo base_url('images/jobshop.gif') ?>)repeat;"><center><?php echo lang('jobshop') ?></center></div>
        <table>
            <tr>
                <td>Vacancies:</td>
                <td>00000</td>
            </tr>
            <tr>
                <td>Job Seeker(Height Skill):</td>
                <td>00000</td>
            </tr>
            <tr>
                <td>Job Seeker(Low Skill):</td>
                <td>00000</td>
            </tr>
            <tr>
                <td>Programs/Courses:</td>
                <td>00000</td>
            </tr>
            <tr>
                <td>Scholarship:</td>
                <td>00000</td>
            </tr>
        </table>
      </section>
    </article>
    
    <article class="row">
        <section class="two fourth">
            <p class="success message">Announcement</p>
            <?php $i=1; foreach($announcement->result() as $row) { ?>
                <?php echo str_replace('images/','http://www.nea.gov.kh/main/images/',$row->news_body_kh) ?>
                <hr />
            <?php if($i>2){break;} $i++; }?>
            <a href="<?php echo site_url('home/news_view/'.'21') ?>"><i>Read more post...</i></a><br />
        </section>
        
        <section class="one fourth pad-left">
            <p class="message">Cooperation:</p>
                <?php echo img(base_url().'images/university/1-npic_1.jpg') ?>
                <?php echo img(base_url().'images/university/2-ntti_1.jpg') ?>
                <?php echo img(base_url().'images/university/3-nib_1.jpg') ?><br />
                <?php echo img(base_url().'images/university/4-ppi_1.jpg') ?>
                <?php echo img(base_url().'images/university/5-ciedc_1.jpg') ?>
                <?php echo img(base_url().'images/university/6-iti_1.jpg') ?><br />
                <?php echo img(base_url().'images/university/7-pib_1.jpg') ?>
                <?php echo img(base_url().'images/university/8-ubb_1.jpg') ?>
                
                <p class="message">Related Links</p>
                <?php $i=1; foreach($relate_link->result() as $row) {?>
                    <p><span class="icon-link"> </span><a href="<?php echo $row->link_url; ?>" target="_blank"><?php echo $row->link_en; ?></a></p>
                <?php }?>
                
                <p class="message">Thank-you Letter</p>
                <?php $i=1; foreach($thank_letter->result() as $row) {?>
                    <p><span class="icon-comment"> </span><a href="<?php echo $row->link_url; ?>" ><?php echo $row->letter_en; ?></a></p>
                <?php }?>
        </section>
        <section class="one fourth pad-left">
            
                <h6>TV Program on LMI and JOB</h6>
                <object style="position: relative; width: 240px; height: 180px;" data="http://www.youtube.com/v/KxMmwDWqIps" type="application/x-shockwave-flash">
                </object>
                
                <hr />
                <h6>Find us on Facebook</h6>
                <!--Facebook javascrip-->
                <div id="fb-root"></div>
                <script>(function(d, s, id) {
                  var js, fjs = d.getElementsByTagName(s)[0];
                  if (d.getElementById(id)) return;
                  js = d.createElement(s); js.id = id;
                  js.src = "//connect.facebook.net/en_US/all.js#xfbml=1";
                  fjs.parentNode.insertBefore(js, fjs);
                }(document, 'script', 'facebook-jssdk'));</script>
                <!--End facebook script-->
                <div class="fb-like-box" data-href="http://www.facebook.com/pages/National-Employment-Agency/223143254469262" data-width="239" data-height="325" data-show-faces="true" data-stream="false" data-header="false"></div>
                <hr />
                <p class="warning message">Latest Key Indicators</p>
                <table>
                    <tr>
                        <td><a>Real GDP growth rate:</a></td>
                        <td>6.9%(2011)</td>
                    </tr>
                    <tr>
                        <td><a>Consumer Price Index:</a></td>
                        <td>1.3%(July 2012)</td>
                    </tr>
                    <tr>
                        <td><a>Unemployment Rate:</a></td>
                        <td>0.4%(2010)</td>
                    </tr>
                    <tr>
                        <td><a>Population:</a></td>
                        <td>13,958,000(2010)</td>
                    </tr>
                    <tr>
                        <td><a>Labor Force:</a></td>
                        <td>7,702,000(2010)</td>
                    </tr>
                </table>
                 
                <hr />
                <p class="warning message">Visitors Counter</p>

                <hr />
                <p class="warning message">Our Customer</p>
                <a href="<?php echo site_url("home_page/home/send_email") ?>">send email</a>
                <hr />
        </section>
        
    </article>
    
    <article class="row">
        <p class="success callout">Advertising Here!</p>
    </article>

    <footer class="footer align-right">
        <p>&copy; 2013, By National Employment Agency (NEA).</p>
    </footer>
  </div>
  <!-- scripts -->
  <script type="text/javascript" src="<?php echo base_url() ?>g-master/assets/js/plugins/jquery.orbit-1.4.0.js"></script>
  <script type="text/javascript" src="<?php echo base_url() ?>g-master/assets/js/groundwork.js"></script>


</body>
</html>
