<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
    <title><?php echo $page_title; ?></title>
    <meta name="description" content="<?php echo $this->lang->line("page_description"); ?>">
    <meta name="keywords" content="<?php echo $this->lang->line("page_keyword"); ?>" />

    <!-- bootstrap -->
    <link rel="stylesheet" type="text/css" href="<?php echo base_url(); ?>css/bootstrap/bootstrap.css" />
    <link rel="stylesheet" type="text/css" href="<?php echo base_url(); ?>css/bootstrap-dropdownhover.min.css" />

    <link rel="stylesheet" href="<?php echo base_url(); ?>css/bootstrapValidator.min.css" type="text/css" />
    
    <!-- libraries -->
    <link rel="stylesheet" type="text/css" href="<?php echo base_url(); ?>css/libs/font-awesome.css" />
    <link rel="stylesheet" type="text/css" href="<?php echo base_url(); ?>css/libs/nanoscroller.css" />

    <!-- global styles -->
    <link rel="stylesheet" type="text/css" href="<?php echo base_url(); ?>css/compiled/theme_styles.css" />

    <!-- Favicon -->
    <link type="image/x-icon" href="<?php echo base_url(); ?>images/favicon.ico" rel="shortcut icon"/>

    <!--[if lt IE 9]>
    <script src="<?php echo base_url(); ?>js/html5shiv.js"></script>
    <script src="<?php echo base_url(); ?>js/respond.min.js"></script>
    <![endif]-->

    <!-- Social Media block-->
    <meta property="og:locale" content="en_US"/>
    <meta property="og:title" content="<?php echo $share_title; ?>" />
    <meta property="og:url" content="<?php echo $share_url; ?>"/>
    <meta property="og:image" content="<?php echo base_url()."images/share/".$share_image; ?>" />
    <meta property="og:description" content="<?php echo $this->lang->line("page_description"); ?>" />
    <meta property='og:type' content="article"/>
    <meta property='og:site_name' content='nea.gov.kh'/>

    <?php
        if (isset($script_add)) {
            foreach ($script_add as &$value) {
                $this->load->view("script/header/" . $value);
            }
        }
    ?>
</head>
<body class="theme-whbl boxed-layout pace-done">

<div id="theme-wrapper">
    <div id="header-block" style="margin-bottom: 1px">
        <div class="container">
            <?php
                $this->load->view("template/widgets/block_header");
            ?>
        </div>
    </div>
    <header id="header-navbar" class="visible-lg-block visible-md-block navbar">
        <div class="container">
            <?php $this->load->view("template/widgets/main_menu");?>
        </div>
    </header>
    
    <div class="visible-sm-block visible-xs-block" >
        <?php $this->load->view("template/widgets/main_menu_phone");?>
    </div>
    
    <div class="container">
        <div class="col-xs-12">  <!--Start Contener-->

            