<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class apiJson extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();

        /*
         * load model
         */
        $this->load->model('model_jobapi_v1');
    }
   
    function index()
    {
        $response = array();

        // no products found
        $response["success"] = 0;
        $response["message"] = "No  found";

        // echo no users JSON
        echo json_encode($response);

    }
      // MARK--- get seeker by Location 
     function getJobBySector($key=0)
    {
          header('Content-Type: text/html; charset=utf-8');
        header('Content-Type: application/json');
       
   
        $keyPwd = 'isic1234560987654';
      if($keyPwd==$key){
        $response = array();
    
        $rows = array();
        if ($_SERVER['REQUEST_METHOD'] == 'GET') {
                
                 $type= $this->input->get('type');
                 $result = $this->model_jobapi_v1->getJobSectorList();
                      $result_number_rows = $result->num_rows();
                        if ($result_number_rows > 0) {
                          
                               
                              foreach ($result->result() as $row) {
                                
                                 $rows[] = $row;
                              }
                          
                 $data = array();
                // $data["type"] = $name;
                 $data["success"] = 1;
                 //$data["message"] = $result_number_rows;
                 $data['ISICList'] = $rows;
                 $response= $data;
                 echo json_encode($response);
             
            } else {
       
              echo json_encode($response);
                }
        } else {
       
          echo json_encode($response);
        }
      }
    }
    
    //============ Pre employment ==========================
    
      function getPreEmploymentList($key=ps1234560987654){
        header('Content-Type: text/html; charset=utf-8');
        header('Content-Type: application/json');
        $keyPwd = 'ps1234560987654';
      if($keyPwd==$key){
        $response = array();
    
        $rows = array();
        if ($_SERVER['REQUEST_METHOD'] == 'GET') {
                
                 $type= $this->input->get('type');
                 $result = $this->model_jobapi_v1->getEventSoftSkill($type);
                      $result_number_rows = $result->num_rows();
                        if ($result_number_rows > 0) {
                          
                               
                              foreach ($result->result() as $row) {
                                
                                 $rows[] = $row;
                              }
                          
                 $data = array();
                // $data["type"] = $name;
                 $data["success"] = 1;
                 //$data["message"] = $result_number_rows;
                 $data['eslist'] = $rows;
                 $response= $data;
                 echo json_encode($response);
             
            } else {
       
              echo json_encode($response);
                }
        } else {
       
          echo json_encode($response);
        }
      }
    }
    
     function getJobFairListV1($key=ps1234560987654){
        header('Content-Type: text/html; charset=utf-8');
        header('Content-Type: application/json');
        $keyPwd = 'ps1234560987654';
      if($keyPwd==$key){
        $response = array();
    
        
        if ($_SERVER['REQUEST_METHOD'] == 'GET') {
                
                 $type= $this->input->get('type');
                 $result = $this->model_jobapi_v1->getEventSoftSkill_V1($type);
                 
                      $result_number_rows = $result->num_rows();
                        if ($result_number_rows > 0) {
                            $rows = array();
                             $response["jobFairList"] = array();
                         
                              foreach ($result->result() as $row) {
                                
                                $rows["id"] = $row->id;
                                $rows["type"] = $row->type;
                                $rows["titleKh"] = $row->titleKh;
                             
                                $rows["softSkillTypeKh"] = $row->softSkillTypeKh;
                               
                                $rows["eventBodyKh"] = $row->eventBodyKh;
                        
                                $rows["eventDate"] = $row->eventDate;
                                $rows["eventDateEnd"] = $row->eventDateEnd;
                                $imagBanner = str_replace(',', '', $row->imageBanner);
                     
                                $rows["imageBanner"] = 'http://nea.gov.kh/images/uploaded/upcoming_event/'.$imagBanner;
                                 
                                 $rows["image"] =$row->image;
                                 
                                 array_push($response["jobFairList"], $rows);
                        }
                          
                    $result_number_rows  = $this->model_jobapi_v1->live_vacancies();
              
                    $result_number_rows = $result_number_rows->row();
                
                  $response["total_vacancy"] = $result_number_rows->total_vacancy;
                  $response["totalvacancy"]= $result_number_rows->total_vacancy;;
                 $response["success"] = 1;
               
                 
                 
                 echo json_encode($response);
             
            } else {
       
              echo json_encode($response);
                }
        } else {
       
          echo json_encode($response);
        }
      }
    }
    
    //======================================================
    
    
    function getJobTitleList($key=0){
        header('Content-Type: text/html; charset=utf-8');
        header('Content-Type: application/json');
        $keyPwd = '123456000000';
        if($keyPwd==$key){
    $response = array();
    
        $rows = array();
        if ($_SERVER['REQUEST_METHOD'] == 'GET') {
                 $key = '123456000000';
                 $name= $this->input->get('sf');
                 $result = $this->model_jobapi_v1->getJobTitleModelSearch($name);
                
                   //SELECT isco_id,isco_code,name_english,name_khmer FROM isco WHERE level=1 or level=4 LIMIT 442
                      $result_number_rows = $result->num_rows();
                        if ($result_number_rows > 0) {
                          
                               
                              foreach ($result->result() as $row) {
                                
                                 $rows[] = $row;
                              }
                          
                 $data = array();
                 $data["sf"] = $name;
                 $data["success"] = 1;
                 $data["message"] = "$result_number_rows";
                 $data['iscoList'] = $rows;
                 $response[]= $data;
                 echo json_encode($response);
             
            } else {
             // $response["success"] = 0;
            //  $response["message"] = "Not found";
              echo json_encode($response);
                }
        } else {
           // $response["success"] = 0;
          // $response["message"] = "Not found";
          echo json_encode($response);
        }
        }
    }
    
    function getISICList($key=0){
        header('Content-Type: text/html; charset=utf-8');
        header('Content-Type: application/json');
        $keyPwd = 'isic123456000000';
        if($keyPwd==$key){
            $response = array();
            $rows = array();
        if ($_SERVER['REQUEST_METHOD'] == 'GET') {
                 $key = 'isic123456000000';
                 $name= $this->input->get('sf');
                 $result = $this->model_jobapi_v1->getISICListModel(1);
                   //SELECT isco_id,isco_code,name_english,name_khmer FROM isco WHERE level=1 or level=4 LIMIT 442
                      $result_number_rows = $result->num_rows();
                        if ($result_number_rows > 0) {
                          
                               
                              foreach ($result->result() as $row) {
                                
                                 $rows[] = $row;
                              }
                          
                 $data = array();
                 $data["sf"] = $name;
                 $data["success"] = 1;
                 $data["message"] = "$result_number_rows";
                 $data['isicList'] = $rows;
                 $response[]= $data;
                 echo json_encode($response);
             
            } else {
             // $response["success"] = 0;
             // $response["message"] = "Not found";
              echo json_encode($response);
                }
        } else {
           // $response["success"] = 0;
          // $response["message"] = "Not found";
          echo json_encode($response);
        }
        }
    }
    
    
    function getISCOList1($key=0){
        header('Content-Type: text/html; charset=utf-8');
        header('Content-Type: application/json');
        $keyPwd = '123456000000';
        if($keyPwd==$key){
    $response = array();
    
        $rows = array();
        if ($_SERVER['REQUEST_METHOD'] == 'GET') {
                 $key = '123456000000';
                 $name= $this->input->get('sf');
                 $result = $this->model_jobapi_v1->getISCOListModelSearch($name);
                   //SELECT isco_id,isco_code,name_english,name_khmer FROM isco WHERE level=1 or level=4 LIMIT 442
                      $result_number_rows = $result->num_rows();
                        if ($result_number_rows > 0) {
                          
                               
                              foreach ($result->result() as $row) {
                                
                                 $rows[] = $row;
                              }
                          
                 $data = array();
                 $data["sf"] = $name;
                 $data["success"] = 1;
                 $data["message"] = "$result_number_rows";
                 $data['iscoList'] = $rows;
                 $response[]= $data;
                 echo json_encode($response);
             
            } else {
             // $response["success"] = 0;
             // $response["message"] = "Not found";
              echo json_encode($response);
                }
        } else {
           // $response["success"] = 0;
          // $response["message"] = "Not found";
          echo json_encode($response);
        }
        }
    }
    
    function getISCOList($key=0){
        header('Content-Type: text/html; charset=utf-8');
        header('Content-Type: application/json');
        $keyPwd = '123456000000';
        if($keyPwd==$key){
        $response = array();
        if ($_SERVER['REQUEST_METHOD'] == 'GET') {
                 $key = '123456000000';
                 $result = $this->model_jobapi_v1->getISCOListModel();
                   //SELECT isco_id,isco_code,name_english,name_khmer FROM isco WHERE level=1 or level=4 LIMIT 442
                 $result_number_rows = $result->num_rows();
                        if ($result_number_rows > 0) {
                           $response["iscolists"] = array();
                               $jobList = array();
                              foreach ($result->result() as $row) {
                                     $jobList["iscoID"]             =  $row->isco_id;
                                     $jobList["iscoCode"]           =  $row->isco_code;
                                     $jobList["iscoName"]           =  $row->name_english;
                                     $jobList["iscoNameKh"]         =  $row->name_khmer;
                                     array_push($response["iscolists"], $jobList); 
                              }
                 $response["message"] = "Successful";
                 $response["success"] = 1;
                echo json_encode($response); 
                
               
            } else {
             $response["success"] = 0;
           $response["message"] = "Not found";
            echo json_encode($response);
                }
        } else {
            $response["success"] = 0;
            $response["message"] = "Not found";
            echo json_encode($response);
        }
        }
    }
    function live_vacancy()
    {
        $response = array();
        $result = $this->model_jobapi_v1->live_vacancies();
        $result_number_rows = $result->num_rows();

        if (!empty($result)) {
            // check for empty result
            if ($result_number_rows > 0) {

                $result = $result->row();
                $vacancy = array();
               // $vacancy["total_vacancy"] ="Live vacancies: " . $result->total_vacancy;
                $vacancy["total_vacancy"] = $result->total_vacancy;
                // success
                $response["success"] = 1;
                $response["totalvacancy"] =$result->total_vacancy;

                // user node
                $response["vacancies"] = array();
                array_push($response["vacancies"], $vacancy);

                // echoing JSON response
                echo json_encode($response);
            } else {
                // no vacancy found
                $response["success"] = 0;
                $response["message"] = "No vacancy found";

                // echo no users JSON
                echo json_encode($response);
            }
        } else {
            // no vacancy found
            $response["success"] = 0;
            $response["message"] = "No vacancy found";

            // echo no users JSON
            echo json_encode($response);
        }

    }
	

	function live_vacancy_kh()
    {
        $response = array();
        $result = $this->model_jobapi_v1->live_vacancies();
        $result_number_rows = $result->num_rows();

        if (!empty($result)) {
            // check for empty result
            if ($result_number_rows > 0) {

                $result = $result->row();
                $vacancy = array();
                $vacancy["total_vacancy"] = "តម្រូវការកម្លាំងពលកម្ម: " . $result->total_vacancy;

                // success
                $response["success"] = 1;

                // user node
                $response["vacancies"] = array();
                array_push($response["vacancies"], $vacancy);

                // echoing JSON response
                echo json_encode($response);
            } else {
                // no vacancy found
                $response["success"] = 0;
                $response["message"] = "No vacancy found";

                // echo no users JSON
                echo json_encode($response);
            }
        } else {
            // no vacancy found
            $response["success"] = 0;
            $response["message"] = "No vacancy found";

            // echo no users JSON
            echo json_encode($response);
        }

    }
    
     function live_vacancy_api()
    {
        $response = array();
        $result = $this->model_jobapi_v1->live_vacancies();
        $result_number_rows = $result->num_rows();

        if (!empty($result)) {
            // check for empty result
            if ($result_number_rows > 0) {

                $result = $result->row();
                
                $response["total_vacancy"] = $result->total_vacancy;

                // success
                $response["success"] = 1;

                // user node
             

                // echoing JSON response
                echo json_encode($response);
            } else {
                // no vacancy found
                $response["success"] = 0;
                $response["message"] = "No vacancy found";

                // echo no users JSON
                echo json_encode($response);
            }
        } else {
            // no vacancy found
            $response["success"] = 0;
            $response["message"] = "No vacancy found";

            // echo no users JSON
            echo json_encode($response);
        }

    }

    function get_contact_us()
    {
        // array for JSON response
        $response = array();
        $result = $this->model_jobapi_v1->get_contact_us_api();
        $result_number_rows = $result->num_rows();
        if ($result_number_rows > 0) {
            // looping through all results
            // contacts node
            $response["contacts"] = array();
            foreach ($result->result() as $row) {
                // temp user array
                $contact = array();
                $contact["id"] = $row->id;
                $contact["office_name"] = $row->office_name_english;
                $contact["address"] = $row->address;
                $contact["contacts"] = $row->contacts;
                $contact["contact_no1"] = $row->contact_no1;
                $contact["contact_no2"] = $row->contact_no2;
                $contact["contact_no3"] = $row->contact_no3;
                $contact["contact_no4"] = $row->contact_no4;
                $contact["email"] = $row->email;
                $contact["facebook"] = $row->facebook;
                $contact["website"] = $row->website;
                $contact["image"]=$row->image;
                $contact["let"]=$row-> let;
                $contact["lon"]=$row-> lon;
                $contact["description"] = $row->description;
                // push single job into final response array
                array_push($response["contacts"], $contact);
            }

            $response["success"] = 1;
            $response["row_number"] = $result_number_rows;
            $response["total_jc"] = $result_number_rows - 1;

            echo json_encode($response);
        } else {
            // no contacts found
            $response["success"] = 0;
            $response["message"] = "No contacts found";

            // echo no users JSON
            echo json_encode($response);
        }
    }
   
    function get_contact_us_kh()
    {
        // array for JSON response
        $response = array();
        $result = $this->model_jobapi_v1->get_contact_us_api();
        $result_number_rows = $result->num_rows();
        if ($result_number_rows > 0) {
            // looping through all results
            // contacts node
            $response["contacts"] = array();
            foreach ($result->result() as $row) {
                // temp user array
                $contact = array();
                $contact["id"] = $row->id;
                $contact["office_name"] = $row->office_name_khmer;
                $contact["address"] = $row->address_khmer;
                $contact["contacts"] = $row->contacts;
                $contact["contact_no1"] = $row->contact_no1;
                $contact["contact_no2"] = $row->contact_no2;
                $contact["contact_no3"] = $row->contact_no3;
                $contact["contact_no4"] = $row->contact_no4;
                $contact["email"] = $row->email;
                $contact["facebook"] = $row->facebook;
                $contact["website"] = $row->website;
                $contact["image"]=$row->image;
                $contact["description"] = $row->description;
                // push single job into final response array
                array_push($response["contacts"], $contact);
            }

            $response["success"] = 1;
            $response["row_number"] = $result_number_rows;
            $response["total_jc"] = $result_number_rows - 1;

            echo json_encode($response);
        } else {
            // no contacts found
            $response["success"] = 0;
            $response["message"] = "No contacts found";

            // echo no users JSON
            echo json_encode($response);
        }
    }
    
    
    // MARK--- get seeker by ISCO level 1 
     function get_js_by_isco_1()
    {
        // array for JSON response
        $response = array();
        $result = $this->model_jobapi_v1->get_js_by_isco_1(1);
        $result_number_rows = $result->num_rows();
        if ($result_number_rows > 0) {
            // looping through all results
            // contacts node
            $response["seeker_isco_1"] = array();
            foreach ($result->result() as $row) {
                // temp user array
                $js_isco = array();
                $js_isco["isco_code"] = $row->isco_code;
                $js_isco["isco_id"] = $row->isco_id;
                $js_isco["name_en"] = $row->name_english;
                $js_isco["name_kh"] = $row->name_khmer;
                $js_isco["total_js"] = $row->total_seeker;
               
                // push single job into final response array
                array_push($response["seeker_isco_1"], $js_isco);
            }

            $response["success"] = 1;
            $response["row_number"] = $result_number_rows;
            

            echo json_encode($response);
        } else {
            // no contacts found
            $response["success"] = 0;
            $response["message"] = "No contacts found";

            // echo no users JSON
            echo json_encode($response);
        }
    }
    
     public function list_location($loc_id, $offset="0") {
              $response = array();
          $response["vacancy_by_location"]= array();
           // array for JSON response
      
            $this->load->model("Model_jobshop", "jobshop");
            // retrieve to total record of table
         

            // limited row
            $limit = 10;

            // Prepare create pagination
            $config['base_url'] = site_url('nea/list_location/'.$loc_id);
            $config['total_rows'] = $total;
            $config['per_page'] = $limit;
            $config['uri_segment'] = 5;
            $config['num_links'] = 5;

            $this->pagination->initialize($config);

            $data['page_links'] = $this->pagination->create_links();

            // Get data
            $data["list_vacancies"] = $this->jobshop->get_vacancies_by_location($loc_id, $limit, $offset);
            $data["offset"] = $offset;

           

            // Load view
            
               array_push($response["vacancy_by_location"], $data);
               
                 echo json_encode($response);
            
        }
    
    // MARK--- get seeker by Location 
     function get_job_by_location()
    {
        // array for JSON response
        $response = array();
        $result = $this->model_jobapi_v1->get_js_by_location();
        $result_number_rows = $result->num_rows();
        if ($result_number_rows > 0) {
            // looping through all results
            // contacts node
            $response["seeker_location"] = array();
            foreach ($result->result() as $row) {
                // temp user array
                $js_isco = array();
               
                $js_isco["location_id"] = $row->location_id;
                $js_isco["name_en"] = $row->location_en;
                $js_isco["name_kh"] = $row->location_kh;
                if (!is_null($row->total_job) or !empty($row->total_job) ){
                    $varTotal= $row->total_job;
                    
                }else{
                    $varTotal = '0';
                }
                $js_isco["total_js"] = $varTotal;
               
                // push single job into final response array
                array_push($response["seeker_location"], $js_isco);
            }

            $response["success"] = 1;
            $response["row_number"] = $result_number_rows;
            

            echo json_encode($response);
        } else {
            // no contacts found
            $response["success"] = 0;
            $response["message"] = "No contacts found";

            // echo no users JSON
            echo json_encode($response);
        }
    }
    
    // MARK--- get seeker by Education 
     function get_js_by_education()
    {
        // array for JSON response
        $response = array();
        $result = $this->model_jobapi_v1->get_js_by_education();
        $result_number_rows = $result->num_rows();
        if ($result_number_rows > 0) {
            // looping through all results
            // contacts node
            $response["seeker_education"] = array();
            foreach ($result->result() as $row) {
                // temp user array
                $js_data = array();
               
                $js_data["edu_id"] = $row->edu_id;
                $js_data["name_en"] = $row->name_english;
                $js_data["name_kh"] = $row->name_khmer;
                $js_data["total_js"] = $row->total_js;
                $js_data["type"] = $row->types;
                
                if($row->types==1){
                 $js_data["type_name"] = "General";
                }
                else{
                $js_data["type_name"] = "TVET";
                }
               
                // push single job into final response array
                array_push($response["seeker_education"], $js_data);
            }

            $response["success"] = 1;
            $response["row_number"] = $result_number_rows;
            

            echo json_encode($response);
        } else {
            // no contacts found
            $response["success"] = 0;
            $response["message"] = "No contacts found";

            // echo no users JSON
            echo json_encode($response);
        }
    }
    
    
    // --- Mark Job search by title & location make on 7-12-2017
     function search_job_title_location(){
        // array for JSON r 
        header('Content-Type: application/json');
        $response = array();

        if (isset($_GET["jobtitle"])) {
            $jobtitle = $this->input->get('jobtitle');          //------ key: job title
            $joblocationid = $this->input->get('joblocation');  //------ key: job location 
            if ($joblocationid == 0) {
                $joblocationid = '';
            }
            $result = $this->model_jobapi_v1->get_job_by_jobtitle_industry_location_api_jobtitle_location($jobtitle, $joblocationid);
            $result_number_rows = $result->num_rows();

            if ($result_number_rows > 0) {

                $response["searchList"] = array();
                foreach ($result->result() as $row) {
                    $product = array();
                    $product["pid"] = $row->job_id;
                    $product["name"] = $row->job_name;
                    $product["close_date"] = $row->close_date;
                    $product["working_date"] = $row->working_date;
                    $product["employer"] = $row->employer;
                    $product["location"] = $row->location;
                    $product["vacancy_num"] = $row->vacancy_num;
                    $product["salary"] = $row->salary;
                    $product["job_term_name"] = $row->job_term_name;
                    $duration=$row->duration_day;
                    $product["image"] = "http://www.nea.gov.kh/nweb/images/ic_wallpaper_black.png";
				
				 if ($duration< 0) {
                                    $duration = "<font color='#FF3C1F'>New</font>";
                                } else if ($duration == 0) {
                                    $duration = "<font color='#ddaa3b'>Today</font>";
                                } else if ($duration == 1) {
                                    $duration = "Yesterday";
                                } else if ($duration > 30) {
                                    $duration = 30 . " Days+" ;
                                } else {
                                    $duration = $duration ." Days";
                                }
								
				$product["duration_day"] = $duration;

                    // push single product into final response array
                    array_push($response["searchList"], $product);
                }
                // success
                $response["success"] = 1;
                $response["num_rows"] = $result_number_rows;

                // echoing JSON response
                echo json_encode($response);
            } else {
                // no products found
                $response["success"] = 0;
                $response["message"] = "No job found";

                // echo no users JSON
                echo json_encode($response);
            }
        } else {
            // no products found
            $response["success"] = 0;
            $response["message"] = "Required field(s) is missing";

            // echo no users JSON
            echo json_encode($response);
        }
    }
/*--Mark --
- Create date: 2017-12-22
- Get latest training course  
*/
    function get_latest_course()
    {
        // array for JSON response
        $response = array();
         if ($_SERVER['REQUEST_METHOD'] == 'GET') {
        $result = $this->model_jobapi_v1->get_latest_training_course(10,0);
        $result_number_rows = $result->num_rows();
        if ($result_number_rows > 0) {
            // looping through all results
            // contacts node
            $response["courses"] = array();
            foreach ($result->result() as $row) {
                // temp user array
                $course = array();
                $course["id"] = $row->ID;
                $course["title"] = $row->title;
                $course["start_enroll"] = $row->start_enroll;
                $course["end_enroll"] = $row->end_enroll;
                $course["start_studying"] = $row->start_studying;
                $course["degree_name"] = $row->degree_name;
                $course["degree_name_khmer"] = $row->degree_name_khmer;
                $course["fee"] = $row->course_fee;
                $course["institution"] = $row->inst_name;
                $course["location_name"] = $row->location_name;
                $course["location_name_khmer"]=$row->location_name_khmer;
                 $course["image"] = "http://www.nea.gov.kh/nweb/images/api/icons-school.png";
 
                array_push($response["courses"], $course);
            }

            $response["success"] = 1;
            echo json_encode($response);
             
            } else {
            // no contacts found
            $response["success"] = 0;
            $response["message"] = "Not found";

            // echo no users JSON
            echo json_encode($response);
                }
        } else {
            // no contacts found
            $response["success"] = 0;
            $response["message"] = "Not found";

            // echo no users JSON
            echo json_encode($response);
        }
    }
    
    function get_latest_scholarsip()
    {
        // array for JSON response
        $response = array();
         if ($_SERVER['REQUEST_METHOD'] == 'GET') {
        $result = $this->model_jobapi_v1->get_latest_scholarship(10,0);
        $result_number_rows = $result->num_rows();
        if ($result_number_rows > 0) {
            // looping through all results
            // contacts node
            $response["courses"] = array();
            foreach ($result->result() as $row) {
                // temp user array
                $course = array();
                $course["id"] = $row->ID;
                $course["title"] = $row->title;
                $course["start_enroll"] = $row->start_enroll;
                $course["end_enroll"] = $row->end_enroll;
                $course["start_studying"] = $row->start_studying;
                $course["degree_name"] = $row->degree_name;
                $course["degree_name_khmer"] = $row->degree_name_khmer;
                $course["sponsor"] = $row->sponsor;
                $course["institution"] = $row->inst_name;
                $course["location_name"] = $row->location_name;
                $course["location_name_khmer"]=$row->location_name_khmer;
                 $course["image"] = "http://www.nea.gov.kh/nweb/images/api/icons8-graduation-cap.png";
 
                array_push($response["courses"], $course);
            }

            $response["success"] = 1;
            echo json_encode($response);
             
            } else {
            // no contacts found
            $response["success"] = 0;
            $response["message"] = "Not found";

            // echo no users JSON
            echo json_encode($response);
                }
        } else {
            // no contacts found
            $response["success"] = 0;
            $response["message"] = "Not found";

            // echo no users JSON
            echo json_encode($response);
        }
    }
    
     public function job_detail_api() {
        header('Content-Type: text/html; charset=utf-8');
        header('Content-Type: application/json');
        $response = array();
        if ($_SERVER['REQUEST_METHOD'] == 'GET') {
                if(isset($_GET['job_id'])){
                    $job_id = $_GET['job_id'];
                    
                    $this->load->model("model_sector", "sector");
                    $this->load->model("model_jobshop", "jobshop");
                    $this->load->model("model_employer", "employer");
                    //$data = array();
                    $vacancy_detail_id = $this->employer->get_vacancy_detail_id($job_id);
                     $data = array();
                     $result = $vacancy_detail_id['0']['0'];
                        $data['job_id'] =  $result['vacancy_id'];
                        $data['job_title'] = $result['job_title'];
                        $data['emp_name'] = $result['Em_name'];
                        $data['job_location_eng'] = $result['job_location_eng'];
                        $data['closing_date']=  date('m-d-Y',strtotime($result['closing_date']));
                        $data['working_date']= date('m-d-Y',strtotime($result['working_date']));
                        $data['base_wage_min']= $result['base_wage_min'];
                        $data['base_wage_max']= $result['base_wage_max'];
                        $min_exp = $result['minimum_work_experience'];
                        if ($min_exp>0){
                            $data['minimum_work_experience']=  $min_exp. " Year(s)";  
                        }
                        else{
                             $data['minimum_work_experience'] = "No experience required";
                        }
                      
                        $data['other_work_experience']= $result['other_work_experience'];
                        $data['other_skill_requirement']= $result['other_skill_requirement'];
                        $data['job_create_date']= $result['job_create_date'];
                        $data['job_title_isco_eng']= $result['job_title_isco_eng'];
                        $data['job_location_kh']= str_replace('###', '  ', $result['job_location_kh']);
                        $data['job_location_eng']= str_replace('###', '  ',$result['job_location_eng']);
                        if ($result['form_of_employment_id'] == 1) {
                            $data['form_of_employment_type'] ='Full time';
                        } else{
                        $data['form_of_employment_type'] ='Part time';
                        }
                        $data['form_of_employ_eng']= $result['form_of_employ_eng'];
                        $data['min_education_eng']= $result['min_education_eng'];
                        $data['min_education_kh']= $result['min_education_kh'];
                        $data['isced_eng']= $result['isced_eng'];
                        $data['isced_kh']= $result['isced_kh'];
                        $data['other_preference']=  $this->clean_html($result['other_preference']);
                        $data['job_description']= $this->clean_html($this->model_jobapi_v1->get_job_description_by_jobid($job_id));  //strip_tags($result['job_description']);
                        $data['how_to_apply']=   $this->clean_html($this->model_jobapi_v1->get_how_to_apply_by_jobid($job_id)); //strip_tags($result['how_to_apply']),0,110);
                         $data['vacancy_wage']="0";
                       if(!empty($vacancy_detail_id['2'])){
                       $data['vacancy_wage']=$vacancy_detail_id['2'];
                       }
                       $data["jc_info"] = $this->model_jobapi_v1->get_province_id_by_jobid($job_id);
                      $data["totalvacancies"] = $this->jobshop->get_total_vacancies_by_id($job_id);
                     // $data['vacancy_language']="";
                      $vacancy_lang= $this->getLanguageByJobID($job_id);
                      
                      $data["vacancy_language"] = array();
                      array_push($data["vacancy_language"], $vacancy_lang);
                      
                      
                      /* if(!empty($vacancy_detail_id['1'])){
                          $data['vacancy_language'] = $vacancy_detail_id['1'];
                       }
                       */
                       
                       $employer_detail=$this->get_employer_detail_api($job_id);
                      
                      $data["employer_detail"] = array();
                      array_push($data["employer_detail"], $employer_detail);
                     $response["job_detail"] = array();

                    array_push($response["job_detail"], $data);
                }
                 else {
                  $response['message'] = 'Parameters are missing';
                }
            } else {
                $response['message'] = "Request not allowed";
            }
            echo json_encode($response);
        }
     function call_emp_detail_by_job_id(){
                    
              $response = array();
                if ($_SERVER['REQUEST_METHOD'] == 'GET') {
                    if(isset($_GET['job_id'])){
                    $job_id = $_GET['job_id'];
                     $employer_detail=$this->get_employer_detail_api($job_id);
                      
                 
                   $response["empInfo"] = array();
                        array_push($response["empInfo"], $employer_detail);
                     echo json_encode($response);
                    }
                }
            }
     function get_employer_detail_api($job_id=0)
                {
                  
                            // check for post data
                                $result = $this->model_jobapi_v1->get_employer_detail($job_id);
                                if (!empty($result)) {
                                    // check for empty result
                                    if ($result->num_rows() > 0) {
                                        $result = $result->row();
                                        $orgs = array();
                                        $orgs["org_id"]	         = $result->org_id;
                    					$orgs["org_name"]	     = $result->org_name;
                    					$orgs["org_industry"]	 = $result->industry_en;
                    					if($result->org_type_en==''){
                    					    $org_type='';
                    					}else{
                    					    $org_type=$result->org_type_en;
                    					}
                    					$orgs["org_type"]	     = $org_type;
                    				//	$orgs["org_reg_num"]	 = $result->org_reg_num;
                    				//    $orgs["org_patent_num"]  = $result->org_patent_num;
                    				//    $orgs["org_num_employ"]  = $result->org_num_employ;
                    				//	$orgs["org_main_occup"]	 = $result->org_main_occup;
                    					$orgs["org_address"]	 = trim(preg_replace('/\s+/', ' ',strip_tags($result->org_address)));
                    					$orgs["org_background"]	 = trim(preg_replace('/\s+/', ' ', strip_tags($result->org_background)));
                    					
                    					
                    					if(!$result->org_cont_person){
                    					    $org_cont_person=$result->org_cont_person;
                    					}else{
                    					    $org_cont_person="N/A";
                    					}
                    					$orgs["org_cont_person"] = $org_cont_person;
                    					
                    					if(!$result->org_office_phone){
                    					    $org_office_phone= $result->org_office_phone;
                    					}else{
                    					    $org_office_phone = "N/A";
                    					}
                    					
                    					$orgs["org_office_phone"]= $org_office_phone;
                    					
                    					$orgs["org_fax"]	     = $result->org_fax;
                    				    if (!$result->org_mobile){
                    				      $var_mb = $result->org_mobile;
                    				    }else{
                    				        $var_mb	= "N/A";
                    				    }
                    					$orgs["org_mobile"] = $var_mb;
                    			     	if ($result->org_email == '') {
                    					  $orgs["org_email"] = ' ';
                    					}else{
                    					   $orgs["org_email"] = $result->org_email;
                    					}
                    			 
                    				    if (!$result->org_website){
                    				        $orgs["org_website"]=$result->org_website;
                    				    }else{
                    				        $orgs["org_website"]= "N/A";
                    				    }
                    					
                    					if(!$result->org_let){
                    					   	$orgs["org_lat"] = $result->org_let; 
                    					}else{
                    					    	$orgs["org_lat"] = "0.000000"; 
                    					}
                    					$orgs["org_lat"]	     = $result->org_let;
                    					$orgs["org_long"]	     = $result->org_long;
                                       return ($orgs);
                                    } 
                                 }
            }
            
    function clean_html($str)
                {       
                   // $str = utf8_decode($str);
                     $str = strip_tags($str);
                     $str = str_replace("&nbsp;", " ", $str);
                    //$str = preg_replace('/\s+/', ' ',$str);
                  //  $str = preg_replace("&bull;", " ",$str);
                    $str = trim($str);
                    return $str;
                }
                
    function strip_tags_content($text, $tags = '', $invert = FALSE) { 

                  preg_match_all('/<(.+?)[\s]*\/?[\s]*>/si', trim($tags), $tags); 
                  $tags = array_unique($tags[1]); 
                    
                  if(is_array($tags) AND count($tags) > 0) { 
                    if($invert == FALSE) { 
                      return preg_replace('@<(?!(?:'. implode('|', $tags) .')\b)(\w+)\b.*?>.*?</\1>@si', '', $text); 
                    } 
                    else { 
                      return preg_replace('@<('. implode('|', $tags) .')\b.*?>.*?</\1>@si', '', $text); 
                    } 
                  } 
                  elseif($invert == FALSE) { 
                    return preg_replace('@<(\w+)\b.*?>.*?</\1>@si', '', $text); 
                  } 
                  return $text; 
                } 
                
    function news_feeds(){
                       header('Content-Type: application/json');
                       $result = $this->model_jobapi_v1->get_news_feeds_3(0);
                                $response["news_feed"] = array();
                                $feed = array();
                                 foreach ($result->result() as $row) {
                                  // echo json_encode($row); 
                                   $feed["feed_id"] = $row->news_feeds_id;
                                   $feed["feed_title_kh"] = $row->title_kh;
                                   $feed["feed_body"] =trim(preg_replace('/\s+/', ' ',strip_tags( $row->news_feeds_body_kh)));
                                   $feed["feed_date"] = $row->update_date;
                                   $feed["image_url"] = "http://nea.gov.kh/images/uploaded/news_feeds/".$row->news_feeds_id."_.jpg";
                               
                                array_push($response["news_feed"], $feed);
                                  }
 
                 echo json_encode($response);
                              
                }
   function getLanguageByJobID($job_id=0){
                     $response = array();
                     $response["vacancy_lang"] = array();
                     $product = array();
                     $result = $this->model_jobapi_v1->getLanguageBy_jobID($job_id);
                     
                       $result_number_rows = $result->num_rows();
                          if ($result_number_rows > 0) {
                            
                            foreach ($result->result() as $row) {
                            // Language 
                                if ($row->lang_name_en <> null){
                        		  $product["language_eng"] = $row->lang_name_en;
                        		}else{
                        		  
                        		  $product["language_eng"]= "Not required";
                        		}
                        		// Language level
                                if ($row->lang_name_level_en <> null){
                        		  $product["language_level_eng"] = $row->lang_name_level_en;
                        		}else{
                        		  $product["language_level_eng"]= " ";
                        		}
                             }
                          }
                          else{
                               $product["language_eng"]= "Not required";
                               $product["language_level_eng"]= "";
                          }
                       return $product;
                 }
/*MARK-- 20-08-2018 Training program and course */                
 function get_latest_program_course()
    {
      header('Content-Type: text/html; charset=utf-8');
     header('Content-Type: application/json');
        // array for JSON response
        $response = array();
     
         if ($_SERVER['REQUEST_METHOD'] == 'GET') {
      
        $result = $this->model_jobapi_v1->get_program_course_latest(10,0);
        $result_number_rows = $result->num_rows();
        if ($result_number_rows > 0) {
            // looping through all results
            // contacts node
         
        // $i = 0;

          $response["courses"] = array();
           $fee = array();
          foreach ($result->result() as $row) {
                // temp user array
     
                $fee["courseId"] = $row->ID;
                $fee["courseTitle"] = $row->title;
                $fee["enrollStart"] = date('m-d-Y',strtotime($row->start_enroll));
                $fee["erollEnd"] = date('m-d-Y',strtotime($row->end_enroll));
                $fee["studyStart"] = date('m-d-Y',strtotime($row->start_studying));
                $fee["studyEnd"] = date('m-d-Y',strtotime($row->end_studying));
                $fee["daytimeOffer"] = $row->course_daytime_offer;
                $fee["targetAudience"] = trim(preg_replace('/\s+/', ' ',strip_tags($row->course_target_audience)));
                $fee["admission"] = $row->course_admission;
                $fee["fee"] = $row->course_fee;
                $fee["courseDescription"]=trim(preg_replace('/\s+/', ' ',strip_tags($row->course_description)));
                $fee["howEnroll"] = trim(preg_replace('/\s+/', ' ',strip_tags($row->course_how_enroll)));
                $fee["courseDate"] = $row->course_date;
                $fee["degreeName"] = $row->degree_name;
                $fee["degreeNameKhmer"] = $row->degree_name_khmer;
                $fee["locationName"] = $row->location_name;
                $fee["locationNameKhmer"] = $row->location_name_khmer;
                $fee["institutionEng"] = $row->institution_eng;
                $fee["institutionKh"] = $row->institution_kh;
                $fee["jobCatName"] = $row->job_cat_name;
                $fee["jobCatNameKhmer"] = $row->job_cat_name_khmer;
                $fee["courseMajor"]= $row->major_eng;
                $fee["courseMajorKh"]= $row->major_kh;
                /* Institution information */
                $fee["instName"] = $row->inst_name;
                $fee["instAddress"] = trim(preg_replace('/\s+/', ' ',strip_tags($row->inst_address)));
                $fee["instProfileDetails"] = trim(preg_replace('/\s+/', ' ',strip_tags($row->inst_profile_details)));
                $fee["instContPerson"] = $row->inst_cont_person;
                $fee["instOfficePhone"] = $row->inst_office_phone;
                $fee["instMobilePhone"] = $row->inst_mobile_phone;
                $fee["instFax"] = $row->inst_fax;
                $fee["instEmail"] = $row->inst_email;
                $fee["instWebsite"] = $row->inst_website;
                $fee["instPhoto"] = $row->inst_photo;
                $fee["image"] = "http://www.nea.gov.kh/nweb/images/api/icons-school.png";
            // $i++;
            
          
               array_push($response["courses"], $fee);
            }
          
           
            echo json_encode($response);
              $response["success"] = 1;
            } else {
            $response["success"] = 0;
            $response["message"] = "Not found";
            echo json_encode($response);
                }
        } else {
            $response["success"] = 0;
            $response["message"] = "Not found";
            echo json_encode($response);
        }
    }
    
    
    
     /*MARK-- 20-08-2018 Training program and course */                
 function get_latest_scholarship()
    {
     header('Content-Type: text/html; charset=utf-8');
     header('Content-Type: application/json');
        // array for JSON response
        $response = array();
     
         if ($_SERVER['REQUEST_METHOD'] == 'GET') {
      
        $result = $this->model_jobapi_v1->get_latest_scholarship_model(20);
        $result_number_rows = $result->num_rows();
        if ($result_number_rows > 0) {
              $response["Scholarship"] = array();
               $scholar = array();
              foreach ($result->result() as $row) {
                    $scholar["schoID"] = $row->scholar_id;
                    $scholar["schoName"] = $row->scholar_name;
                    $scholar["schoNameKh"] = $row->scholarships_name_k;
                    $scholar["schoSponsorBy"] = $row->sponsor_by;
                    $scholar["schoEnrollStart"] = date("d-m-Y", strtotime($row->scholar_enroll_start));
                    $scholar["schoEnrollEnd"] = date("d-m-Y", strtotime($row->scholar_enroll_end));
                    $scholar["schoStudyStart"] = date("d-m-Y", strtotime($row->scholar_study_start));
                    $scholar["schoStudyEnd"] = date("d-m-Y", strtotime($row->scholar_study_end));
                    $scholar["schoTagetAudience"] = trim(preg_replace('/\s+/', ' ',strip_tags($row->scholar_target_audience)));
                    $scholar["schoAdmission"] = trim(preg_replace('/\s+/', ' ',strip_tags($row->scholar_admission)));
                    $scholar["schoDescription"] = trim(preg_replace('/\s+/', ' ',strip_tags($row->scholar_description)));
                    $scholar["schoHowGet"] = trim(preg_replace('/\s+/', ' ',strip_tags($row->scholar_how_get)));
                    $scholar["schoDate"] = date('m-d-Y',strtotime($row->scholar_date));
                    $scholar["schoDegreeName"] = $row->degree_name;
                    $scholar["schoDegreeNameKh"] = $row->degree_name_khmer;
                    $scholar["schoMajorEn"] = $row->major_eng;
                    $scholar["schoMajorKh"] = $row->major_kh;
                    $scholar["schoLocation"] = $row->location_name;
                    $scholar["schoLocationKh"] = $row->location_name_khmer;
                    $scholar["schoInstName"] = $row->inst_name;
                    $scholar["schoInstAddress"] = trim(preg_replace('/\s+/', ' ',strip_tags($row->inst_address)));
                    if($row->inst_email!='nea_'){
                        $scholar["schoInstEmail"] = $row->inst_email;
                    }else{
                         $scholar["schoInstEmail"] = 'N/A';  
                    }
                    $scholar["schoInstWebsite"] = $row->inst_website;
                    $scholar["schoProfile"] = trim(preg_replace('/\s+/', ' ',strip_tags($row->inst_profile_details)));
                    $scholar["schoInstitutionEn"] = $row->institution_eng;
                    $scholar["schoInstitutionKh"] = $row->institution_kh;
                   array_push($response["Scholarship"], $scholar);
                }
              
                echo json_encode($response); 
                $response["success"] = 1;
            } else {
            $response["success"] = 0;
            $response["message"] = "Not found";
            echo json_encode($response);
                }
        } else {
            $response["success"] = 0;
            $response["message"] = "Not found";
            echo json_encode($response);
        }
    }
    
    function getAllLocationKh(){
        header('Content-Type: text/html; charset=utf-8');
        header('Content-Type: application/json');
        // array for JSON response
        $response = array();
     
         if ($_SERVER['REQUEST_METHOD'] == 'GET') {
      
                $result = $this->model_jobapi_v1->get_all_location_app();
                $result_number_rows = $result->num_rows();
                        if ($result_number_rows > 0) {
                              $response["location"] = array();
                               $location = array();
                              foreach ($result->result() as $row) {
                                    $location["id"] = $row->locationID;
                                    $location["locationName"] = $row->locationNameEn;
                                    $location["locationNameKh"] = $row->locationNameKh;
                                    $location["LatLong"] = $row->mapLatLong;
                                  $location["mapZome"]= $row->mapZome;
                                    array_push($response["location"], $location);   
                                  
                      }
                echo json_encode($response); 
                $response["success"] = 1;
            } else {
            $response["success"] = 0;
            $response["message"] = "Not found";
            echo json_encode($response);
                }
        } else {
            $response["success"] = 0;
            $response["message"] = "Not found";
            echo json_encode($response);
        }
    }
    
    
    
    //get_job_by_title_loc_isco_sector($title ='',$loc ='', $isco ='',$sector='')
    //===================================================================================================================================================
     // --- Mark new job list date: 19-09-2018
    public function getJobListTitleLocISCOSectorApi_bk() { // <-----------------------------------------
    
        header('Content-Type: text/html; charset=utf-8');
        header('Content-Type: application/json');
        $response = array();
        if ($_SERVER['REQUEST_METHOD'] == 'GET') {
                  
		          $title= $this->input->get('title');
		          $loc = $this->input->get('loc');  //------ key: job location 
		          $isco= $this->input->get('isco');
		          $sector = $this->input->get('sec');
		             
	                 $result = $this->model_jobapi_v1->get_job_by_title_loc_isco_sector($title,$loc,$isco,$sector);
	                 $result_number_rows = $result->num_rows();
                        if ($result_number_rows > 0) {
                              $response["jobList"] = array();
                               $jobList = array();
                              foreach ($result->result() as $row) {
                                     $jobList["VacID"]                  =  $row->vacancy_id;
                                     $jobList["VacTitle"]               =  $row->job_title;
                                     $jobList["VacTitleISCO"]           =  $row->job_title_isco_code;
                                     $jobList["VacISCOName"]            =  $row->isco_name_eng;
                                     $jobList["VacISCONameKh"]          =  $row->isco_name_kh;
                                     $jobList["VacLocation"]            =  $row->job_location_eng;
                                     $jobList["VacLocationKh"]          =  $row->job_location_kh;
                                     $jobList["VacClosingDate"]         =  date("d-m-Y", strtotime($row->closing_date));
                                     $jobList["VacCreatedDate"]         =  date("d-m-Y", strtotime($row->job_create_date));
                                     $jobList["VacOrgName"]             =  $row->ORG_NAME;
                                     $jobList["VacEmployerID"]          =  $row->employer_id;
                                     $jobList["VacTotalVac"]            =  $row->total_vacancy;
                                     $jobList["VacStartWorkingDate"]    =  date("d-m-Y", strtotime($row->job_start_working));
                                     $jobList["VacPostedDate"]          =  date("d-m-Y", strtotime($row->job_create_date));
                                     $jobList["VacDurationDay"]         =  $row->duration_day;
                                     $jobList["VacTermOfEmployment"]    =  $row->job_term_name;
                                     $jobList["VacTermOfEmploymentKh"]  =  $row->job_term_name_khmer;
                                     $jobList["VacFormOfEmployment"]    =  $row->form_employment_name;
                                     $jobList["VacFormOfEmploymentKh"]  =  $row->form_employment_name_kh;
                                     if($row->base_wage_min>0){
                                     $jobList["VacSalary"]              =  $row->base_wage_min;
                                     }else{
                                      $jobList["VacSalary"]             = "N/A";    
                                     }
                                     $jobList["VacOtherSkillRequirment"]=  trim(preg_replace('/\s+/', ' ',strip_tags($row->other_skill_requirement)));
                                     $jobList["VacEdu"]                 =  $row->degree_name;
                                     $jobList["VacEduKh"]               =  $row->degree_name_khmer;
                                     $jobList["VacEduMajor"]            =  $row->isced_name;
                                     $jobList["VacEduMajorKh"]          =  $row->isced_name_kh;
                                     $jobList["VacMixWorkExp"]          =  $row->minWorkExp . '-Year(s)';
                                     $jobList["VacMixWorkExpKh"]        =  $row->minWorkExp .'-ឆ្នាំ';
                                     $jobList["VacWorkISICExp"]         =  $row->isic_name ;
                                     $jobList["VacOtherPreference"]     =   html_entity_decode(strip_tags($row->other_preference));
                                     $jobList["VacDescription"]         =  strip_tags($row->job_description);
                                     $jobList["VacHowApply"]            =  strip_tags($row->how_to_apply);
                                     $jobList["VacImage"]               =  "http://www.nea.gov.kh/nweb/images/ic_wallpaper_black.png";
                                   //  $jobList["id"] =  $row->pictures;
                                   /* Mark -- Language Array Object*/
                                     $vacancy_lang= $this->getLanguageByJobID($row->vacancy_id);
                                     $jobList["VacLanguage"] = array();
                                   /* Mark -- Employer Information */
                                     $jobList["VacEmployerInfo"] = array();
                                      array_push($jobList["VacEmployerInfo"], $this->getEmployerInfoByJobID($row->vacancy_id));
                                   //-- Mark for job center information
                                     $jobList["VacJobCenterInfo"] = $this->model_jobapi_v1->getJobCenterInfoByJOBID($row->vacancy_id);
                                     array_push($jobList["VacLanguage"], $vacancy_lang);
                                     array_push($response["jobList"], $jobList); 
                              }
                $response["message"] = "Successful";
                $response["success"] = 1;
                $response["totlaVac"] = $result_number_rows;
                echo json_encode($response); 
                
               
            } else {
            $response["success"] = 0;
            $response["message"] = "Not found";
            echo json_encode($response);
                }
           
        }
        else {
                $response["success"] = 0;
                $response["message"] = "Not found";
                echo json_encode($response);
            
             }
    }
    
    
    
    // --- Mark new job list date: 28-08-2018
    public function getJobListApi() { // <------------------------------------------------- Get latest vacancy ----------------------------------------
        header('Content-Type: text/html; charset=utf-8');
        header('Content-Type: application/json');
        $response = array();
        if ($_SERVER['REQUEST_METHOD'] == 'GET') {
                 $result = $this->model_jobapi_v1->get_all_valiad_job_app_model(10,0);
                 $result_number_rows = $result->num_rows();
                        if ($result_number_rows > 0) {
                              $response["jobList"] = array();
                               $jobList = array();
                              foreach ($result->result() as $row) {
                                     $jobList["VacID"]                  =  $row->vacancy_id;
                                     $jobList["VacTitle"]               =  $row->job_title;
                                     $jobList["VacTitleISCO"]           =  $row->job_title_isco_code;
                                     $jobList["VacISCOName"]            =  $row->isco_name_eng;
                                     $jobList["VacISCONameKh"]          =  $row->isco_name_kh;
                                     $jobList["VacLocation"]            =  $row->job_location_eng;
                                     $jobList["VacLocationKh"]          =  $row->job_location_kh;
                                     $jobList["VacClosingDate"]         =  date("d-m-Y", strtotime($row->closing_date));
                                     $jobList["VacCreatedDate"]         =  date("d-m-Y", strtotime($row->job_create_date));
                                     $jobList["VacOrgName"]             =  $row->ORG_NAME;
                                     $jobList["VacEmployerID"]          =  $row->employer_id;
                                     $jobList["VacTotalVac"]            =  $row->total_vacancy;
                                     $jobList["VacStartWorkingDate"]    =  date("d-m-Y", strtotime($row->job_start_working));
                                     $jobList["VacPostedDate"]          =  date("d-m-Y", strtotime($row->job_create_date));
                                     $jobList["VacDurationDay"]         =  $row->duration_day;
                                     $jobList["VacTermOfEmployment"]    =  $row->job_term_name;
                                     $jobList["VacTermOfEmploymentKh"]  =  $row->job_term_name_khmer;
                                     $jobList["VacFormOfEmployment"]    =  $row->form_employment_name;
                                     $jobList["VacFormOfEmploymentKh"]  =  $row->form_employment_name_kh;
                                     if($row->base_wage_min>0){
                                     $jobList["VacSalary"]              =  $row->base_wage_min;
                                     }else{
                                      $jobList["VacSalary"]             = "N/A";    
                                     }
                                     $jobList["VacOtherSkillRequirment"]=  trim(preg_replace('/\s+/', ' ',strip_tags($row->other_skill_requirement)));
                                     $jobList["VacEdu"]                 =  $row->degree_name;
                                     $jobList["VacEduKh"]               =  $row->degree_name_khmer;
                                     $jobList["VacEduMajor"]            =  $row->isced_name;
                                     $jobList["VacEduMajorKh"]          =  $row->isced_name_kh;
                                     $jobList["VacMixWorkExp"]          =  $row->minWorkExp . '-Year(s)';
                                     $jobList["VacMixWorkExpKh"]        =  $row->minWorkExp .'-ឆ្នាំ';
                                     $jobList["VacWorkISICExp"]         =  $row->isic_name ;
                                     $jobList["VacOtherPreference"]     =   html_entity_decode(strip_tags($row->other_preference));
                                     $jobList["VacDescription"]         =  strip_tags($row->job_description);
                                     $jobList["VacHowApply"]            =  strip_tags($row->how_to_apply);
                                     if($row->pictures != ''){
                                          $jobList["VacImage"]               =  $row->pictures ;// "http://api.nea.gov.kh/images/images/collectionBgBlue.png";
                                     }else{
                                          $jobList["VacImage"]               =   "http://api.nea.gov.kh/images/images/beautifulbackgrounds-360x192.jpg";
                                     }
                                    
                                   //  $jobList["id"] =  $row->pictures;
                                   /* Mark -- Language Array Object*/
                                     $vacancy_lang= $this->getLanguageByJobID($row->vacancy_id);
                                     $jobList["VacLanguage"] = array();
                                   /* Mark -- Employer Information */
                                     $jobList["VacEmployerInfo"] = array();
                                      array_push($jobList["VacEmployerInfo"], $this->getEmployerInfoByJobID($row->vacancy_id));
                                   //-- Mark for job center information
                                     $jobList["VacJobCenterInfo"] = $this->model_jobapi_v1->getJobCenterInfoByJOBID($row->vacancy_id);
                                     array_push($jobList["VacLanguage"], $vacancy_lang);
                                     array_push($response["jobList"], $jobList); 
                              }
                              
                  $result_number_rows  = $this->model_jobapi_v1->live_vacancies();
                    $result_number_rows = $result_number_rows->row();
                
                $response["TotalJobVacnacy"] = $result_number_rows->total_vacancy;
                   
                              
                $response["message"] = "Successful";
                $response["success"] = 1;
                echo json_encode($response); 
                
               
            } else {
            $response["success"] = 0;
            $response["message"] = "Not found";
            echo json_encode($response);
                }
        } else {
            $response["success"] = 0;
            $response["message"] = "Not found";
            echo json_encode($response);
        }
    }
        
        
    // --- Mark new Sector date: 30-10-2019
    public function getOccuApi() { // <------------------------------------------------- Get latest vacancy ----------------------------------------
        header('Content-Type: text/html; charset=utf-8');
        header('Content-Type: application/json');
        $isco_level = $this->input->get('level');
        $response = array();
        if ($_SERVER['REQUEST_METHOD'] == 'GET') {
                 $result = $this->model_jobapi_v1->get_all_valiad_job_occu(10,0,$isco_level);
                 $result_number_rows = $result->num_rows();
                        if ($result_number_rows > 0) {
                              $response["jobList"] = array();
                               $jobList = array();
                              foreach ($result->result() as $row) {
                                     $jobList["VacID"]                  =  $row->vacancy_id;
                                     $jobList["VacTitle"]               =  $row->job_title;
                                     $jobList["VacTitleISCO"]           =  $row->job_title_isco_code;
                                     $jobList["VacISCOName"]            =  $row->isco_name_eng;
                                     $jobList["VacISCONameKh"]          =  $row->isco_name_kh;
                                     $jobList["VacLocation"]            =  $row->job_location_eng;
                                     $jobList["VacLocationKh"]          =  $row->job_location_kh;
                                     $jobList["VacClosingDate"]         =  date("d-m-Y", strtotime($row->closing_date));
                                     $jobList["VacCreatedDate"]         =  date("d-m-Y", strtotime($row->job_create_date));
                                     $jobList["VacOrgName"]             =  $row->ORG_NAME;
                                     $jobList["VacEmployerID"]          =  $row->employer_id;
                                     $jobList["VacTotalVac"]            =  $row->total_vacancy;
                                     $jobList["VacStartWorkingDate"]    =  date("d-m-Y", strtotime($row->job_start_working));
                                     $jobList["VacPostedDate"]          =  date("d-m-Y", strtotime($row->job_create_date));
                                     $jobList["VacDurationDay"]         =  $row->duration_day;
                                     $jobList["VacTermOfEmployment"]    =  $row->job_term_name;
                                     $jobList["VacTermOfEmploymentKh"]  =  $row->job_term_name_khmer;
                                     $jobList["VacFormOfEmployment"]    =  $row->form_employment_name;
                                     $jobList["VacFormOfEmploymentKh"]  =  $row->form_employment_name_kh;
                                     if($row->base_wage_min>0){
                                     $jobList["VacSalary"]              =  $row->base_wage_min;
                                     }else{
                                      $jobList["VacSalary"]             = "N/A";    
                                     }
                                     $jobList["VacOtherSkillRequirment"]=  trim(preg_replace('/\s+/', ' ',strip_tags($row->other_skill_requirement)));
                                     $jobList["VacEdu"]                 =  $row->degree_name;
                                     $jobList["VacEduKh"]               =  $row->degree_name_khmer;
                                     $jobList["VacEduMajor"]            =  $row->isced_name;
                                     $jobList["VacEduMajorKh"]          =  $row->isced_name_kh;
                                     $jobList["VacMixWorkExp"]          =  $row->minWorkExp . '-Year(s)';
                                     $jobList["VacMixWorkExpKh"]        =  $row->minWorkExp .'-ឆ្នាំ';
                                     $jobList["VacWorkISICExp"]         =  $row->isic_name ;
                                     $jobList["VacOtherPreference"]     =   html_entity_decode(strip_tags($row->other_preference));
                                     $jobList["VacDescription"]         =  strip_tags($row->job_description);
                                     $jobList["VacHowApply"]            =  strip_tags($row->how_to_apply);
                                     if($row->pictures != ''){
                                          $jobList["VacImage"]               =  $row->pictures ;// "http://api.nea.gov.kh/images/images/collectionBgBlue.png";
                                     }else{
                                          $jobList["VacImage"]               =   "http://api.nea.gov.kh/images/images/beautifulbackgrounds-360x192.jpg";
                                     }
                                    
                                   //  $jobList["id"] =  $row->pictures;
                                   /* Mark -- Language Array Object*/
                                     $vacancy_lang= $this->getLanguageByJobID($row->vacancy_id);
                                     $jobList["VacLanguage"] = array();
                                   /* Mark -- Employer Information */
                                     $jobList["VacEmployerInfo"] = array();
                                      array_push($jobList["VacEmployerInfo"], $this->getEmployerInfoByJobID($row->vacancy_id));
                                   //-- Mark for job center information
                                     $jobList["VacJobCenterInfo"] = $this->model_jobapi_v1->getJobCenterInfoByJOBID($row->vacancy_id);
                                     array_push($jobList["VacLanguage"], $vacancy_lang);
                                     array_push($response["jobList"], $jobList); 
                              }
                $response["message"] = "Successful";
                $response["success"] = 1;
                echo json_encode($response); 
                
               
            } else {
            $response["success"] = 0;
            $response["message"] = "Not found";
            echo json_encode($response);
                }
        } else {
            $response["success"] = 0;
            $response["message"] = "Not found";
            echo json_encode($response);
        }
    }
    
    
        // --- Mark new job list date: 30-10-2019
    public function getJobListApiBySector() { // <------------------------------------------------- Get latest vacancy ----------------------------------------
        header('Content-Type: text/html; charset=utf-8');
        header('Content-Type: application/json');
        $response = array();
        $keyId= $this->input->get('sector');
        if ($_SERVER['REQUEST_METHOD'] == 'GET') {
                 $result = $this->model_jobapi_v1->get_all_valiad_job_model_by_sector(10,0, $keyId);
                 $result_number_rows = $result->num_rows();
                        if ($result_number_rows > 0) {
                              $response["jobList"] = array();
                               $jobList = array();
                              foreach ($result->result() as $row) {
                                     $jobList["VacID"]                  =  $row->vacancy_id;
                                     $jobList["VacTitle"]               =  $row->job_title;
                                     $jobList["VacTitleISCO"]           =  $row->job_title_isco_code;
                                     $jobList["VacISCOName"]            =  $row->isco_name_eng;
                                     $jobList["VacISCONameKh"]          =  $row->isco_name_kh;
                                     $jobList["VacLocation"]            =  $row->job_location_eng;
                                     $jobList["VacLocationKh"]          =  $row->job_location_kh;
                                     $jobList["VacClosingDate"]         =  date("d-m-Y", strtotime($row->closing_date));
                                     $jobList["VacCreatedDate"]         =  date("d-m-Y", strtotime($row->job_create_date));
                                     $jobList["VacOrgName"]             =  $row->ORG_NAME;
                                     $jobList["VacEmployerID"]          =  $row->employer_id;
                                     $jobList["VacTotalVac"]            =  $row->total_vacancy;
                                     $jobList["VacStartWorkingDate"]    =  date("d-m-Y", strtotime($row->job_start_working));
                                     $jobList["VacPostedDate"]          =  date("d-m-Y", strtotime($row->job_create_date));
                                     $jobList["VacDurationDay"]         =  $row->duration_day;
                                     $jobList["VacTermOfEmployment"]    =  $row->job_term_name;
                                     $jobList["VacTermOfEmploymentKh"]  =  $row->job_term_name_khmer;
                                     $jobList["VacFormOfEmployment"]    =  $row->form_employment_name;
                                     $jobList["VacFormOfEmploymentKh"]  =  $row->form_employment_name_kh;
                                     if($row->base_wage_min>0){
                                     $jobList["VacSalary"]              =  $row->base_wage_min;
                                     }else{
                                      $jobList["VacSalary"]             = "N/A";    
                                     }
                                     $jobList["VacOtherSkillRequirment"]=  trim(preg_replace('/\s+/', ' ',strip_tags($row->other_skill_requirement)));
                                     $jobList["VacEdu"]                 =  $row->degree_name;
                                     $jobList["VacEduKh"]               =  $row->degree_name_khmer;
                                     $jobList["VacEduMajor"]            =  $row->isced_name;
                                     $jobList["VacEduMajorKh"]          =  $row->isced_name_kh;
                                     $jobList["VacMixWorkExp"]          =  $row->minWorkExp . '-Year(s)';
                                     $jobList["VacMixWorkExpKh"]        =  $row->minWorkExp .'-ឆ្នាំ';
                                     $jobList["VacWorkISICExp"]         =  $row->isic_name ;
                                     $jobList["VacOtherPreference"]     =   html_entity_decode(strip_tags($row->other_preference));
                                     $jobList["VacDescription"]         =  strip_tags($row->job_description);
                                     $jobList["VacHowApply"]            =  strip_tags($row->how_to_apply);
                                     if($row->pictures != ''){
                                          $jobList["VacImage"]               =  $row->pictures ;// "http://api.nea.gov.kh/images/images/collectionBgBlue.png";
                                     }else{
                                          $jobList["VacImage"]               =   "http://api.nea.gov.kh/images/images/beautifulbackgrounds-360x192.jpg";
                                     }
                                    
                                   //  $jobList["id"] =  $row->pictures;
                                   /* Mark -- Language Array Object*/
                                     $vacancy_lang= $this->getLanguageByJobID($row->vacancy_id);
                                     $jobList["VacLanguage"] = array();
                                   /* Mark -- Employer Information */
                                     $jobList["VacEmployerInfo"] = array();
                                      array_push($jobList["VacEmployerInfo"], $this->getEmployerInfoByJobID($row->vacancy_id));
                                   //-- Mark for job center information
                                     $jobList["VacJobCenterInfo"] = $this->model_jobapi_v1->getJobCenterInfoByJOBID($row->vacancy_id);
                                     array_push($jobList["VacLanguage"], $vacancy_lang);
                                     array_push($response["jobList"], $jobList); 
                              }
                $response["message"] = "Successful";
                $response["success"] = 1;
                echo json_encode($response); 
                
               
            } else {
            $response["success"] = 0;
            $response["message"] = "Not found";
            echo json_encode($response);
                }
        } else {
            $response["success"] = 0;
            $response["message"] = "Not found";
            echo json_encode($response);
        }
    }
    
        // --- Mark new job list date: 28-08-2018
    public function getJobListApiByOccu() { // <------------------------------------------------- Get latest vacancy ----------------------------------------
        header('Content-Type: text/html; charset=utf-8');
        header('Content-Type: application/json');
        $response = array();
        $keyId= $this->input->get('occu');
        if ($_SERVER['REQUEST_METHOD'] == 'GET') {
                 $result = $this->model_jobapi_v1->get_all_valiad_job_model_by_occu(10,0, $keyId);
                 $result_number_rows = $result->num_rows();
                        if ($result_number_rows > 0) {
                              $response["jobList"] = array();
                               $jobList = array();
                              foreach ($result->result() as $row) {
                                     $jobList["VacID"]                  =  $row->vacancy_id;
                                     $jobList["VacTitle"]               =  $row->job_title;
                                     $jobList["VacTitleISCO"]           =  $row->job_title_isco_code;
                                     $jobList["VacISCOName"]            =  $row->isco_name_eng;
                                     $jobList["VacISCONameKh"]          =  $row->isco_name_kh;
                                     $jobList["VacLocation"]            =  $row->job_location_eng;
                                     $jobList["VacLocationKh"]          =  $row->job_location_kh;
                                     $jobList["VacClosingDate"]         =  date("d-m-Y", strtotime($row->closing_date));
                                     $jobList["VacCreatedDate"]         =  date("d-m-Y", strtotime($row->job_create_date));
                                     $jobList["VacOrgName"]             =  $row->ORG_NAME;
                                     $jobList["VacEmployerID"]          =  $row->employer_id;
                                     $jobList["VacTotalVac"]            =  $row->total_vacancy;
                                     $jobList["VacStartWorkingDate"]    =  date("d-m-Y", strtotime($row->job_start_working));
                                     $jobList["VacPostedDate"]          =  date("d-m-Y", strtotime($row->job_create_date));
                                     $jobList["VacDurationDay"]         =  $row->duration_day;
                                     $jobList["VacTermOfEmployment"]    =  $row->job_term_name;
                                     $jobList["VacTermOfEmploymentKh"]  =  $row->job_term_name_khmer;
                                     $jobList["VacFormOfEmployment"]    =  $row->form_employment_name;
                                     $jobList["VacFormOfEmploymentKh"]  =  $row->form_employment_name_kh;
                                     if($row->base_wage_min>0){
                                     $jobList["VacSalary"]              =  $row->base_wage_min;
                                     }else{
                                      $jobList["VacSalary"]             = "N/A";    
                                     }
                                     $jobList["VacOtherSkillRequirment"]=  trim(preg_replace('/\s+/', ' ',strip_tags($row->other_skill_requirement)));
                                     $jobList["VacEdu"]                 =  $row->degree_name;
                                     $jobList["VacEduKh"]               =  $row->degree_name_khmer;
                                     $jobList["VacEduMajor"]            =  $row->isced_name;
                                     $jobList["VacEduMajorKh"]          =  $row->isced_name_kh;
                                     $jobList["VacMixWorkExp"]          =  $row->minWorkExp . '-Year(s)';
                                     $jobList["VacMixWorkExpKh"]        =  $row->minWorkExp .'-ឆ្នាំ';
                                     $jobList["VacWorkISICExp"]         =  $row->isic_name ;
                                     $jobList["VacOtherPreference"]     =   html_entity_decode(strip_tags($row->other_preference));
                                     $jobList["VacDescription"]         =  strip_tags($row->job_description);
                                     $jobList["VacHowApply"]            =  strip_tags($row->how_to_apply);
                                     if($row->pictures != ''){
                                          $jobList["VacImage"]               =  $row->pictures ;// "http://api.nea.gov.kh/images/images/collectionBgBlue.png";
                                     }else{
                                          $jobList["VacImage"]               =   "http://api.nea.gov.kh/images/images/beautifulbackgrounds-360x192.jpg";
                                     }
                                    
                                   //  $jobList["id"] =  $row->pictures;
                                   /* Mark -- Language Array Object*/
                                     $vacancy_lang= $this->getLanguageByJobID($row->vacancy_id);
                                     $jobList["VacLanguage"] = array();
                                   /* Mark -- Employer Information */
                                     $jobList["VacEmployerInfo"] = array();
                                      array_push($jobList["VacEmployerInfo"], $this->getEmployerInfoByJobID($row->vacancy_id));
                                   //-- Mark for job center information
                                     $jobList["VacJobCenterInfo"] = $this->model_jobapi_v1->getJobCenterInfoByJOBID($row->vacancy_id);
                                     array_push($jobList["VacLanguage"], $vacancy_lang);
                                     array_push($response["jobList"], $jobList); 
                              }
                $response["message"] = "Successful";
                $response["success"] = 1;
                echo json_encode($response); 
                
               
            } else {
            $response["success"] = 0;
            $response["message"] = "Not found";
            echo json_encode($response);
                }
        } else {
            $response["success"] = 0;
            $response["message"] = "Not found";
            echo json_encode($response);
        }
    }
    
    // --- Mark LOCATION date: 30-10-2019
    public function getJobListApiByLocation() { // <------------------------------------------------- Get latest vacancy ----------------------------------------
        header('Content-Type: text/html; charset=utf-8');
        header('Content-Type: application/json');
        $response = array();
        $keyId= $this->input->get('location');
        if ($_SERVER['REQUEST_METHOD'] == 'GET') {
                 $result = $this->model_jobapi_v1->get_all_valiad_job_model_by_location(10,0, $keyId);
                 $result_number_rows = $result->num_rows();
                        if ($result_number_rows > 0) {
                              $response["jobList"] = array();
                               $jobList = array();
                              foreach ($result->result() as $row) {
                                     $jobList["VacID"]                  =  $row->vacancy_id;
                                     $jobList["VacTitle"]               =  $row->job_title;
                                     $jobList["VacTitleISCO"]           =  $row->job_title_isco_code;
                                     $jobList["VacISCOName"]            =  $row->isco_name_eng;
                                     $jobList["VacISCONameKh"]          =  $row->isco_name_kh;
                                     $jobList["VacLocation"]            =  $row->job_location_eng;
                                     $jobList["VacLocationKh"]          =  $row->job_location_kh;
                                     $jobList["VacClosingDate"]         =  date("d-m-Y", strtotime($row->closing_date));
                                     $jobList["VacCreatedDate"]         =  date("d-m-Y", strtotime($row->job_create_date));
                                     $jobList["VacOrgName"]             =  $row->ORG_NAME;
                                     $jobList["VacEmployerID"]          =  $row->employer_id;
                                     $jobList["VacTotalVac"]            =  $row->total_vacancy;
                                     $jobList["VacStartWorkingDate"]    =  date("d-m-Y", strtotime($row->job_start_working));
                                     $jobList["VacPostedDate"]          =  date("d-m-Y", strtotime($row->job_create_date));
                                     $jobList["VacDurationDay"]         =  $row->duration_day;
                                     $jobList["VacTermOfEmployment"]    =  $row->job_term_name;
                                     $jobList["VacTermOfEmploymentKh"]  =  $row->job_term_name_khmer;
                                     $jobList["VacFormOfEmployment"]    =  $row->form_employment_name;
                                     $jobList["VacFormOfEmploymentKh"]  =  $row->form_employment_name_kh;
                                     if($row->base_wage_min>0){
                                     $jobList["VacSalary"]              =  $row->base_wage_min;
                                     }else{
                                      $jobList["VacSalary"]             = "N/A";    
                                     }
                                     $jobList["VacOtherSkillRequirment"]=  trim(preg_replace('/\s+/', ' ',strip_tags($row->other_skill_requirement)));
                                     $jobList["VacEdu"]                 =  $row->degree_name;
                                     $jobList["VacEduKh"]               =  $row->degree_name_khmer;
                                     $jobList["VacEduMajor"]            =  $row->isced_name;
                                     $jobList["VacEduMajorKh"]          =  $row->isced_name_kh;
                                     $jobList["VacMixWorkExp"]          =  $row->minWorkExp . '-Year(s)';
                                     $jobList["VacMixWorkExpKh"]        =  $row->minWorkExp .'-ឆ្នាំ';
                                     $jobList["VacWorkISICExp"]         =  $row->isic_name ;
                                     $jobList["VacOtherPreference"]     =   html_entity_decode(strip_tags($row->other_preference));
                                     $jobList["VacDescription"]         =  strip_tags($row->job_description);
                                     $jobList["VacHowApply"]            =  strip_tags($row->how_to_apply);
                                     if($row->pictures != ''){
                                          $jobList["VacImage"]               =  $row->pictures ;// "http://api.nea.gov.kh/images/images/collectionBgBlue.png";
                                     }else{
                                          $jobList["VacImage"]               =   "http://api.nea.gov.kh/images/images/beautifulbackgrounds-360x192.jpg";
                                     }
                                    
                                   //  $jobList["id"] =  $row->pictures;
                                   /* Mark -- Language Array Object*/
                                     $vacancy_lang= $this->getLanguageByJobID($row->vacancy_id);
                                     $jobList["VacLanguage"] = array();
                                   /* Mark -- Employer Information */
                                     $jobList["VacEmployerInfo"] = array();
                                      array_push($jobList["VacEmployerInfo"], $this->getEmployerInfoByJobID($row->vacancy_id));
                                   //-- Mark for job center information
                                     $jobList["VacJobCenterInfo"] = $this->model_jobapi_v1->getJobCenterInfoByJOBID($row->vacancy_id);
                                     array_push($jobList["VacLanguage"], $vacancy_lang);
                                     array_push($response["jobList"], $jobList); 
                              }
                $response["message"] = "Successful";
                $response["success"] = 1;
                echo json_encode($response); 
                
               
            } else {
            $response["success"] = 0;
            $response["message"] = "Not found";
            echo json_encode($response);
                }
        } else {
            $response["success"] = 0;
            $response["message"] = "Not found";
            echo json_encode($response);
        }
    }
      
    // --- Mark EDUCATION date: 30-10-2019
    public function getJobListApiByEducation() { // <------------------------------------------------- Get latest vacancy ----------------------------------------
        header('Content-Type: text/html; charset=utf-8');
        header('Content-Type: application/json');
        $response = array();
        $keyId= $this->input->get('edu');
        if ($_SERVER['REQUEST_METHOD'] == 'GET') {
                 $result = $this->model_jobapi_v1->get_all_valiad_job_model_by_education(10,0, $keyId);
                 $result_number_rows = $result->num_rows();
                        if ($result_number_rows > 0) {
                              $response["jobList"] = array();
                               $jobList = array();
                              foreach ($result->result() as $row) {
                                     $jobList["VacID"]                  =  $row->vacancy_id;
                                     $jobList["VacTitle"]               =  $row->job_title;
                                     $jobList["VacTitleISCO"]           =  $row->job_title_isco_code;
                                     $jobList["VacISCOName"]            =  $row->isco_name_eng;
                                     $jobList["VacISCONameKh"]          =  $row->isco_name_kh;
                                     $jobList["VacLocation"]            =  $row->job_location_eng;
                                     $jobList["VacLocationKh"]          =  $row->job_location_kh;
                                     $jobList["VacClosingDate"]         =  date("d-m-Y", strtotime($row->closing_date));
                                     $jobList["VacCreatedDate"]         =  date("d-m-Y", strtotime($row->job_create_date));
                                     $jobList["VacOrgName"]             =  $row->ORG_NAME;
                                     $jobList["VacEmployerID"]          =  $row->employer_id;
                                     $jobList["VacTotalVac"]            =  $row->total_vacancy;
                                     $jobList["VacStartWorkingDate"]    =  date("d-m-Y", strtotime($row->job_start_working));
                                     $jobList["VacPostedDate"]          =  date("d-m-Y", strtotime($row->job_create_date));
                                     $jobList["VacDurationDay"]         =  $row->duration_day;
                                     $jobList["VacTermOfEmployment"]    =  $row->job_term_name;
                                     $jobList["VacTermOfEmploymentKh"]  =  $row->job_term_name_khmer;
                                     $jobList["VacFormOfEmployment"]    =  $row->form_employment_name;
                                     $jobList["VacFormOfEmploymentKh"]  =  $row->form_employment_name_kh;
                                     if($row->base_wage_min>0){
                                     $jobList["VacSalary"]              =  $row->base_wage_min;
                                     }else{
                                      $jobList["VacSalary"]             = "N/A";    
                                     }
                                     $jobList["VacOtherSkillRequirment"]=  trim(preg_replace('/\s+/', ' ',strip_tags($row->other_skill_requirement)));
                                     $jobList["VacEdu"]                 =  $row->degree_name;
                                     $jobList["VacEduKh"]               =  $row->degree_name_khmer;
                                     $jobList["VacEduMajor"]            =  $row->isced_name;
                                     $jobList["VacEduMajorKh"]          =  $row->isced_name_kh;
                                     $jobList["VacMixWorkExp"]          =  $row->minWorkExp . '-Year(s)';
                                     $jobList["VacMixWorkExpKh"]        =  $row->minWorkExp .'-ឆ្នាំ';
                                     $jobList["VacWorkISICExp"]         =  $row->isic_name ;
                                     $jobList["VacOtherPreference"]     =   html_entity_decode(strip_tags($row->other_preference));
                                     $jobList["VacDescription"]         =  strip_tags($row->job_description);
                                     $jobList["VacHowApply"]            =  strip_tags($row->how_to_apply);
                                     if($row->pictures != ''){
                                          $jobList["VacImage"]               =  $row->pictures ;// "http://api.nea.gov.kh/images/images/collectionBgBlue.png";
                                     }else{
                                          $jobList["VacImage"]               =   "http://api.nea.gov.kh/images/images/beautifulbackgrounds-360x192.jpg";
                                     }
                                    
                                   //  $jobList["id"] =  $row->pictures;
                                   /* Mark -- Language Array Object*/
                                     $vacancy_lang= $this->getLanguageByJobID($row->vacancy_id);
                                     $jobList["VacLanguage"] = array();
                                   /* Mark -- Employer Information */
                                     $jobList["VacEmployerInfo"] = array();
                                      array_push($jobList["VacEmployerInfo"], $this->getEmployerInfoByJobID($row->vacancy_id));
                                   //-- Mark for job center information
                                     $jobList["VacJobCenterInfo"] = $this->model_jobapi_v1->getJobCenterInfoByJOBID($row->vacancy_id);
                                     array_push($jobList["VacLanguage"], $vacancy_lang);
                                     array_push($response["jobList"], $jobList); 
                              }
                $response["message"] = "Successful";
                $response["success"] = 1;
                echo json_encode($response); 
                
               
            } else {
            $response["success"] = 0;
            $response["message"] = "Not found";
            echo json_encode($response);
                }
        } else {
            $response["success"] = 0;
            $response["message"] = "Not found";
            echo json_encode($response);
        }
    }
    
    
    
    function getEmployerInfoByJobID($job_id=0)
                {
                                $result = $this->model_jobapi_v1->getEmployerInfoByJobIDModel($job_id);
                                if (!empty($result)) {
                                    // check for empty result
                                    if ($result->num_rows() > 0) {
                                        $result = $result->row();
                                        $orgs = array();
                                        $orgs["VacOrgID"]	     = $result->org_id;
                    					$orgs["VacOrgName"]	     = $result->org_name;
                    					$orgs["VacOrgIndustry"]	 = $result->org_sector;
                    					if($result->org_type_en==''){
                    					    $org_type='';
                    					}else{
                    					    $org_type=$result->org_type_en;
                    					}
                    					$orgs["VacOrgType"]	     = $org_type;
                    			 
                    				 	$orgs["VacOrgMainOcc"]	 = $result->org_main_occup;
                    					$orgs["VacOrgAddress"]	 = trim(preg_replace('/\s+/', ' ',strip_tags($result->org_address)));
                    					$orgs["VacOrgBackgroud"]	 = trim(preg_replace('/\s+/', ' ', strip_tags($result->org_background)));
                    					
                    					
                    					if(!$result->org_cont_person){
                    					    $org_cont_person=$result->org_cont_person;
                    					}else{
                    					    $org_cont_person="N/A";
                    					}
                    					$orgs["VacOrgContactPerson"] = $org_cont_person;
                    					
                    					if(!$result->org_office_phone){
                    					    $org_office_phone= $result->org_office_phone;
                    					}else{
                    					    $org_office_phone = "N/A";
                    					}
                    					
                    					$orgs["VacOrgOfficePhone"]= $org_office_phone;
                    					
                    					$orgs["VacOrgFax"]	     = $result->org_fax;
                    				    if (!$result->org_mobile){
                    				      $var_mb = $result->org_mobile;
                    				    }else{
                    				        $var_mb	= "N/A";
                    				    }
                    					$orgs["VacOrgMobile"] = $var_mb;
                    					
                    			     	if ($result->org_email == '') {
                    					  $orgs["VacOrgEmail"] = ' ';
                    					}else{
                    					   $orgs["VacOrgEmail"] = $result->org_email;
                    					}
                    			 
                    				    if (!$result->org_website){
                    				        $orgs["VacOrgWebsite"]=$result->org_website;
                    				    }else{
                    				        $orgs["VacOrgWebsite"]= "N/A";
                    				    }
                    				    $orgs["VacOcgImage"] = $result->image_logo;
                    					
                    					if(!$result->org_let){
                    					   	$orgs["VacOrgLat"] = $result->org_let; 
                    					}else{
                    					    $orgs["VacOrgLat"] = "0.000000"; 
                    					}
                    				 
                    					
                    					if(!$result->org_long){
                    					   	$orgs["VacOrgLong"] = $result->org_long; 
                    					}else{
                    					    $orgs["VacOrgLong"] = "0.000000"; 
                    					}
                    					
                    				 
                                       return ($orgs);
                                    } 
                                 }
            }
    
     public function getJobSearchKeyword($keyword) {
        header('Content-Type: text/html; charset=utf-8');
        header('Content-Type: application/json');
        $response = array();
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            if(isset($_POST['search']))
                {
                 $search_val=$_POST['search'];
                 $result = $this->model_jobapi_v1->get_all_valiad_job_app_model(5,0,'$search_val');
                 $result_number_rows = $result->num_rows();
                        if ($result_number_rows > 0) {
                              $response["jobList"] = array();
                               $jobList = array();
                              foreach ($result->result() as $row) {
                                     $jobList["VacID"]                  =  $row->vacancy_id;
                                     $jobList["VacTitle"]               =  $row->job_title;
                                     $jobList["VacTitleISCO"]           =  $row->job_title_isco_code;
                                     $jobList["VacISCOName"]            =  $row->isco_name_eng;
                                     $jobList["VacISCONameKh"]          =  $row->isco_name_kh;
                                     $jobList["VacLocation"]            =  $row->job_location_eng;
                                     $jobList["VacLocationKh"]          =  $row->job_location_kh;
                                     $jobList["VacClosingDate"]         =  date("d-m-Y", strtotime($row->closing_date));
                                     $jobList["VacCreatedDate"]         =  date("d-m-Y", strtotime($row->job_create_date));
                                     $jobList["VacOrgName"]             =  $row->ORG_NAME;
                                     $jobList["VacEmployerID"]          =  $row->employer_id;
                                     $jobList["VacTotalVac"]            =  $row->total_vacancy;
                                     $jobList["VacStartWorkingDate"]    =  date("d-m-Y", strtotime($row->job_start_working));
                                     $jobList["VacDurationDay"]         =  $row->duration_day;
                                     $jobList["VacTermOfEmployment"]    =  $row->job_term_name;
                                     $jobList["VacTermOfEmploymentKh"]  =  $row->job_term_name_khmer;
                                     $jobList["VacSalary"]              =  $row->job_salary;
                                     $jobList["VacOtherSkillRequirment"]=  trim(preg_replace('/\s+/', ' ',strip_tags($row->other_skill_requirement)));
                                     $jobList["VacEdu"]                 =  $row->degree_name;
                                     $jobList["VacEduKh"]               =  $row->degree_name_khmer;
                                     $jobList["VacEduMajor"]            =  $row->isced_name;
                                     $jobList["VacEduMajorKh"]          =  $row->isced_name_kh;
                                     $jobList["VacMixWorkExp"]          =  $row->minWorkExp . '-Year(s)';
                                     $jobList["VacMixWorkExpKh"]        =  $row->minWorkExp .'-ឆ្នាំ';
                                     $jobList["VacWorkISICExp"]         =  $row->isic_name ;
                                     $jobList["VacOtherPreference"]     =   html_entity_decode(strip_tags($row->other_preference));
                                     $jobList["VacDescription"]         =  html_entity_decode(trim(preg_replace('/\s+/', ' ',strip_tags($row->job_description))));
                                     $jobList["VacHowApply"]            =  trim(preg_replace('/\s+/', ' ',strip_tags($row->how_to_apply)));
                                     $jobList["VacImage"]               =  $row->pictures ;// //"http://www.nea.gov.kh/nweb/images/ic_wallpaper_black.png";
                                   //  $jobList["id"] =  $row->pictures;
                                   /* Mark -- Language Array Object*/
                                     $vacancy_lang= $this->getLanguageByJobID($row->vacancy_id);
                                     $jobList["VacLanguage"] = array();
                                   /* Mark -- Employer Information */
                                     $jobList["VacEmployerInfo"] = array();
                                      array_push($jobList["VacEmployerInfo"], $this->getEmployerInfoByJobID($row->vacancy_id));
                                   //-- Mark for job center information
                                     $jobList["VacJobCenterInfo"] = $this->model_jobapi_v1->getJobCenterByJOBID($row->vacancy_id);// For job center infomation
                                     
                                     array_push($jobList["VacLanguage"], $vacancy_lang);
                                     array_push($response["jobList"], $jobList); 
                              }
                $response["message"] = "Successful";
                $response["success"] = 1;
                echo json_encode($response); 
                
               
            } else {
            $response["success"] = 0;
            $response["message"] = "Not found";
            echo json_encode($response);
                }
        } else {
            $response["success"] = 0;
            $response["message"] = "Not found";
            echo json_encode($response);
        }
        }
    }
    
    
     public function getJobSearch() {
        header('Content-Type: text/html; charset=utf-8');
        header('Content-Type: application/json');
        $response = array();
        if ($_SERVER['REQUEST_METHOD'] == 'GET') {
           
                 $search_val=$_GET['search'];
                 $result = $this->model_jobapi_v1->searchJobTitle($search_val);
                 $result_number_rows = $result->num_rows();
                        if ($result_number_rows > 0) {
                              $response["jobList"] = array();
                               $jobList = array();
                              foreach ($result->result() as $row) {
                                     $jobList["VacID"]                  =  $row->vacancy_id;
                                     $jobList["VacTitle"]               =  $row->job_title;
                                     $jobList["VacTitleISCO"]           =  $row->job_title_isco_code;
                                     $jobList["VacISCOName"]            =  $row->isco_name_eng;
                                     $jobList["VacISCONameKh"]          =  $row->isco_name_kh;
                                      $jobList["VacClosingDate"]         =  date("d-m-Y", strtotime($row->closing_date));
                                    array_push($response["jobList"], $jobList); 
                          
                              }
                $response["message"] = "Successful";
                $response["success"] = 1;
                echo json_encode($response); 
                
               
            } else {
            $response["success"] = 0;
            $response["message"] = "Not found";
            echo json_encode($response);
                }
        } else {
            $response["success"] = 0;
            $response["message"] = "Not found";
            echo json_encode($response);
        }
      
    }
    
   

    public function strip_word_html($text, $allowed_tags = '<b><i><sup><sub><em><strong><u><br>')
    {
        mb_regex_encoding('UTF-8');
        //replace MS special characters first
        $search = array('/&lsquo;/u', '/&rsquo;/u', '/&ldquo;/u', '/&rdquo;/u', '/&mdash;/u');
        $replace = array('\'', '\'', '"', '"', '-');
        $text = preg_replace($search, $replace, $text);
        //make sure _all_ html entities are converted to the plain ascii equivalents - it appears
        //in some MS headers, some html entities are encoded and some aren't
        $text = html_entity_decode($text, ENT_QUOTES, 'UTF-8');
        //try to strip out any C style comments first, since these, embedded in html comments, seem to
        //prevent strip_tags from removing html comments (MS Word introduced combination)
        if(mb_stripos($text, '/*') !== FALSE){
            $text = mb_eregi_replace('#/\*.*?\*/#s', '', $text, 'm');
        }
        //introduce a space into any arithmetic expressions that could be caught by strip_tags so that they won't be
        //'<1' becomes '< 1'(note: somewhat application specific)
        $text = preg_replace(array('/<([0-9]+)/'), array('< $1'), $text);
        $text = strip_tags($text, $allowed_tags);
        //eliminate extraneous whitespace from start and end of line, or anywhere there are two or more spaces, convert it to one
        $text = preg_replace(array('/^\s\s+/', '/\s\s+$/', '/\s\s+/u'), array('', '', ' '), $text);
        //strip out inline css and simplify style tags
        $search = array('#<(strong|b)[^>]*>(.*?)</(strong|b)>#isu', '#<(em|i)[^>]*>(.*?)</(em|i)>#isu', '#<u[^>]*>(.*?)</u>#isu');
        $replace = array('<b>$2</b>', '<i>$2</i>', '<u>$1</u>');
        $text = preg_replace($search, $replace, $text);
        //on some of the ?newer MS Word exports, where you get conditionals of the form 'if gte mso 9', etc., it appears
        //that whatever is in one of the html comments prevents strip_tags from eradicating the html comment that contains
        //some MS Style Definitions - this last bit gets rid of any leftover comments */
        $num_matches = preg_match_all("/\<!--/u", $text, $matches);
        if($num_matches){
              $text = preg_replace('/\<!--(.)*--\>/isu', '', $text);
        }
        return $text;
    }
    
    // --- Mark new job list date: 13-09-2018
    public function getSearchApi() { // <------------------------------------------------- Get job search ----------------------------------------
        header('Content-Type: text/html; charset=utf-8');
        header('Content-Type: application/json');
        $response = array();
        if ($_SERVER['REQUEST_METHOD'] == 'GET') {
                  
		          $keyword= $this->input->get('jobtitle');          //------ key: job title
		          $locationID = $this->input->get('joblocation');  //------ key: job location 
		            if ($locationID == 0) {
		                $locationID = '';
		            }
	                 $result = $this->model_jobapi_v1->Job_Search_Location_Model($keyword,$locationID);
	                 $result_number_rows = $result->num_rows();
                        if ($result_number_rows > 0) {
                              $response["jobList"] = array();
                               $jobList = array();
                              foreach ($result->result() as $row) {
                                     $jobList["VacID"]                  =  $row->vacancy_id;
                                     $jobList["VacTitle"]               =  $row->job_title;
                                     $jobList["VacTitleISCO"]           =  $row->job_title_isco_code;
                                     $jobList["VacISCOName"]            =  $row->isco_name_eng;
                                     $jobList["VacISCONameKh"]          =  $row->isco_name_kh;
                                     $jobList["VacLocation"]            =  $row->job_location_eng;
                                     $jobList["VacLocationKh"]          =  $row->job_location_kh;
                                     $jobList["VacClosingDate"]         =  date("d-m-Y", strtotime($row->closing_date));
                                     $jobList["VacCreatedDate"]         =  date("d-m-Y", strtotime($row->job_create_date));
                                     $jobList["VacOrgName"]             =  $row->ORG_NAME;
                                     $jobList["VacEmployerID"]          =  $row->employer_id;
                                     $jobList["VacTotalVac"]            =  $row->total_vacancy;
                                     $jobList["VacStartWorkingDate"]    =  date("d-m-Y", strtotime($row->job_start_working));
                                     $jobList["VacPostedDate"]          =  date("d-m-Y", strtotime($row->job_create_date));
                                     $jobList["VacDurationDay"]         =  $row->duration_day;
                                     $jobList["VacTermOfEmployment"]    =  $row->job_term_name;
                                     $jobList["VacTermOfEmploymentKh"]  =  $row->job_term_name_khmer;
                                     $jobList["VacFormOfEmployment"]    =  $row->form_employment_name;
                                     $jobList["VacFormOfEmploymentKh"]  =  $row->form_employment_name_kh;
                                     if($row->base_wage_min>0){
                                     $jobList["VacSalary"]              =  $row->base_wage_min;
                                     }else{
                                      $jobList["VacSalary"]             = "N/A";    
                                     }
                                     $jobList["VacOtherSkillRequirment"]=  trim(preg_replace('/\s+/', ' ',strip_tags($row->other_skill_requirement)));
                                     $jobList["VacEdu"]                 =  $row->degree_name;
                                     $jobList["VacEduKh"]               =  $row->degree_name_khmer;
                                     $jobList["VacEduMajor"]            =  $row->isced_name;
                                     $jobList["VacEduMajorKh"]          =  $row->isced_name_kh;
                                     $jobList["VacMixWorkExp"]          =  $row->minWorkExp . '-Year(s)';
                                     $jobList["VacMixWorkExpKh"]        =  $row->minWorkExp .'-ឆ្នាំ';
                                     $jobList["VacWorkISICExp"]         =  $row->isic_name ;
                                     $jobList["VacOtherPreference"]     =   html_entity_decode(strip_tags($row->other_preference));
                                     $jobList["VacDescription"]         =  strip_tags($row->job_description);
                                     $jobList["VacHowApply"]            =  strip_tags($row->how_to_apply);
                                     $jobList["VacImage"]               =  "http://www.nea.gov.kh/nweb/images/ic_wallpaper_black.png";
                                   //  $jobList["id"] =  $row->pictures;
                                   /* Mark -- Language Array Object*/
                                     $vacancy_lang= $this->getLanguageByJobID($row->vacancy_id);
                                     $jobList["VacLanguage"] = array();
                                   /* Mark -- Employer Information */
                                     $jobList["VacEmployerInfo"] = array();
                                      array_push($jobList["VacEmployerInfo"], $this->getEmployerInfoByJobID($row->vacancy_id));
                                   //-- Mark for job center information
                                     $jobList["VacJobCenterInfo"] = $this->model_jobapi_v1->getJobCenterInfoByJOBID($row->vacancy_id);
                                     array_push($jobList["VacLanguage"], $vacancy_lang);
                                     array_push($response["jobList"], $jobList); 
                              }
                $response["message"] = "Successful";
                $response["success"] = 1;
                $response["totlaVac"] = $result_number_rows;
                echo json_encode($response); 
                
               
            } else {
            $response["success"] = 0;
            $response["message"] = "Not found";
            echo json_encode($response);
                }
           
        }
        else {
                $response["success"] = 0;
                $response["message"] = "Not found";
                echo json_encode($response);
            
             }
    }
    
      // --- Mark new job list date: 11-12-2019
    public function getJobListApiKey() { // <------------------------------------------------- Get latest vacancy ----------------------------------------
        header('Content-Type: text/html; charset=utf-8');
        header('Content-Type: application/json');
        $response = array();
        if ($_SERVER['REQUEST_METHOD'] == 'GET') {
            if (isset($_GET["api_key"])) {
               $api_key = $this->input->get('api_key'); 
                    if($api_key = "12345"){
                        $result = $this->model_jobapi_v1->get_all_valiad_job_app_model(10,0);
                 $result_number_rows = $result->num_rows();
                        if ($result_number_rows > 0) {
                              $response["jobList"] = array();
                               $jobList = array();
                              foreach ($result->result() as $row) {
                                     $jobList["VacID"]                  =  $row->vacancy_id;
                                     $jobList["VacTitle"]               =  $row->job_title;
                                     $jobList["VacTitleISCO"]           =  $row->job_title_isco_code;
                                     $jobList["VacISCOName"]            =  $row->isco_name_eng;
                                     $jobList["VacISCONameKh"]          =  $row->isco_name_kh;
                                     $jobList["VacLocation"]            =  $row->job_location_eng;
                                     $jobList["VacLocationKh"]          =  $row->job_location_kh;
                                     $jobList["VacClosingDate"]         =  date("d-m-Y", strtotime($row->closing_date));
                                     $jobList["VacCreatedDate"]         =  date("d-m-Y", strtotime($row->job_create_date));
                                     $jobList["VacOrgName"]             =  $row->ORG_NAME;
                                     $jobList["VacEmployerID"]          =  $row->employer_id;
                                     $jobList["VacTotalVac"]            =  $row->total_vacancy;
                                     $jobList["VacStartWorkingDate"]    =  date("d-m-Y", strtotime($row->job_start_working));
                                     $jobList["VacPostedDate"]          =  date("d-m-Y", strtotime($row->job_create_date));
                                     $jobList["VacDurationDay"]         =  $row->duration_day;
                                     $jobList["VacTermOfEmployment"]    =  $row->job_term_name;
                                     $jobList["VacTermOfEmploymentKh"]  =  $row->job_term_name_khmer;
                                     $jobList["VacFormOfEmployment"]    =  $row->form_employment_name;
                                     $jobList["VacFormOfEmploymentKh"]  =  $row->form_employment_name_kh;
                                     if($row->base_wage_min>0){
                                     $jobList["VacSalary"]              =  $row->base_wage_min;
                                     }else{
                                      $jobList["VacSalary"]             = "N/A";    
                                     }
                                     $jobList["VacOtherSkillRequirment"]=  trim(preg_replace('/\s+/', ' ',strip_tags($row->other_skill_requirement)));
                                     $jobList["VacEdu"]                 =  $row->degree_name;
                                     $jobList["VacEduKh"]               =  $row->degree_name_khmer;
                                     $jobList["VacEduMajor"]            =  $row->isced_name;
                                     $jobList["VacEduMajorKh"]          =  $row->isced_name_kh;
                                     $jobList["VacMixWorkExp"]          =  $row->minWorkExp . '-Year(s)';
                                     $jobList["VacMixWorkExpKh"]        =  $row->minWorkExp .'-ឆ្នាំ';
                                     $jobList["VacWorkISICExp"]         =  $row->isic_name ;
                                     $jobList["VacOtherPreference"]     =   html_entity_decode(strip_tags($row->other_preference));
                                     $jobList["VacDescription"]         =  strip_tags($row->job_description);
                                     $jobList["VacHowApply"]            =  strip_tags($row->how_to_apply);
                                     if($row->pictures != ''){
                                          $jobList["VacImage"]               =  $row->pictures ;// "http://api.nea.gov.kh/images/images/collectionBgBlue.png";
                                     }else{
                                          $jobList["VacImage"]               =   "http://api.nea.gov.kh/images/images/beautifulbackgrounds-360x192.jpg";
                                     }
                                    
                                   //  $jobList["id"] =  $row->pictures;
                                   /* Mark -- Language Array Object*/
                                     $vacancy_lang= $this->getLanguageByJobID($row->vacancy_id);
                                     $jobList["VacLanguage"] = array();
                                   /* Mark -- Employer Information */
                                     $jobList["VacEmployerInfo"] = array();
                                      array_push($jobList["VacEmployerInfo"], $this->getEmployerInfoByJobID($row->vacancy_id));
                                   //-- Mark for job center information
                                     $jobList["VacJobCenterInfo"] = $this->model_jobapi_v1->getJobCenterInfoByJOBID($row->vacancy_id);
                                     array_push($jobList["VacLanguage"], $vacancy_lang);
                                     array_push($response["jobList"], $jobList); 
                              }
                $response["message"] = "Successful";
                $response["success"] = 1;
                echo json_encode($response); 
                    }else{
                              $response["success"] = 0;
            $response["message"] = "Not found";
            echo json_encode($response);
                        
                    }
                 
                    
               
            } else {
            $response["success"] = 0;
            $response["message"] = "Not found";
            echo json_encode($response);
                }
            } else {
            $response["success"] = 0;
            $response["message"] = "Not found";
            echo json_encode($response);
            }
        } else {
            $response["success"] = 0;
            $response["message"] = "Not found";
            echo json_encode($response);
        }
    }
    
    

      // --- Mark new job list date: 11-12-2019
    public function getJobListJobId() { // <------------------------------------------------- Get latest vacancy ----------------------------------------
        header('Content-Type: text/html; charset=utf-8');
        header('Content-Type: application/json');
        
        $response = array();
        if ($_SERVER['REQUEST_METHOD'] == 'GET') {
                  
		    $vi = $this->input->get('vi');          //------ key: job title
	            $result = $this->model_jobapi_v1->JobId_onsearch_Model($vi);
    
                 $result_number_rows = $result->num_rows();
                        if ($result_number_rows > 0) {
                              $response["jobList"] = array();
                               $jobList = array();
                              foreach ($result->result() as $row) {
                                     $jobList["VacID"]                  =  $row->vacancy_id;
                                     $jobList["VacTitle"]               =  $row->job_title;
                                     $jobList["VacTitleISCO"]           =  $row->job_title_isco_code;
                                     $jobList["VacISCOName"]            =  $row->isco_name_eng;
                                     $jobList["VacISCONameKh"]          =  $row->isco_name_kh;
                                     $jobList["VacLocation"]            =  $row->job_location_eng;
                                     $jobList["VacLocationKh"]          =  $row->job_location_kh;
                                     $jobList["VacClosingDate"]         =  date("d-m-Y", strtotime($row->closing_date));
                                     $jobList["VacCreatedDate"]         =  date("d-m-Y", strtotime($row->job_create_date));
                                     $jobList["VacOrgName"]             =  $row->ORG_NAME;
                                     $jobList["VacEmployerID"]          =  $row->employer_id;
                                     $jobList["VacTotalVac"]            =  $row->total_vacancy;
                                     $jobList["VacStartWorkingDate"]    =  date("d-m-Y", strtotime($row->job_start_working));
                                     $jobList["VacPostedDate"]          =  date("d-m-Y", strtotime($row->job_create_date));
                                     $jobList["VacDurationDay"]         =  $row->duration_day;
                                     $jobList["VacTermOfEmployment"]    =  $row->job_term_name;
                                     $jobList["VacTermOfEmploymentKh"]  =  $row->job_term_name_khmer;
                                     $jobList["VacFormOfEmployment"]    =  $row->form_employment_name;
                                     $jobList["VacFormOfEmploymentKh"]  =  $row->form_employment_name_kh;
                                     if($row->base_wage_min>0){
                                     $jobList["VacSalary"]              =  $row->base_wage_min;
                                     }else{
                                      $jobList["VacSalary"]             = "N/A";    
                                     }
                                     $jobList["VacOtherSkillRequirment"]=  trim(preg_replace('/\s+/', ' ',strip_tags($row->other_skill_requirement)));
                                     $jobList["VacEdu"]                 =  $row->degree_name;
                                     $jobList["VacEduKh"]               =  $row->degree_name_khmer;
                                     $jobList["VacEduMajor"]            =  $row->isced_name;
                                     $jobList["VacEduMajorKh"]          =  $row->isced_name_kh;
                                     $jobList["VacMixWorkExp"]          =  $row->minWorkExp . '-Year(s)';
                                     $jobList["VacMixWorkExpKh"]        =  $row->minWorkExp .'-ឆ្នាំ';
                                     $jobList["VacWorkISICExp"]         =  $row->isic_name ;
                                     $jobList["VacOtherPreference"]     =   html_entity_decode(strip_tags($row->other_preference));
                                     $jobList["VacDescription"]         =  strip_tags($row->job_description);
                                     $jobList["VacHowApply"]            =  strip_tags($row->how_to_apply);
                                     if($row->pictures != ''){
                                          $jobList["VacImage"]               =  $row->pictures ;// "http://api.nea.gov.kh/images/images/collectionBgBlue.png";
                                     }else{
                                          $jobList["VacImage"]               =   "http://api.nea.gov.kh/images/images/beautifulbackgrounds-360x192.jpg";
                                     }
                                    
                                   //  $jobList["id"] =  $row->pictures;
                                   /* Mark -- Language Array Object*/
                                     $vacancy_lang= $this->getLanguageByJobID($row->vacancy_id);
                                     $jobList["VacLanguage"] = array();
                                   /* Mark -- Employer Information */
                                     $jobList["VacEmployerInfo"] = array();
                                      array_push($jobList["VacEmployerInfo"], $this->getEmployerInfoByJobID($row->vacancy_id));
                                   //-- Mark for job center information
                                     $jobList["VacJobCenterInfo"] = $this->model_jobapi_v1->getJobCenterInfoByJOBID($row->vacancy_id);
                                     array_push($jobList["VacLanguage"], $vacancy_lang);
                                     array_push($response["jobList"], $jobList); 
                              }
                $response["message"] = "Successful";
                $response["success"] = 1;
                echo json_encode($response); 
                    }else{
            $response["success"] = 0;
            $response["message"] = "Not found";
            echo json_encode($response);
            }
    
        } else {
            $response["success"] = 0;
            $response["message"] = "Not found";
            echo json_encode($response);
        }
    }
    
    public function upcomingEvent()
    {
        header('Content-Type: text/html; charset=utf-8');
        header('Content-Type: application/json');
        $response = array();
        if ($_SERVER['REQUEST_METHOD'] == 'GET') {
	       $result = $this->model_jobapi_v1->GetAllUpcomingEvent();
	           $result_number_rows = $result->num_rows();
                    if ($result_number_rows > 0) {
                        $response["jobList"] = array();
                        $jobList = array();
                        foreach ($result->result() as $row) {
                            $rows[] = $row;
                        }
                          
                $data = array();
                // $data["type"] = $name;
                 $data["success"] = 1;
                 //$data["message"] = $result_number_rows;
                 $data['event'] = $rows;
                 $response= $data;
                 echo json_encode($response);
             
            } else {
                $data = array();
                $data["success"] = 0;
                echo json_encode($data);
                }
        } else {
            $data = array();
            $data["success"] = 0;
            echo json_encode($data);
        }
      }
      
    public function event()
    {
        header('Content-Type: text/html; charset=utf-8');
        header('Content-Type: application/json');
        $response = array();
        if ($_SERVER['REQUEST_METHOD'] == 'GET') {
	       $result = $this->model_jobapi_v1->UpcomingEvent();
	       $result_number_rows = $result->num_rows();
                if ($result_number_rows > 0) {
                    $response["jobList"] = array();
                    $jobList = array();
                        foreach ($result->result() as $row) {
                            $rows[] = $row;
                        }
                          
                    $data = array();
                    // $data["type"] = $name;
                     $data["success"] = 1;
                     //$data["message"] = $result_number_rows;
                     $data['event'] = $rows;
                     $response= $data;
                     
                     echo json_encode( $response);
                } else {
                    $data = array();
                    $data["success"] = 0;
                    echo json_encode($data);
                }
        } else {
            $data = array();
            $data["success"] = 0;
            echo json_encode($data);
        }
      }
      
      
      public function getJobListTitleLocISCOSectorApi() { // <-----------------------------------------
    
        header('Content-Type: text/html; charset=utf-8');
        header('Content-Type: application/json');
        $response = array();
        if ($_SERVER['REQUEST_METHOD'] == 'GET') {
                  
		          $title= $this->input->get('title');
		          $loc = $this->input->get('loc');  //------ key: job location 
		          $isco= $this->input->get('isco');
		          $sector = $this->input->get('sec');
		             
	                 $result = $this->model_jobapi_v1->get_job_by_title_loc_isco_sector($title,$loc,$isco,$sector);
	                 $result_number_rows = $result->num_rows();
                        if ($result_number_rows > 0) {
                              $response["jobList"] = array();
                               $jobList = array();
                              foreach ($result->result() as $row) {
                                     $jobList["VacID"]                  =  $row->vacancy_id;
                                     $jobList["VacTitle"]               =  $row->job_title;
                                     $jobList["VacTitleISCO"]           =  $row->job_title_isco_code;
                                     $jobList["VacISCOName"]            =  $row->isco_name_eng;
                                     $jobList["VacISCONameKh"]          =  $row->isco_name_kh;
                                     $jobList["VacLocation"]            =  $row->job_location_eng;
                                     $jobList["VacLocationKh"]          =  $row->job_location_kh;
                                     $jobList["VacClosingDate"]         =  date("d-m-Y", strtotime($row->closing_date));
                                     $jobList["VacCreatedDate"]         =  date("d-m-Y", strtotime($row->job_create_date));
                                     $jobList["VacOrgName"]             =  $row->ORG_NAME;
                                     $jobList["VacEmployerID"]          =  $row->employer_id;
                                     $jobList["VacTotalVac"]            =  $row->total_vacancy;
                                     $jobList["VacStartWorkingDate"]    =  date("d-m-Y", strtotime($row->job_start_working));
                                     $jobList["VacPostedDate"]          =  date("d-m-Y", strtotime($row->job_create_date));
                                     $jobList["VacDurationDay"]         =  $row->duration_day;
                                     #$jobList["VacTermOfEmployment"]    =  $row->job_term_name;
                                     #$jobList["VacTermOfEmploymentKh"]  =  $row->job_term_name_khmer;
                                     
                                     $employment_ = $this->model_jobapi_v1->get_employment($row->form_of_employment_id);
                                     
                                    $jobList["VacFormOfEmployment"]    = isset($employment_->name_english) ? $employment_->name_english : ""; 
                                    $jobList["VacFormOfEmploymentKh"]  = isset($employment_->name_khmer) ? $employment_->name_khmer : "";
                                    
                                    $formOfEmployment = $this->model_jobapi_v1->get_term_of_employment($row->term_of_employment_contract);
                                    
                                    $jobList["VacTermOfEmployment"]    =  isset($formOfEmployment->job_term_name) ? $formOfEmployment->job_term_name : ""; 
                                    $jobList["VacTermOfEmploymentKh"]  =  isset($formOfEmployment->job_term_name_khmer) ? $formOfEmployment->job_term_name_khmer : "";
                                    
                                    # $jobList["VacFormOfEmployment"]    =  $row->form_employment_name;
                                    # $jobList["VacFormOfEmploymentKh"]  =  $row->form_employment_name_kh;
                                     if($row->base_wage_min>0){
                                     $jobList["VacSalary"]              =  $row->base_wage_min;
                                     }else{
                                      $jobList["VacSalary"]             = "N/A";    
                                     }
                                     $jobList["VacOtherSkillRequirment"]=  trim(preg_replace('/\s+/', ' ',strip_tags($row->other_skill_requirement)));
                                    
                                    $degree_ = $this->model_jobapi_v1->get_degree_history($row->degree_id);
                                    $jobList["VacEdu"]                 =  isset($degree_->degree_name) ? $degree_->degree_name : "";
                                    
                                    $jobList["VacEduKh"]               =  isset($degree_->degree_name_khmer) ? $degree_->degree_name_khmer : "";
                                    
                                    # $jobList["VacEdu"]                 =  $row->degree_name;
                                     #$jobList["VacEduKh"]               =  $row->degree_name_khmer;
                                     $jobList["VacEduMajor"]            =  $row->isced_name;
                                     $jobList["VacEduMajorKh"]          =  $row->isced_name_kh;
                                     $jobList["VacMixWorkExp"]          =  $row->minWorkExp . '-Year(s)';
                                     $jobList["VacMixWorkExpKh"]        =  $row->minWorkExp .'-ឆ្នាំ';
                                     $jobList["VacWorkISICExp"]         =  $row->isic_name ;
                                     $jobList["VacOtherPreference"]     =   html_entity_decode(strip_tags($row->other_preference));
                                     $jobList["VacDescription"]         =  strip_tags($row->job_description);
                                     $jobList["VacHowApply"]            =  strip_tags($row->how_to_apply);
                                     $jobList["VacImage"]               =  "http://www.nea.gov.kh/nweb/images/ic_wallpaper_black.png";
                                   //  $jobList["id"] =  $row->pictures;
                                   /* Mark -- Language Array Object*/
                                     $vacancy_lang= $this->getLanguageByJobID($row->vacancy_id);
                                     $jobList["VacLanguage"] = array();
                                   /* Mark -- Employer Information */
                                     $jobList["VacEmployerInfo"] = array();
                                      array_push($jobList["VacEmployerInfo"], $this->getEmployerInfoByJobID($row->vacancy_id));
                                   //-- Mark for job center information
                                     $jobList["VacJobCenterInfo"] = $this->model_jobapi_v1->getJobCenterInfoByJOBID($row->vacancy_id);
                                     array_push($jobList["VacLanguage"], $vacancy_lang);
                                     array_push($response["jobList"], $jobList); 
                              
                                  
                              }
                $response["message"] = "Successful $title";
                $response["success"] = 1;
                $response["totlaVac"] = $result_number_rows;
                echo json_encode($response); 
                
               
            } else {
            $response["success"] = 0;
            $response["message"] = "Not found";
            echo json_encode($response);
                }
           
        }
        else {
                $response["success"] = 0;
                $response["message"] = "Not found";
                echo json_encode($response);
            
             }
    }
    
       function getJobHomePage($key=ps1234560987654){
        header('Content-Type: text/html; charset=utf-8');
        header('Content-Type: application/json');
        $keyPwd = 'ps1234560987654';
      if($keyPwd==$key){
        $response = array();
    
        
        if ($_SERVER['REQUEST_METHOD'] == 'GET') {
                
                 $type= $this->input->get('type');
               
                 $result = $this->model_jobapi_v1->getEventSoftSkill_V1($type);
                 
                      $result_number_rows = $result->num_rows();
                        if ($result_number_rows > 0) {
                            $rows = array();
                             $response["jobFairList"] = array();
                         
                              foreach ($result->result() as $row) {
                                
                                $rows["id"] = $row->id;
                                $rows["type"] = $row->type;
                                $rows["titleKh"] = $row->titleKh;
                             
                                $rows["softSkillTypeKh"] = $row->softSkillTypeKh;
                               
                                $rows["eventBodyKh"] = $row->eventBodyKh;
                        
                                $rows["eventDate"] = $row->eventDate;
                                $rows["eventDateEnd"] = $row->eventDateEnd;
                                $imagBanner = str_replace(',', '', $row->imageBanner);
                     
                                $rows["imageBanner"] = 'http://nea.gov.kh/images/uploaded/upcoming_event/'.$imagBanner;
                                 
                                 $rows["image"] =$row->image;
                                 
                                 array_push($response["jobFairList"], $rows);
                        }
                          
                   
                
                 $response["success"] = 1;
               
                 
                 
                 echo json_encode($response);
             
            } else {
       
              echo json_encode($response);
                }
        } else {
       
          echo json_encode($response);
        }
      }
    }
    

   
    
    
}
