<?php  if (!defined('BASEPATH')) exit('No direct script access allowed');

    Class center extends CI_Controller {

        public function __construct() {

            parent::__construct();

            /* Assign language */
            $this->lang->load('dic');
            $this->lang->load('library');

            /* Load Library */
            $this->load->library('form_validation');
            $this->load->library('DX_Auth');
            $this->load->library('user_agent');

            if ($this->dx_auth->get_role_id() != 8) {
                redirect('account/logout', 'location');
            }

            $this->load->model("library/model_categories", "lib_category");
            $this->load->model("library/model_books", "lib_book");
            $this->load->model("library/model_author", "lib_author");
            $this->load->model("library/model_donate", "lib_donate");
            $this->load->model("library/model_membership", "lib_membership");
            $this->load->model("library/model_book_center", "lib_bookcenter");

        }

        function dropdown_check($str) {
            if ($str == 0) {
                $this->form_validation->set_message('dropdown_check', $this->lang->line('button_choose').' %s.');
                return FALSE;
            } else {
                return TRUE;
            }
        }

        public function index() {

            $data['page_title'] = "National Employment Agency - Job Library Management";

            /* Load view */
            $this->load->view("library/center/index", $data);
        }

        public function listbook($offset="0") {

            $data['page_title'] = "National Employment Agency - Job Library Management";

            $center_id = $this->dx_auth->get_center_id();

            $limit = 20;

            // retrieve to total record of table
            $total = $this->lib_bookcenter->get_total_book_by_center($center_id);

            // Prepare create pagination
            $config['base_url'] = site_url('library/center/listbook/');
            $config['total_rows'] = $total;
            $config['per_page'] = $limit;
            $config['uri_segment'] = 5;

            $config['num_links'] = 5;

            $this->pagination->initialize($config);

            $data['page_links'] = $this->pagination->create_links();

            // Get data
            $data['list_book'] = $this->lib_bookcenter->get_book_by_center($center_id, $limit, $offset);

            /* Load view */
            $this->load->view("library/center/listbook", $data);

        }

        public function listcategory() {

            $data['page_title'] = "National Employment Agency - Job Library Management";

            $data["list_cate"] = $this->lib_category->select_cate_by_center($this->dx_auth->get_center_id());

            // Load view
            $this->load->view("library/center/listcategory", $data);
        }

        public function newcategory() {

            $data['page_title'] = "National Employment Agency - Job Library Management";

            $val = $this->form_validation;

            $val->set_rules('txtcatename', 'Category Name', 'trim|required');

            if($val->run() == FALSE) {

                // Load view
                $this->load->view("library/center/newcategory", $data);

            } else {

                $cate_name = $this->input->post("txtcatename");
                $center_id = $this->dx_auth->get_center_id();

                $data_cate = array(
                                "category_name"     => $cate_name,
                                "center_id"         => $center_id
                            );

                $this->lib_category->insert($data_cate);

                redirect("library/center/listcategory", "location");
            }

        }

        public function updatecategory($cate_id) {

            $data['page_title'] = "National Employment Agency - Job Library Management";

            $val = $this->form_validation;

            $val->set_rules('txtcatename', 'Category Name', 'trim|required');

            if($val->run() == FALSE) {

                $data["view_cate"] = $this->lib_category->select_one($cate_id)->row();
                // Load view
                $this->load->view("library/center/updatecategory", $data);

            } else {

                $cate_name = $this->input->post("txtcatename");
                $center_id = $this->dx_auth->get_center_id();

                $data_cate = array(
                                "category_name"     => $cate_name
                            );

                $this->lib_category->update($cate_id, $center_id, $data_cate);

                redirect("library/center/listcategory", "location");
            }

        }

        public function deletecategory($cate_id) {
            $check_book = $this->lib_book->get_category_total_books($cate_id);

            if ($check_book > 0) {

                $data['page_title'] = "National Employment Agency - Job Library Management";
                $this->load->view("library/center/deletecategory", $data);

            } else {
                $this->lib_category->delete($cate_id, $this->dx_auth->get_center_id());

                redirect("library/center/listcategory", "location");
            }



        }

        public function listauthor() {

            $data['page_title'] = "National Employment Agency - Job Library Management";

            $data["list_author"] = $this->lib_author->select_author_by_center($this->dx_auth->get_center_id());

            // Load view
            $this->load->view("library/center/listauthor", $data);

        }

        public function newauthor() {

            $data['page_title'] = "National Employment Agency - Job Library Management";

            $val = $this->form_validation;

            $val->set_rules('txtauthor', 'Author Name', 'trim|required');

            if($val->run() == FALSE) {

                // Load view
                $this->load->view("library/center/newauthor", $data);

            } else {

                $author_name = $this->input->post("txtauthor");
                $center_id = $this->dx_auth->get_center_id();

                $data_author = array(
                                "author_name"     => $author_name,
                                "center_id"         => $center_id
                            );

                $this->lib_author->insert($data_author);

                redirect("library/center/listauthor", "location");
            }

        }

        public function updateauthor($author_id) {

            $data['page_title'] = "National Employment Agency - Job Library Management";

            $val = $this->form_validation;

            $val->set_rules('txtauthor', 'Author Name', 'trim|required');

            if($val->run() == FALSE) {

                $data["view_author"] = $this->lib_author->select_one($author_id)->row();
                // Load view
                $this->load->view("library/center/updateauthor", $data);

            } else {

                $author_name = $this->input->post("txtauthor");
                $center_id = $this->dx_auth->get_center_id();

                $data_author = array(
                                "author_name"     => $author_name
                            );

                $this->lib_author->update($author_id, $center_id, $data_author);

                redirect("library/center/listauthor", "location");
            }

        }

        public function deleteauthor($author_id) {
            $check_book = $this->lib_book->get_author_total_books($author_id);

            if ($check_book > 0) {

                $data['page_title'] = "National Employment Agency - Job Library Management";
                $this->load->view("library/center/deleteauthor", $data);

            } else {
                $this->lib_author->delete($author_id, $this->dx_auth->get_center_id());

                redirect("library/center/listauthor", "location");
            }

        }

        public function listdonate() {

            $data['page_title'] = "National Employment Agency - Job Library Management";

            $data["list_donate"] = $this->lib_donate->select_donate_by_center($this->dx_auth->get_center_id());

            // Load view
            $this->load->view("library/center/listdonate", $data);

        }

        public function newdonate() {

            $data['page_title'] = "National Employment Agency - Job Library Management";

            $val = $this->form_validation;

            $val->set_rules('txtorgname', 'Org Name', 'trim|required');
            $val->set_rules('txtorgaddress', 'Address', 'trim|required');
            $val->set_rules('txtofficemobile', 'Office Mobile', 'trim|required');
            $val->set_rules('txtorgfax', 'Fax', 'trim');
            $val->set_rules('txtorgemail', 'Email Address', 'trim|valid_email');
            $val->set_rules('txtorgwebsite', 'Website', 'trim');

            if($val->run() == FALSE) {

                // Load view
                $this->load->view("library/center/newdonate", $data);

            } else {

                $org_name = $this->input->post("txtorgname");
                $org_address = $this->input->post("txtorgaddress");
                $org_office = $this->input->post("txtofficemobile");
                $org_fax = $this->input->post("txtorgfax");
                $org_email = $this->input->post("txtorgemail");
                $org_website = $this->input->post("txtorgwebsite");
                $center_id = $this->dx_auth->get_center_id();

                $data_donate = array(
                                "org_name"     => $org_name,
                                "org_address"     => $org_address,
                                "org_office"     => $org_office,
                                "org_fax"     => $org_fax,
                                "org_email"     => $org_email,
                                "org_website"     => $org_website,
                                "center_id"         => $center_id
                            );

                $this->lib_donate->insert($data_donate);

                redirect("library/center/listdonate", "location");
            }

        }

        public function updatedonate($donate_id) {

            $data['page_title'] = "National Employment Agency - Job Library Management";

            $val = $this->form_validation;

            $val->set_rules('txtorgname', 'Name', 'trim|required');
            $val->set_rules('txtorgaddress', 'Address', 'trim|required');
            $val->set_rules('txtofficemobile', 'Office Mobile', 'trim|required');
            $val->set_rules('txtorgfax', 'Fax', 'trim|required');
            $val->set_rules('txtorgemail', 'Email Address', 'trim|required');
            $val->set_rules('txtorgwebsite', 'Website', 'trim|required');

            if($val->run() == FALSE) {

                $data["view_donate"] = $this->lib_donate->select_one($donate_id)->row();
                // Load view
                $this->load->view("library/center/updatedonate", $data);

            } else {

                $org_name = $this->input->post("txtorgname");
                $org_address = $this->input->post("txtorgaddress");
                $org_office = $this->input->post("txtofficemobile");
                $org_fax = $this->input->post("txtorgfax");
                $org_email = $this->input->post("txtorgemail");
                $org_website = $this->input->post("txtorgwebsite");
                $center_id = $this->dx_auth->get_center_id();

                $data_donate = array(
                                "org_name"     => $org_name,
                                "org_address"     => $org_address,
                                "org_office"     => $org_office,
                                "org_fax"     => $org_fax,
                                "org_email"     => $org_email,
                                "org_website"     => $org_website
                            );

                $this->lib_donate->update($donate_id, $center_id, $data_donate);

                redirect("library/center/listdonate", "location");
            }

        }

        public function deletedonate($donate_id) {

            $check_book = $this->lib_book->get_donate_total_books($donate_id);

            if ($check_book > 0) {

                $data['page_title'] = "National Employment Agency - Job Library Management";
                $this->load->view("library/center/deletedonate", $data);

            } else {
                $this->lib_donate->delete($donate_id, $this->dx_auth->get_center_id());

                redirect("library/center/listdonate", "location");
            }

        }

        public function membership($offset="0") {

            $center_id = $this->dx_auth->get_center_id();

            $data['page_title'] = "National Employment Agency - Job Library Management";

            $limit = 40;

            // retrieve to total record of table
			$total = $this->lib_membership->get_total($center_id);

            // Prepare create pagination
			$config['base_url'] = site_url('library/center/membership/');
			$config['total_rows'] = $total;
			$config['per_page'] = $limit;
			$config['uri_segment'] = 5;

			$config['num_links'] = 5;

			$this->pagination->initialize($config);

            $data['page_links'] = $this->pagination->create_links();

            // Get data
            $data['list_member'] = $this->lib_membership->get_membership($center_id, $limit, $offset);

            $this->load->view("library/center/membership", $data);
        }

        public function newmembership() {

            $data['page_title'] = "National Employment Agency - Job Library Management";

            $val = $this->form_validation;

            $val->set_rules('txtfullname', 'Full Name', 'trim|required');
            $val->set_rules('txtdob', 'Date of Birth', 'trim|required');
            $val->set_rules('txtpob', 'Place of Birth', 'trim|required');
            $val->set_rules('txtIDCard', 'Identity Card Number', 'trim|required');
            $val->set_rules('txtocc', 'Occupation', 'trim');
            $val->set_rules('txtshool', 'School/Work Place', 'trim');
            $val->set_rules('txtaddress', 'Current Address', 'trim|required');
            $val->set_rules('txtmobile', 'Mobile Number', 'trim|required');
            $val->set_rules('txtemail', 'Email Address', 'trim');

            if($val->run() == FALSE) {

                // Load view
                $this->load->view("library/center/newmembership", $data);
            }else {
                $fullname = $this->input->post("txtfullname");
                $gender = $this->input->post("cbogender");
                $dob = $this->input->post("txtdob");
                $pob = $this->input->post("txtpob");
                $idcard = $this->input->post("txtIDCard");
                $occupation = $this->input->post("txtocc");
                $workplace = $this->input->post("txtshool");
                $address = $this->input->post("txtaddress");
                $mobilephone = $this->input->post("txtmobile");
                $emailaddress = $this->input->post("txtemail");
                $center_id = $this->dx_auth->get_center_id();

                $data_arry = array(
                                    "fullname"      => $fullname,
                                    "gender"        => $gender,
                                    "dob"           => $dob,
                                    "pob"           => $pob,
                                    "idcard"        => $idcard,
                                    "occupation"    => $occupation,
                                    "workplace"     => $workplace,
                                    "address"       => $address,
                                    "mobilephone"   => $mobilephone,
                                    "emailaddress"  => $emailaddress,
                                    "center_id"     => $center_id
                                );

                $this->lib_membership->insert($data_arry);

                redirect("library/center/membership", "location");
            }
        }

        public function viewmember($id) {

            $data['page_title'] = "National Employment Agency - Job Library Management";

            $center_id = $this->dx_auth->get_center_id();

            $data['view_member'] = $this->lib_membership->select_one($id, $center_id)->row();

            $this->load->view("library/center/viewmember", $data);

        }

        public function updatemember($id) {

            $data['page_title'] = "National Employment Agency - Job Library Management";

            $val = $this->form_validation;

            $val->set_rules('txtfullname', 'Full Name', 'trim|required');
            $val->set_rules('txtdob', 'Date of Birth', 'trim|required');
            $val->set_rules('txtpob', 'Place of Birth', 'trim|required');
            $val->set_rules('txtIDCard', 'Identity Card Number', 'trim|required');
            $val->set_rules('txtocc', 'Occupation', 'trim');
            $val->set_rules('txtshool', 'School/Work Place', 'trim');
            $val->set_rules('txtaddress', 'Current Address', 'trim|required');
            $val->set_rules('txtmobile', 'Mobile Number', 'trim|required');
            $val->set_rules('txtemail', 'Email Address', 'trim');

            if($val->run() == FALSE) {

                $center_id = $this->dx_auth->get_center_id();

                $data['view_member'] = $this->lib_membership->select_one($id, $center_id)->row();

                // Load view
                $this->load->view("library/center/updatemember", $data);
            }else {
                $fullname = $this->input->post("txtfullname");
                $gender = $this->input->post("cbogender");
                $dob = $this->input->post("txtdob");
                $pob = $this->input->post("txtpob");
                $idcard = $this->input->post("txtIDCard");
                $occupation = $this->input->post("txtocc");
                $workplace = $this->input->post("txtshool");
                $address = $this->input->post("txtaddress");
                $mobilephone = $this->input->post("txtmobile");
                $emailaddress = $this->input->post("txtemail");
                $center_id = $this->dx_auth->get_center_id();

                $data_arry = array(
                                    "fullname"      => $fullname,
                                    "gender"        => $gender,
                                    "dob"           => $dob,
                                    "pob"           => $pob,
                                    "idcard"        => $idcard,
                                    "occupation"    => $occupation,
                                    "workplace"     => $workplace,
                                    "address"       => $address,
                                    "mobilephone"   => $mobilephone,
                                    "emailaddress"  => $emailaddress
                                );

                $this->lib_membership->update($id, $center_id, $data_arry);

                redirect("library/center/membership", "location");
            }
        }

        public function deletemember($id) {

        }

        public function catebook() {

        }

        public function newbook() {

            $val = $this->form_validation;

            $val->set_rules('txtbooktitle', 'Book Title', 'trim|required');

            if($val->run() == FALSE) {

                $data['page_title'] = "National Employment Agency - Job Library Management";

                // Load view
                $this->load->view("library/center/newbook", $data);

            } else {

                $booktitle = $this->input->post("txtbooktitle");
                redirect("library/center/confirmbook/".rawurlencode($booktitle), 'location');
            }

        }

        public function confirmbook($booktitle) {

            $listbook = $this->lib_book->searchbooktitle(rawurldecode($booktitle));

            if ($listbook->num_rows() > 0 ) {

                $data['page_title'] = "National Employment Agency - Job Library Management";

                $data['listbook'] = $listbook;

                // Load view
                $this->load->view("library/center/confirmbook", $data);

            } else {

                redirect("library/center/savebook", "location");

            }

        }

        public function savebook() {

            $data['page_title'] = "National Employment Agency - Job Library Management";

            $val = $this->form_validation;

            $val->set_rules('txtbookcode', 'Book Code', 'trim|required|xss_clean');
            $val->set_rules('txtbooktitle', 'Book Title', 'trim|required|xss_clean');
            $val->set_rules('cbocate', 'Book Category', 'trim|required|callback_dropdown_check|xss_clean');
            $val->set_rules('cboauthor', 'Author', 'trim|required|callback_dropdown_check|xss_clean');
            $val->set_rules('cbodonate', 'Donate', 'trim|required|callback_dropdown_check|xss_clean');
            $val->set_rules('txtisbn', 'Book ISBN', 'trim|required|xss_clean');
            $val->set_rules('txtpublisher', 'Book Publisher', 'trim|required|xss_clean');
            $val->set_rules('txtyear', 'Book Publisher Year', 'trim|required|numeric|xss_clean');
            $val->set_rules('txtpages', 'Total Page', 'trim|required|numeric|xss_clean');
            $val->set_rules('txtdescription', 'Book Description', 'trim|required');
            $val->set_rules('txtkeyword', 'Book Keyword', 'trim|required|xss_clean');
            $val->set_rules('txttotal', 'Total Books', 'trim|required|xss_clean');


            if ($val->run() == FALSE) {

                // Get data
                $data['list_cate'] = $this->lib_category->select_all();
                $data['list_auth'] = $this->lib_author->select_all();
                $data['list_donate'] = $this->lib_donate->select_all();
                // Load view
                $this->load->view("library/center/savebook", $data);
            } else {

                $book_code = $this->input->post('txtbookcode');
                $book_title = $this->input->post('txtbooktitle');
                $book_category = $this->input->post('cbocate');
                $book_author_id = $this->input->post('cboauthor');
                $book_donate_id = $this->input->post('cbodonate');
                $book_isbn = $this->input->post('txtisbn');
                $book_publisher = $this->input->post('txtpublisher');
                $book_publish_year = $this->input->post('txtyear');
                $book_total_page = $this->input->post('txtpages');
                $book_description = $this->input->post('txtdescription');
                $book_keyword = $this->input->post('txtkeyword');
                $book_photo = "";
                $book_date_add = date('Y-m-d H:i:s', time());
                $book_user_add = $this->dx_auth->get_center_id();
                $total_book = $this->input->post('txttotal');

                $config['upload_path'] = './book/';

                $config['allowed_types'] = '*';

                $config['max_size']    = '100';

                $config['overwrite'] = TRUE;


                $this->load->library('upload', $config);

                if ( ! $this->upload->do_upload()) {
                    $book_photo = "no-cover.jpg";
                } else {

                    $upload_data = $this->upload->data();
                    $book_photo = $upload_data['file_name'];

                }

                $data_array = array(
                                'book_code'         => $book_code,
                                'book_title'        => $book_title,
                                'book_category'     => $book_category,
                                'book_author_id'    => $book_author_id,
                                'book_donate_id'    => $book_donate_id,
                                'book_isbn'         => $book_isbn,
                                'book_publisher'    => $book_publisher,
                                'book_publish_year' => $book_publish_year,
                                'book_total_page'   => $book_total_page,
                                'book_description'  => $book_description,
                                'book_keyword'      => $book_keyword,
                                'book_photo'        => $book_photo,
                                "book_date_add"     => $book_date_add,
                                "book_user_add"     => $book_user_add
                            );

                $book_id = $this->lib_book->insert($data_array);

                $data_center = array(
                                "center_id"         => $book_user_add,
                                "user_id"           => $this->dx_auth->get_user_id(),
                                "book_id"           => $book_id,
                                "total_book"        => $total_book
                                    );

                $this->lib_bookcenter->insert($data_center);

                redirect("library/center/listbook", "location");
            }
        }

        public function havebook($bookid) {

            $data['page_title'] = "National Employment Agency - Job Library Management";

            $val = $this->form_validation;

            $val->set_rules('txttotal', 'Total Books', 'trim|required|xss_clean');

            if ($val->run() == FALSE) {

                $data['view_book'] = $this->lib_book->select_one($bookid)->row();

                // Load view
                $this->load->view("library/center/havebook", $data);

            }  else {

                $book_user_add = $this->dx_auth->get_center_id();
                $total_book = $this->input->post('txttotal');

                $have = $this->lib_bookcenter->check_have_book($book_user_add, $bookid);

                if ($have > 0) {

                    $this->lib_bookcenter->update($book_user_add, $bookid, $total_book);

                    redirect("library/center/viewbook/".$bookid, "location");

                } else {

                    $data_center = array(
                                "center_id"         => $book_user_add,
                                "user_id"         => $this->dx_auth->get_user_id(),
                                "book_id"           => $bookid,
                                "total_book"        => $total_book
                                    );

                    $this->lib_bookcenter->insert($data_center);

                    redirect("library/center/listbook", "location");
                }


            }


        }

        public function viewbook($bookid) {

            $data['page_title'] = "National Employment Agency - Job Library Management";
            $center_id = $this->dx_auth->get_center_id();
            $data['view_book'] = $this->lib_book->select_one($bookid)->row();
            $data['total_book'] = $this->lib_bookcenter->select_one($center_id, $bookid)->row();

            // Load view
            $this->load->view("library/center/viewbook", $data);

        }

        public function upldatephoto($bookid) {

            $data['page_title'] = "National Employment Agency - Job Library Management";

            $data['view_book'] = $this->lib_book->select_one($bookid)->row();

            // Load view
            $this->load->view("library/center/upldatephoto", $data);

        }

        public function do_upload($bookid) {

            $config['upload_path'] = './book/';

            $config['allowed_types'] = '*';

            $config['max_size']    = '100';

            $config['overwrite'] = TRUE;

            $book_photo = "no-cover.jpg";

            $this->load->library('upload', $config);

            if ( !$this->upload->do_upload()) {
                $book_photo = "no-cover.jpg";
            } else {

                $upload_data = $this->upload->data();
                $book_photo = $upload_data['file_name'];
            }

            $data_array = array('book_photo'  => $book_photo);

            $this->lib_book->update($bookid, $data_array);

            redirect("library/center/viewbook/".$bookid, "location");

        }

        public function updatebook($book_id) {

            $data['page_title'] = "National Employment Agency - Job Library Management";

            $val = $this->form_validation;

            $val->set_rules('txtbookcode', 'Book Code', 'trim|required|xss_clean');
            $val->set_rules('txtbooktitle', 'Book Title', 'trim|required|xss_clean');
            $val->set_rules('cbocate', 'Book Category', 'trim|required|callback_dropdown_check|xss_clean');
            $val->set_rules('cboauthor', 'Author', 'trim|required|callback_dropdown_check|xss_clean');
            $val->set_rules('cbodonate', 'Donate', 'trim|required|callback_dropdown_check|xss_clean');
            $val->set_rules('txtisbn', 'Book ISBN', 'trim|required|xss_clean');
            $val->set_rules('txtpublisher', 'Book Publisher', 'trim|required|xss_clean');
            $val->set_rules('txtyear', 'Book Publisher Year', 'trim|required|numeric|xss_clean');
            $val->set_rules('txtpages', 'Total Page', 'trim|required|numeric|xss_clean');
            $val->set_rules('txtdescription', 'Book Description', 'trim|required');
            $val->set_rules('txtkeyword', 'Book Keyword', 'trim|required|xss_clean');


            if ($val->run() == FALSE) {

                // Get data
                $data['list_cate'] = $this->lib_category->select_all();
                $data['list_auth'] = $this->lib_author->select_all();
                $data['list_donate'] = $this->lib_donate->select_all();

                $data['list_book'] = $this->lib_book->select_book_update($book_id)->row();
                // Load view
                $this->load->view("library/center/updatebook", $data);
            } else {

                $book_code = $this->input->post('txtbookcode');
                $book_title = $this->input->post('txtbooktitle');
                $book_category = $this->input->post('cbocate');
                $book_author_id = $this->input->post('cboauthor');
                $book_donate_id = $this->input->post('cbodonate');
                $book_isbn = $this->input->post('txtisbn');
                $book_publisher = $this->input->post('txtpublisher');
                $book_publish_year = $this->input->post('txtyear');
                $book_total_page = $this->input->post('txtpages');
                $book_description = $this->input->post('txtdescription');
                $book_keyword = $this->input->post('txtkeyword');


                $data_array = array(
                                'book_code'         => $book_code,
                                'book_title'        => $book_title,
                                'book_category'     => $book_category,
                                'book_author_id'    => $book_author_id,
                                'book_donate_id'    => $book_donate_id,
                                'book_isbn'         => $book_isbn,
                                'book_publisher'    => $book_publisher,
                                'book_publish_year' => $book_publish_year,
                                'book_total_page'   => $book_total_page,
                                'book_description'  => $book_description,
                                'book_keyword'      => $book_keyword
                            );

                $this->lib_book->update($book_id, $data_array);

                redirect("library/center/viewbook/".$book_id, "location");
            }

        }

        public function categorybook() {

            $data['page_title'] = "National Employment Agency - Job Library Management";
            $data['list_cate'] = $this->lib_category->select_all();

            // Load view
            $this->load->view("library/center/catebook", $data);

        }

        public function categorytype($cate_id, $offset="0") {

            $view_cate = $this->lib_category->select_one($cate_id);

            $center_id = $this->dx_auth->get_center_id();

            $data['view_cate'] = $view_cate->row();

            // Page title
            $data['page_title'] = "National Employment Agency - Job Library Management";

            $limit = 20;

            // retrieve to total record of table
            $total = $this->lib_category->get_category_total_books($cate_id, $center_id);

            // Prepare create pagination
            $config['base_url'] = site_url('library/center/categorytype/'.$cate_id);
            $config['total_rows'] = $total;
            $config['per_page'] = $limit;
            $config['uri_segment'] = 6;

            $config['num_links'] = 5;

            $this->pagination->initialize($config);

            $data['page_links'] = $this->pagination->create_links();

            // Get data
            $data['list_book'] = $this->lib_category->get_book_by_cate($cate_id, $center_id, $limit, $offset);

            $this->load->view("library/center/categorytype", $data);

        }
    }
?>