<?php
    class restapi extends CI_Controller {

        function __construct() {
            parent :: __construct();
            $this->load->library('DX_Auth');
            $this->load->library('user_agent');
        }

        function checklogin() {
            // uid : jc_1
            // pwd : 1234

            $valid = false;
            if (isset ($_SERVER['PHP_AUTH_USER'])) {
                $username = $_SERVER['PHP_AUTH_USER'];
                $password = $_SERVER['PHP_AUTH_PW'];
                if ($this->dx_auth->login(strtolower($username), $password, FALSE)) {
                    $role_id = $this->dx_auth->get_role_id();
                    if ($role_id == 6 OR $role_id == 7) {
                        $valid = true;
                    }
                }
            }
            if (!$valid) {
                header('WWW-Authenticate: Basic realm="National Employment Agency"');
                //header('HTTP/1.0 401 Unauthorized');
                //echo 'Access Denied';
                http_response_code(401);
                return false;
            }
            return true;
        }
        
          function logout() {
        	$this->dx_auth->logout();
	    	$data['auth_message'] = 'You have been logged out.';	
	    	 redirect('restapi/checklogin', 'refresh');
 
        }

        function verifylogin() {
            if ($_SERVER['REQUEST_METHOD'] != 'POST') {
                http_response_code(404);
            }
        }

		function encode()
		{
			$password = '';
			if ($_SERVER['REQUEST_METHOD'] == 'GET') {
				$password =  $this->input->get('password');
			} else if ($_SERVER['REQUEST_METHOD'] == 'POST') {
				$password =  $this->input->post('password');
			}

			$data['json'] = $this->dx_auth->_encode($password);
			$this->load->view('json_view', $data);
		}

		function encrypt()
		{
			$password =  '';
			if ($_SERVER['REQUEST_METHOD'] == 'GET') {
				$password =  $this->dx_auth->_encode($this->input->get('password'));
			} else if ($_SERVER['REQUEST_METHOD'] == 'POST') {
				$password =  $this->dx_auth->_encode($this->input->post('password'));
			}

			$data['json'] = crypt($password);
			$this->load->view('json_view', $data);
		}

		function secueverify()
		{
			$password = '';
			$encrypt = '';

			if ($_SERVER['REQUEST_METHOD'] == 'GET') {
				$password = $this->input->get('password');
				$encrypt = $this->input->get('encrypt');
			} else if ($_SERVER['REQUEST_METHOD'] == 'POST') {
				$password = $this->input->post('password');
				$encrypt = $this->input->post('encrypt');
			}

            $data['json'] = '';

			if (crypt($password, $encrypt) === $encrypt) {
				$data['json'] = 'Yes';
			} else {
				$data['json'] = 'No';
			}
			$this->load->view('json_view', $data);
		}

		function plainverify()
		{
			$password = '';
			$encrypt = '';

			if ($_SERVER['REQUEST_METHOD'] == 'GET') {
				$password = $this->input->get('password');
				$encrypt = $this->input->get('encrypt');
			} else if ($_SERVER['REQUEST_METHOD'] == 'POST') {
				$password = $this->input->post('password');
				$encrypt = $this->input->post('encrypt');
			}

            $data['json'] = '';

			if (crypt($this->dx_auth->_encode($password), $encrypt) === $encrypt) {
				$data['json'] = 'Yes';
			} else {
				$data['json'] = 'No';
			}
			$this->load->view('json_view', $data);
		}

    }
