<?php

    Class model_categories extends CI_Model {

        public function insert($data) {
            $this->db->trans_start();
            $this->db->insert('lib_category', $data);
            $this->db->trans_complete();
        }

        public function update($cate_id, $center_id, $data) {
            $this->db->trans_start();
            $this->db->where('id', $cate_id);
            $this->db->where('center_id', $center_id);
            $this->db->update('lib_category', $data);
            $this->db->trans_complete();
        }

        public function delete($cate_id, $center_id) {
            $this->db->trans_start();
            $this->db->where('id', $cate_id);
            $this->db->where('center_id', $center_id);
            $this->db->delete('lib_category');
            $this->db->trans_complete();
        }

        public function select_all() {

            $this->db->select("id, category_name");
            $this->db->from("lib_category");
            $this->db->order_by("id","ASC");

            return $this->db->get();
        }

        public function select_one($id) {
            $this->db->select("id, category_name");
            $this->db->from("lib_category");
            $this->db->where("id",$id);

            return $this->db->get();
        }

        public function select_cate_by_center($center_id) {

            $this->db->select("id, category_name");
            $this->db->from("lib_category");
            $this->db->where("center_id",$center_id);

            return $this->db->get();
        }

        public function get_category_total_books($cate_id, $center_id) {

            $this->db->from("lib_books");
            $this->db->where("book_category", $cate_id);
            $this->db->where("book_user_add",$center_id);

            return $this->db->count_all_results();
        }

        public function get_book_by_cate($cate_id, $center_id, $limit, $offset){

            $this->db->limit($limit, $offset);
            $this->db->select("id, book_title, book_photo");
            $this->db->from("lib_books");
            $this->db->where("book_category", $cate_id);
            $this->db->where("book_user_add",$center_id);
            $this->db->order_by("id", "DESC");

            return $this->db->get();
        }
    }
?>