<?php
    Class model_donate extends CI_Model {

        public function select_one($donatee_id) {

            $this->db->select("*");
            $this->db->from("lib_donate");
            $this->db->where("id", $donatee_id);

            return $this->db->get();
        }

        public function select_all() {

            $this->db->select("*");
            $this->db->from("lib_donate");
            $this->db->order_by("org_name", "ASC");

            return $this->db->get();
        }

        public function select_donate_by_center($center_id) {
            $this->db->select("*");
            $this->db->from("lib_donate");
            $this->db->where("center_id", $center_id);

            return $this->db->get();
        }

        public function insert($data) {
            $this->db->trans_start();
            $this->db->insert('lib_donate', $data);
            $this->db->trans_complete();
        }

        public function update($donate_id, $center_id, $data) {
            $this->db->trans_start();
            $this->db->where('id', $donate_id);
            $this->db->where('center_id', $center_id);
            $this->db->update('lib_donate', $data);
            $this->db->trans_complete();
        }

        public function delete($donate_id, $center_id) {
            $this->db->trans_start();
            $this->db->where('id', $donate_id);
            $this->db->where('center_id', $center_id);
            $this->db->delete('lib_donate');
            $this->db->trans_complete();
        }
    }
?>