<?php
class mod_home extends CI_Model {
    function get_about_nea($language_id){
        $this->db->select('value');
        $this->db->where('language_id',$language_id);
        $this->db->where('reference_id', '49');
        $this->db->where('reference_field','introtext');
        return $this->db->get('jos_jf_content');
    }

    function get_news_all($ordering,$news_type){
        $this->db->where('ordering >=',$ordering);
        $this->db->where('news_type',$news_type);
        $this->db->where_not_in('status','0');
        $this->db->order_by('ordering', 'asc');
        $this->db->limit('15','0');
        return $this->db->get('tb_news');
    }
    
    function get_news_feeds_all($news_id){

        //$this->db->where('ordering >=',$ordering);
        $this->db->where('news_feeds_id <=',$news_id);
        $this->db->where_not_in('status','0');
        $this->db->order_by('ordering', 'asc');
        $this->db->limit('15','0');
        return $this->db->get('tb_news_feeds');
    }

    function get_news_feeds_share($ordering){

        //$this->db->where('ordering =',$ordering);
        $this->db->where('news_feeds_id =',$ordering);
        $this->db->where_not_in('status','0');
        //$this->db->order_by('ordering', 'asc');
        $this->db->limit('1','0');
        return $this->db->get('tb_news_feeds');
    }

    
    function get_news_feeds_3($ordering){
        
        $this->db->where('ordering >=',$ordering);
        $this->db->where_not_in('status','0');
        $this->db->order_by('ordering', 'asc');
        $this->db->limit('3','0');
        return $this->db->get('tb_news_feeds');
    }
/*
    function get_announcement_all($ordering){
        
        $this->db->where('ordering >=',$ordering);
        $this->db->where_not_in('status','0');
        $this->db->order_by('ordering', 'asc');
        $this->db->limit('15','0');
        return $this->db->get('tb_announcement');
    }
*/
    function get_announcement_all($ordering, $limit, $offset){

        $this->db->where('ordering >=',$ordering);
        $this->db->where_not_in('status','0');
        $this->db->order_by('ordering', 'asc');
        //$this->db->limit('15','0');
        $this->db->limit($limit,$offset);
        return $this->db->get('tb_announcement');
    }

    function get_announcement_3($ordering){
        
        $this->db->where('ordering >=',$ordering);
        $this->db->where_not_in('status','0');
        $this->db->order_by('ordering', 'asc');
        $this->db->limit('3','0');
        return $this->db->get('tb_announcement');
    }

    function get_upcoming_event_all($ordering,$type){
        
        $this->db->where('ordering >=',$ordering);
        $this->db->where('event_type',$type);
        $this->db->where_not_in('status','0');
        
        $this->db->where('event_date >= CURDATE()' );
        $this->db->order_by('ordering', 'asc');
        $this->db->limit('15','0');
        return $this->db->get('tb_upcoming_event');
    }
    
    function get_upcoming_event_newer_3($ordering,$type){
        
        $this->db->where('ordering <',$ordering);
        $this->db->where('event_type',$type);
        $this->db->where('event_date >= CURDATE()' );
        $this->db->where_not_in('status','0');
        $this->db->order_by('ordering', 'asc');
        $this->db->limit('3','0');
        return $this->db->get('tb_upcoming_event');
    }
    function get_upcoming_event_3($ordering,$type){
        
        $this->db->where('ordering >',$ordering);
        $this->db->where('event_type',$type);
        $this->db->where('event_date >= CURDATE()' );
        $this->db->where_not_in('status','0');
        $this->db->order_by('ordering', 'asc');
        $this->db->limit('3','0');
        return $this->db->get('tb_upcoming_event');
    }
    function get_upcoming_event_1($ordering,$type){
        
        $this->db->where('ordering =',$ordering);
        $this->db->where('event_type',$type);
//        $this->db->where('event_date >= CURDATE()' );
//        $this->db->where_not_in('status','0');
//        $this->db->order_by('ordering', 'asc');
        return $this->db->get('tb_upcoming_event');
    }

    function get_key_indicators(){

        $this->db->order_by('date_key', 'desc');
        $this->db->limit(1);
        //$this->db->where('date_key','2014-04-07');
        return $this->db->get('key_indicators');
    }

//      function get_news_inter($news_id){
//            $this->db->where('news_id <=',$news_id);
//            $this->db->where('news_type','47');
//			$this->db->order_by('news_id', 'desc');
//            $this->db->limit('5','0');
//			return $this->db->get('tb_news');
//        }

//        function get_announcement($announ_id) {
//            $this->db->select('id, title, catid, introtext, ordering');
//            $this->db->where('id <=',$announ_id);
//            $this->db->where('catid','41');
//            $this->db->order_by('id', 'desc');
//            $this->db->limit('3','0');
//			return $this->db->get('jos_content');
//        }

    function get_link() {
        $this->db->select('id, order, link_kh, link_en, link_url');
        $this->db->where('status','1');
        $this->db->where('order >','0');
        $this->db->order_by('order', 'desc');
        //$this->db->limit('10','0');
        return $this->db->get('relate_link');
    }

    public function get_relate_link($type) {
        $this->db->select('*');
        $this->db->where('status','1');
        $this->db->where('ordering >','0');
        $this->db->where('link_type=',$type);
        $this->db->order_by('ordering', 'desc');
        //$this->db->limit('10','0');
        return $this->db->get('related_link');
    }

    function get_thank_letter() {
        $this->db->select('id, orders, letter_kh, letter_en, link_url');
        $this->db->where('status','1');
        $this->db->where('orders >','0');
        $this->db->order_by('orders', 'desc');
        return $this->db->get('thank_letter');
    }

    function get_utube($obset){
        $this->db->order_by('vol_id','DESC');
        $this->db->limit(20,$obset);
        return $this->db->get('lmi_utube');
    }
    function get_utube_latest(){
        $this->db->order_by('vol_id','DESC');
        $this->db->limit(1);
        return $this->db->get('lmi_utube');
    }

    function get_bulletin($ordering, $type){
        $this->db->select('*');
        $this->db->from("tbl_bulletin");
        $this->db->where('ordering >=',$ordering);
        $this->db->where('type',$type);
        $this->db->order_by("id", "DESC");

        return $this->db->get();

    }
    function get_bulletin_type($ordering, $type, $limit, $offset){
        $this->db->select('*');
        $this->db->where('ordering >=',$ordering);
        $this->db->where('type',$type);
        $this->db->order_by("id", "DESC");
        $this->db->limit($limit,$offset);
        return $this->db->get('tbl_bulletin');

    }
    function get_work_report($ordering, $type){
        $this->db->select('*');
        $this->db->where('ordering >=',$ordering);
        $this->db->where('type',$type);
        $this->db->order_by("id", "DESC");
        $this->db->limit('10','0');
        return $this->db->get('tbl_bulletin');

    }
    function get_bulletin_latest($obset){
        $this->db->limit(1, $obset);
        $this->db->select('*');
        $this->db->from("tbl_bulletin");
        $this->db->order_by('id','desc');

        return $this->db->get();
    }
    function get_opportunity_latest(){
        $this->db->select('*');
        $this->db->from("tbl_opportunity");
        $this->db->order_by('id','desc');

        return $this->db->get();
    }
    // law callection

    function get_law_callection(){
        $this->db->select('*');
        $this->db->from('tbl_law_callection');
        $this->db->join('tbl_ministry','tbl_ministry.id=tbl_law_callection.ministry_id');

        $this->db->order_by('tbl_law_callection.id', 'asc');

        return $this->db->get();

    }
    
    function get_law_all($law_type){
        $this->db->select('*');
        $this->db->from('law_regulation');
        $this->db->join('law_type','law_type.id=law_regulation.type', 'left');
        if($law_type<>"0"){
            $this->db->where('law_regulation.type',$law_type);
        }
        $this->db->order_by('law_type.id', 'asc');
        return $this->db->get();
    }
    
    function law_count_by_type(){
        $this->db->select('law_type.*, count(law_regulation.title_en) as counts');
        $this->db->from('law_type');
        $this->db->join('law_regulation','law_regulation.type = law_type.id','left');

        $this->db->group_by('law_type.id', 'asc');
        return $this->db->get();
    }
    
    function get_job_opportunity(){
        $this->db->select('id, title_en, title_kh,image, url_download');
        $this->db->where('status','1');
        $this->db->order_by('order', 'desc');
        $this->db->limit('1','0');

        return $this->db->get('tbl_job_opportunity');

    }
    public function get_latest_vacancy() {
        $this->db->select('*');
        $this->db->from("tbl_latvacancy");
        $this->db->order_by('id','desc');

        return $this->db->get();
    }
    function get_tvet_type(){
        $this->db->select('*');
        $this->db->order_by("tvet_id", "DESC");
        return $this->db->get('tvet');

    }
    function get_announcement_total(){
        $query_string = "SELECT COUNT(*) AS num_row " .
            "FROM tb_announcement";

        $list_data = $this->db->query($query_string)->row();
        return $list_data->num_row;
    }

    function get_bulletin_total(){
        $query_string = "SELECT COUNT(*) AS num_row " .
            "FROM tbl_bulletin";

        $list_data = $this->db->query($query_string)->row();
        return $list_data->num_row;
    }
  //---------------- guident -----------
    function get_guident_total(){
        $query_string = "SELECT COUNT(*) AS num_row " .
            "FROM tbl_bulletin where type = 21";

        $list_data = $this->db->query($query_string)->row();
        return $list_data->num_row;
    }

    function get_guident($ordering, $type, $limit, $offset){
        $this->db->select('*');
        $this->db->where('ordering >=',$ordering);
        $this->db->where('type',$type);
        $this->db->order_by("id", "DESC");
        $this->db->limit($limit,$offset);
        return $this->db->get('tbl_bulletin');

    }

}
?>