<?php
$this->load->view("template/header");
?>
    <div class="row">
        <div class="col-xs-12">
            <div id="login-box">
                <div id="login-box-holder">
                    <div class="row">
                        <div class="col-xs-12">
                            <header id="login-header">
                                <div id="login-logo">
                                    <i class="fa fa-lock"></i> <?php echo $this->lang->line("logo_in_form");?>
                                </div>
                            </header>
                            <div id="login-box-inner">
                                <form action="<?php echo site_url('account/login')?>" role="form" method="POST">
                                    <div class="form-group has-error">
                                        <?php echo validation_errors(); ?>
                                        <span class="help-block"><i class="icon-remove-sign"></i> <?php echo $this->dx_auth->get_auth_error(); ?></span>
                                    </div>
                                    <div class="input-group">
                                        <span class="input-group-addon"><i class="fa fa-user"></i></span>
                                        <input type="text" name="txtusername" placeholder="<?php echo $this->lang->line("label_username"); ?>" class="form-control">
                                    </div>
                                    <div class="input-group">
                                        <span class="input-group-addon"><i class="fa fa-key"></i></span>
                                        <input type="password" name="txtpassword" placeholder="<?php echo $this->lang->line("label_password"); ?>" class="form-control">
                                    </div>
                                    <div id="remember-me-wrapper">
                                        <div class="row">
                                            <div class="col-xs-6">
                                                <div class="checkbox-nice">
                                                    <input type="checkbox" checked="checked" id="remember-me">
                                                    <label for="remember-me">
                                                        Remember me
                                                    </label>
                                                </div>
                                            </div>
                                            <a class="col-xs-6" id="login-forget-link" href="<?php echo site_url('account/password')?>">
                                                Forgot password?
                                            </a>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-xs-12">
                                            <button class="btn btn-success col-xs-12" type="submit">Login</button>
                                        </div>
                                    </div>
                                </form>
                                
                                <div class="visible-sm-block visible-xs-block">
                                    <br/>
                                    <p class="social-text">Don't have account yet!</p>
                                    <center><a class="btn-xs btn-success" href="<?php echo site_url("register-seeker"); ?>">
                                            <span class="fa fa-edit"></span> <?php echo lang("left_h_job_seeker").lang("button_register_here"); ?></a></center>
                                                  
                                    <center><a class="btn-xs btn-danger" href="<?php echo site_url("register-employer"); ?>">
                                            <span class="fa fa-edit"></span> <?php echo lang("left_h_employer").lang("button_register_here"); ?></a></center>
                                                      
                                    <center><a class="btn-xs btn-warning" href="<?php echo site_url("register-training"); ?>">
                                            <span class="fa fa-edit"></span> <?php echo lang("left_h_training_provider").lang("button_register_here"); ?></a></center>
                                        
                                     
                                  
                                </div>
                            </div>
                            
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php
$this->load->view("template/footer");
?>