
		<script type="text/javascript" src="js/jquery.min.js"></script>
		<script type="text/javascript">
$(function () {
    var chart;
    $(document).ready(function() {
    
        var colors = Highcharts.getOptions().colors,
            categories = ['Job Seekers', 'Employer', 'Training Provider'],
            name = 'LMI Tripartice',
            data = [{
                    y: 30,
                    color: colors[0],
                    drilldown: {
                        name: 'Job Seekers',
                        categories: ['L_Skill', 'Under G12', 'Under BA', 'BA Uper'],
                        data: [30, 20, 40, 10],
                        color: colors[0]
                    }
                }, {
                    y: 60,
                    color: colors[1],
                    drilldown: {
                        name: 'Employers',
                        categories: ['Primary', 'Secondary', 'Thirtiary'],
                        data: [65, 20, 25],
                        color: colors[1]
                    }
                }, {
                    y: 10,
                    color: colors[2],
                    drilldown: {
                        name: 'Training Provider',
                        categories: ['Short Course', 'Long Course', 'Heigh Eduacation', 'SL'],
                        data: [45, 30, 20, 5],
                        color: colors[2]
                    }
                }];
    
        function setChart(name, categories, data, color) {
			chart.xAxis[0].setCategories(categories, false);
			chart.series[0].remove(false);
			chart.addSeries({
				name: name,
				data: data,
				color: color || 'white'
			}, false);
			chart.redraw();
        }
    
        chart = new Highcharts.Chart({
            chart: {
                renderTo: 'container',
                type: 'column'
            },
            title: {
                text: 'Browser market share, April, 2011'
            },
            subtitle: {
                text: 'Click the columns to view versions. Click again to view brands.'
            },
            xAxis: {
                categories: categories
            },
            yAxis: {
                title: {
                    text: 'Total percent'
                }
            },
            plotOptions: {
                column: {
                    cursor: 'pointer',
                    point: {
                        events: {
                            click: function() {
                                var drilldown = this.drilldown;
                                if (drilldown) { // drill down
                                    setChart(drilldown.name, drilldown.categories, drilldown.data, drilldown.color);
                                } else { // restore
                                    setChart(name, categories, data);
                                }
                            }
                        }
                    },
                    dataLabels: {
                        enabled: true,
                        color: colors[0],
                        style: {
                            fontWeight: 'bold'
                        },
                        formatter: function() {
                            return this.y +'%';
                        }
                    }
                }
            },
            tooltip: {
                formatter: function() {
                    var point = this.point,
                        s = this.x +':<b>'+ this.y +'% market share</b><br/>';
                    if (point.drilldown) {
                        s += 'Click to view '+ point.category +' versions';
                    } else {
                        s += 'Click to return to browser brands';
                    }
                    return s;
                }
            },
            series: [{
                name: name,
                data: data,
                color: 'white'
            }],
            exporting: {
                enabled: false
            }
        });
    });
    
});
		</script>

<script src="js/highcharts.js"></script>
<script src="js/modules/exporting.js"></script>

<div id="container" style="min-width: 400px; height: 400px; margin: 0 auto"></div>

