<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class jsonios extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();

        /*
         * load model
         */
        $this->load->model('model_jobapi_v1');
    }

    function index()
    {
        $response = array();

        // no products found
        $response["success"] = 0;
        $response["message"] = "No jobs found";

        // echo no users JSON
        echo json_encode($response);

    }
    function get_all_latest_details_10_jobs()
    {
        $response = array();
        $result = $this->model_jobapi_v1->get_job_by_detail_api();
        $result_number_rows = $result->num_rows();
        if ($result_number_rows > 0) {
            $response["products"] = array();
            foreach ($result->result() as $row) {
                // temp user array
                $product = array();
                $product["pid"] = $row->job_id;
                $product["name"] = $row->job_name;
                // Employer profile
                $product["employer"] = 'Employer Name:'.$row->employer;
                $product["employer_address"]='Address:'.strip_tags($row->employer_address);
                $product["employer_profile_detail"]='Profile Detail:'.strip_tags($row->employer_profile_details);
                //----------------------------
                $product["close_date"] = $row->close_date;
                $product["location"] = $row->location;
                $product["vacancy_num"] = $row->vacancy_num;
                $product["salary"] = $row->salary." USD";
                $product["job_term_name"] = $row->job_term_name;
                $product["job_start_working"] = $row->job_start_working;
                $product["description"] = $row->description;
                $product["other_requirement"] = $row->other_requirement;
                $product["job_language"] = $row->job_language;
                $product["job_language_level"] = $row->job_language_level;
                $product["job_education"] = $row->job_education;
                $product["job_major"] = $row->job_major;
                $product["how_to_apply"] = $row->how_to_apply;

                // Job Center Blog
                $product["jc_office_name"] = $row->jc_office_name;
                $product["jc_contacts"] = $row->jc_contacts;
                $product["jc_email"] = $row->jc_email;
                $response["product"] = array();
                array_push($response["product"], $product);

                // echoing JSON response
                echo json_encode($response);

            }
            // success
            $response["success"] = 1;
            $response["num_rows"] = $result_number_rows;

            // echoing JSON response
            echo json_encode($response);
        } else {
            // no products found
            $response["success"] = 0;
            $response["message"] = "No products found";

            // echo no users JSON
            echo json_encode($response);
        }
    }
	



    function get_all_latest_10_jobs()
    {
        $response = array();
        $result = $this->model_jobapi_v1->get_all_latest_jobs_api();
        $result_number_rows = $result->num_rows();
        if ($result_number_rows > 0) {
            // looping through all results
            // products node
            $response["products"] = array();

            foreach ($result->result() as $row) {
                // temp user array
                $product = array();
                $product["pid"] = $row->job_id;
                $product["name"] = $row->job_name;
                $product["close_date"] = $row->close_date;
                $product["employer"] = $row->employer;
                $product["location"] = $row->location;
                $product["salary"] = $row->salary;
                $product["job_term_name"] = $row->job_term_name;
                $product["vacancy_num"] = $row->vacancy_num;
                $product["image"] = "http://www.nea.gov.kh/nweb/images/ic_wallpaper_black.png";
                $duration=$row->duration_day;
				
				 if ($duration< 0) {
                                    $duration = "New";
                                } else if ($duration == 0) {
                                    $duration = "Today";
                                } else if ($duration == 1) {
                                    $duration = "Yesterday";
                                } else if ($duration > 30) {
                                    $duration = 30 . " Days+ " ;
                                } else {
                                    $duration = $duration ." Days";
                                }
				$product["duration_day"] = $duration;
                // push single product into final response array
                array_push($response["products"], $product);

            }
            // success
            $response["success"] = 1;
            $response["num_rows"] = $result_number_rows;

            // echoing JSON response
            echo json_encode($response);
        } else {
            // no products found
            $response["success"] = 0;
            $response["message"] = "No products found";

            // echo no users JSON
            echo json_encode($response);
        }
    }
	
	function get_all_latest_10_jobs_kh()
    {
        $response = array();
        $result = $this->model_jobapi_v1->get_all_latest_jobs_api();
        $result_number_rows = $result->num_rows();
        if ($result_number_rows > 0) {
            // looping through all results
            // products node
            $response["products"] = array();

            foreach ($result->result() as $row) {
                // temp user array
                $product = array();
                $product["pid"] = $row->job_id;
                $product["name"] = $row->job_name_kh;
                $product["close_date"] = $row->close_date;
                $product["employer"] = $row->employer;
                $product["location"] = $row->location_khmer;
                $product["salary"] = $row->salary;
                $product["job_term_name"] = $row->job_term_name_khmer;
                $product["vacancy_num"] = $row->vacancy_num;
                $duration=$row->duration_day;
				
				 if ($duration< 0) {
                                    $duration = "<font color='#FF3C1F'>ថ្មី</font>";
                                } else if ($duration == 0) {
                                    $duration = "<font color='#ddaa3b'>ថ្ងៃនេះ</font>";
                                } else if ($duration == 1) {
                                    $duration = "កាលពីម្សិល";
                                } else if ($duration > 30) {
                                    $duration = 30 . " ថ្ងៃ + " ;
                                } else {
                                    $duration = $duration ." ថ្ងៃ";
                                }
				$product["duration_day"] = $duration;
                // push single product into final response array
                array_push($response["products"], $product);

            }
            // success
            $response["success"] = 1;
            $response["num_rows"] = $result_number_rows;

            // echoing JSON response
            echo json_encode($response);
        } else {
            // no products found
            $response["success"] = 0;
            $response["message"] = "No products found";

            // echo no users JSON
            echo json_encode($response);
        }
    }


    function get_all_jobs()
    {
        $response = array();
        $result = $this->model_jobapi_v1->get_all_jobs_api();
        $result_number_rows = $result->num_rows();
        if ($result_number_rows > 0) {
            // looping through all results
            // products node
            $response["products"] = array();

            foreach ($result->result() as $row) {
                // temp user array
                $product = array();
                $product["pid"] = $row->job_id;
                $product["name"] = $row->job_name;
                $product["close_date"] = $row->close_date;
                $product["employer"] = $row->employer;
                $product["location"] = $row->location;
                $product["salary"] = $row->salary;
                $product["job_term_name"] = $row->job_term_name;
                $product["vacancy_num"] = $row->vacancy_num;
   
				$duration=$row->duration_day;
				
				 if ($duration< 0) {
                                    $duration = "<font color='#FF3C1F'>New</font>";
                                } else if ($duration == 0) {
                                    $duration = "<font color='#ddaa3b'>Today</font>";
                                } else if ($duration == 1) {
                                    $duration = "Yesterday";
                                } else if ($duration > 30) {
                                    $duration = 30 . " Days+ " ;
                                } else {
                                    $duration = $duration ." Days";
                                }
								
				$product["duration_day"] = $duration;
                // push single product into final response array
                array_push($response["products"], $product);

            }
            // success
            $response["success"] = 1;
            $response["num_rows"] = $result_number_rows;

            // echoing JSON response
            echo json_encode($response);
        } else {
            // no products found
            $response["success"] = 0;
            $response["message"] = "No products found";

            // echo no users JSON
            echo json_encode($response);
        }
    }
	
	function get_all_jobs_kh()
    {
        $response = array();
        $result = $this->model_jobapi_v1->get_all_jobs_api_kh();
        $result_number_rows = $result->num_rows();
        if ($result_number_rows > 0) {
            // looping through all results
            // products node
            $response["products"] = array();

            foreach ($result->result() as $row) {
                // temp user array
                $product = array();
                $product["pid"] = $row->job_id;
                $product["name"] = $row->job_name;
                $product["close_date"] = $row->close_date;
                $product["employer"] = $row->employer;
                $product["location"] = $row->location;
                $product["salary"] = $row->salary;
                $product["job_term_name"] = $row->job_term_name;
                $product["vacancy_num"] = $row->vacancy_num;
   
				$duration=$row->duration_day;
				
				 if ($duration< 0) {
                                    $duration = "<font color='#FF3C1F'>ថ្មី</font>";
                                } else if ($duration == 0) {
                                    $duration = "<font color='#ddaa3b'>ថ្ងៃនេះ</font>";
                                } else if ($duration == 1) {
                                    $duration = "កាលពីម្សិល";
                                } else if ($duration > 30) {
                                    $duration = 30 . " ថ្ងៃ + " ;
                                } else {
                                    $duration = $duration ." ថ្ងៃ";
                                }
								
				$product["duration_day"] = $duration;
                // push single product into final response array
                array_push($response["products"], $product);

            }
            // success
            $response["success"] = 1;
            $response["num_rows"] = $result_number_rows;

            // echoing JSON response
            echo json_encode($response);
        } else {
            // no products found
            $response["success"] = 0;
            $response["message"] = "No products found";

            // echo no users JSON
            echo json_encode($response);
        }
    }


    function get_job_detail()
    {
        // check for post data
        $response = array();
        if (isset($_GET["pid"])) {
            $job_id = $_GET['pid'];
            // For insert log requests

            $ip_add=$_SERVER['REMOTE_ADDR'] ;
               // -> "Mountain View"
            $data_insert = array(
                'job_id'=>$job_id,
                'ip_address_remote'=>$ip_add,

            );
         //   $this->model_jobapi_v1->insert_log_request($data_insert);
        //----------------------------------------------------------------
            $result = $this->model_jobapi_v1->get_job_by_id_api($job_id);

            if (!empty($result)) {
                // check for empty result
                if ($result->num_rows() > 0) {

                    $result = $result->row();
                    $product = array();
                    $product["pid"] = $result->job_id;
                    $product["name"] = $result->job_name;
                    // Employer profile
                    $product["employer"] =$result->employer;
                    $product["employer_address"]=strip_tags($this->strip_tags_content($result->employer_address, '<br>',TRUE));
                    $product["employer_profile_detail"]=strip_tags($this->strip_tags_content($result->employer_profile_details, '<br>', TRUE));
                    //----------------------------
                    $product["close_date"] = $result->close_date;
                    $product["location"] = $result->location;
                    $product["vacancy_num"] = $result->vacancy_num;
                    $product["salary"] = $result->salary." USD";
                    $product["job_term_name"] = $result->job_term_name;
                    $product["job_start_working"] = $result->job_start_working;
					
					// Convert HTML to Texts
                    $product["description"] =  strip_tags($this->strip_tags_content($result->description, '<br>', TRUE));
                    $product["other_requirement"] = strip_tags($this->strip_tags_content($result->other_requirement, '<br>', TRUE));
                    $product["job_language"] = $result->job_language;
                    $product["job_language_level"] = $result->job_language_level;
                    $product["job_education"] = $result->job_education;
                    $product["job_major"] = $result->job_major;
                    $product["how_to_apply"] = $result->how_to_apply;

                    // Job Center Blog
                    $product["jc_office_name"] = $result->jc_office_name;
                    $product["jc_contacts"] = $result->jc_contacts;
                    $product["jc_email"] = $result->jc_email;
                    $product["jc_address"] = $result->jc_address;


                    // success
                    $response["success"] = 1;

                    // user node
                    $response["product"] = array();

                    array_push($response["product"], $product);

                    // echoing JSON response
                    echo json_encode($response);
                } else {
                    // no product found
                    $response["success"] = 0;
                    $response["message"] = "No product found";

                    // echo no users JSON
                    echo json_encode($response);
                }
            } else {
                // no product found
                $response["success"] = 0;
                $response["message"] = "No product found";

                // echo no users JSON
                echo json_encode($response);
            }
        } else {
            // required field is missing
            $response["success"] = 0;
            $response["message"] = "Required field(s) is missing";

            // echoing JSON response
            echo json_encode($response);
        }
    }
 function get_job_detail_kh()
    {
        // check for post data
        $response = array();
        if (isset($_GET["pid"])) {
            $job_id = $_GET['pid'];
            // For insert log requests

            $ip_add=$_SERVER['REMOTE_ADDR'] ;
               // -> "Mountain View"
            $data_insert = array(
                'job_id'=>$job_id,
                'ip_address_remote'=>$ip_add,

            );
         //   $this->model_jobapi_v1->insert_log_request($data_insert);
        //----------------------------------------------------------------
            $result = $this->model_jobapi_v1->get_job_by_id_api_kh($job_id);

            if (!empty($result)) {
                // check for empty result
                if ($result->num_rows() > 0) {

                    $result = $result->row();
                    $product = array();
                    $product["pid"] = $result->job_id;
                    $product["name"] = $result->job_name;
                    // Employer profile
                    $product["employer"] =$result->employer;
                    $product["employer_address"]='Address:'.strip_tags($result->employer_address);
                    $product["employer_profile_detail"]='Profile Detail:'.strip_tags($result->employer_profile_details);
                    //----------------------------
                    $product["close_date"] = $result->close_date;
                    $product["location"] = $result->location;
                    $product["vacancy_num"] = $result->vacancy_num;
                    $product["salary"] = $result->salary."   ដុល្លា";
                    $product["job_term_name"] = $result->job_term_name;
                    $product["job_start_working"] = $result->job_start_working;
                    $product["description"] = $result->description;
                    $product["other_requirement"] = $result->other_requirement;
                    $product["job_language"] = $result->job_language;
                    $product["job_language_level"] = $result->job_language_level;
                    $product["job_education"] = $result->job_education;
                    $product["job_major"] = $result->job_major;
                    $product["how_to_apply"] = $result->how_to_apply;

                    // Job Center Blog
                    $product["jc_office_name"] = $result->jc_office_name;
                    $product["jc_contacts"] = $result->jc_contacts;
                    $product["jc_email"] = $result->jc_email;
                    $product["jc_address"] = $result->jc_address;


                    // success
                    $response["success"] = 1;

                    // user node
                    $response["product"] = array();

                    array_push($response["product"], $product);

                    // echoing JSON response
                    echo json_encode($response);
                } else {
                    // no product found
                    $response["success"] = 0;
                    $response["message"] = "No product found";

                    // echo no users JSON
                    echo json_encode($response);
                }
            } else {
                // no product found
                $response["success"] = 0;
                $response["message"] = "No product found";

                // echo no users JSON
                echo json_encode($response);
            }
        } else {
            // required field is missing
            $response["success"] = 0;
            $response["message"] = "Required field(s) is missing";

            // echoing JSON response
            echo json_encode($response);
        }
    }

 function get_employer_detail()
    {
        // check for post data
        $response = array();
        if (isset($_GET["pid"])) {
            $job_id = $_GET['pid'];
            $result = $this->model_jobapi_v1->get_employer_detail($job_id);
            if (!empty($result)) {
                // check for empty result
                if ($result->num_rows() > 0) {

                    $result = $result->row();
                    $orgs = array();
                    $orgs["org_id"]			 = $result->org_id;
					$orgs["org_name"]		 =$result->org_name;
					$orgs["org_industry"]	 =$result->industry_en;
					$orgs["org_type"]		 =$result->org_type_en;
					$orgs["org_reg_num"]	 =$result->org_reg_num;
				    $orgs["org_patent_num"]  =$result->org_patent_num;
				    $orgs["org_num_employ"]  =$result->org_num_employ;
				
					$orgs["org_main_occup"]	 =$result->org_main_occup;
					$orgs["org_address"]	 =$result->org_address;
					$orgs["org_background"]	 =$result->org_background;
					$orgs["org_cont_person"] =$result->org_cont_person;
					$orgs["org_office_phone"]=$result->org_office_phone;
					$orgs["org_fax"]		 =$result->org_fax;
					$orgs["org_mobile"]		 =$result->org_mobile;
					$orgs["org_email"]		 =$result->org_email;
					$orgs["org_website"]	 =$result->org_website;					
                    // success
                    $response["success"] = 1;

                    // user node
                    $response["orgs"] = array();

                    array_push($response["orgs"], $orgs);

                    // echoing JSON response
                    echo json_encode($response);
                } else {
                    // no orgs found
                    $response["success"] = 0;
                    $response["message"] = "No orgs found";

                    // echo no users JSON
                    echo json_encode($response);
                }
            } else {
                // no orgs found
                $response["success"] = 0;
                $response["message"] = "No orgs found";

                // echo no users JSON
                echo json_encode($response);
            }
        } else {
            // required field is missing
            $response["success"] = 0;
            $response["message"] = "Required field(s) is missing";

            // echoing JSON response
            echo json_encode($response);
        }
    }
	
	function get_employer_detail_kh()
    {
        // check for post data
        $response = array();
        if (isset($_GET["pid"])) {
            $job_id = $_GET['pid'];
            $result = $this->model_jobapi_v1->get_employer_detail_kh($job_id);
            if (!empty($result)) {
                // check for empty result
                if ($result->num_rows() > 0) {

                    $result = $result->row();
                    $orgs = array();
                    $orgs["org_id"]			 = $result->org_id;
					$orgs["org_name"]		 =$result->org_name;
					$orgs["org_industry"]	 =$result->industry_khmer;
					$orgs["org_type"]		 =$result->org_type_khmer;
					$orgs["org_reg_num"]	 =$result->org_reg_num;
				    $orgs["org_patent_num"]  =$result->org_patent_num;
				    $orgs["org_num_employ"]  =$result->org_num_employ;
				
					$orgs["org_main_occup"]	 =$result->org_main_occup;
					$orgs["org_address"]	 =$result->org_address;
					$orgs["org_background"]	 =$result->org_background;
					$orgs["org_cont_person"] =$result->org_cont_person;
					$orgs["org_office_phone"]=$result->org_office_phone;
					$orgs["org_fax"]		 =$result->org_fax;
					$orgs["org_mobile"]		 =$result->org_mobile;
					$orgs["org_email"]		 =$result->org_email;
					$orgs["org_website"]	 =$result->org_website;					
                    // success
                    $response["success"] = 1;

                    // user node
                    $response["orgs"] = array();

                    array_push($response["orgs"], $orgs);

                    // echoing JSON response
                    echo json_encode($response);
                } else {
                    // no orgs found
                    $response["success"] = 0;
                    $response["message"] = "No orgs found";

                    // echo no users JSON
                    echo json_encode($response);
                }
            } else {
                // no orgs found
                $response["success"] = 0;
                $response["message"] = "No orgs found";

                // echo no users JSON
                echo json_encode($response);
            }
        } else {
            // required field is missing
            $response["success"] = 0;
            $response["message"] = "Required field(s) is missing";

            // echoing JSON response
            echo json_encode($response);
        }
    }

    function search_job()
    {
        // array for JSON response
        $response = array();

        if (isset($_GET["jobtitle"])) {

            $jobtitle = $this->input->get('jobtitle');
            if ($jobtitle == 0) {
                $jobtitle = '';
            }

            $jobindustry = $this->input->get('jobindustry');
            $joblocationid = $this->input->get('joblocation');
            if ($joblocationid == 0) {
                $joblocationid = '';
            }

            $result = $this->model_jobapi_v1->get_job_by_jobtitle_industry_location_api($jobtitle, $jobindustry, $joblocationid);
            $result_number_rows = $result->num_rows();

            if ($result_number_rows > 0) {

                $response["products"] = array();

                foreach ($result->result() as $row) {

                    $product = array();
                    $product["pid"] = $row->job_id;
                    $product["name"] = $row->job_name;
                    $product["close_date"] = $row->close_date;
                    $product["employer"] = $row->employer;
                    $product["location"] = $row->location;
                    $product["vacancy_num"] = $row->vacancy_num;
                    $product["salary"] = $row->salary;
                    $product["job_term_name"] = $row->job_term_name;
                   $duration=$row->duration_day;
				
				 if ($duration< 0) {
                                    $duration = "<font color='#FF3C1F'>New</font>";
                                } else if ($duration == 0) {
                                    $duration = "<font color='#ddaa3b'>Today</font>";
                                } else if ($duration == 1) {
                                    $duration = "Yesterday";
                                } else if ($duration > 30) {
                                    $duration = 30 . " Days+" ;
                                } else {
                                    $duration = $duration ." Days";
                                }
								
				$product["duration_day"] = $duration;

                    // push single product into final response array
                    array_push($response["products"], $product);
                }
                // success
                $response["success"] = 1;
                $response["num_rows"] = $result_number_rows;

                // echoing JSON response
                echo json_encode($response);
            } else {
                // no products found
                $response["success"] = 0;
                $response["message"] = "No job found";

                // echo no users JSON
                echo json_encode($response);
            }
        } else {
            // no products found
            $response["success"] = 0;
            $response["message"] = "Required field(s) is missing";

            // echo no users JSON
            echo json_encode($response);
        }
    }
	
	function search_job_kh()
    {
        // array for JSON response
        $response = array();

        if (isset($_GET["jobtitle"])) {

            $jobtitle = $this->input->get('jobtitle');
            if ($jobtitle == 0) {
                $jobtitle = '';
            }

            $jobindustry = $this->input->get('jobindustry');
            $joblocationid = $this->input->get('joblocation');
            if ($joblocationid == 0) {
                $joblocationid = '';
            }

            $result = $this->model_jobapi_v1->get_job_by_jobtitle_industry_location_api_kh($jobtitle, $jobindustry, $joblocationid);
            $result_number_rows = $result->num_rows();

            if ($result_number_rows > 0) {

                $response["products"] = array();

                foreach ($result->result() as $row) {

                    $product = array();
                    $product["pid"] = $row->job_id;
                    $product["name"] = $row->job_name;
                    $product["close_date"] = $row->close_date;
                    $product["employer"] = $row->employer;
                    $product["location"] = $row->location;
                    $product["vacancy_num"] = $row->vacancy_num;
                    $product["salary"] = $row->salary;
                    $product["job_term_name"] = $row->job_term_name;
                   $duration=$row->duration_day;
				
				if ($duration< 0) {
                                    $duration = "<font color='#FF3C1F'>ថ្មី</font>";
                                } else if ($duration == 0) {
                                    $duration = "<font color='#ddaa3b'>ថ្ងៃនេះ</font>";
                                } else if ($duration == 1) {
                                    $duration = "កាលពីម្សិល";
                                } else if ($duration > 30) {
                                    $duration = 30 . " ថ្ងៃ + " ;
                                } else {
                                    $duration = $duration ." ថ្ងៃ";
                                }
								
				$product["duration_day"] = $duration;

                    // push single product into final response array
                    array_push($response["products"], $product);
                }
                // success
                $response["success"] = 1;
                $response["num_rows"] = $result_number_rows;

                // echoing JSON response
                echo json_encode($response);
            } else {
                // no products found
                $response["success"] = 0;
                $response["message"] = "No job found";

                // echo no users JSON
                echo json_encode($response);
            }
        } else {
            // no products found
            $response["success"] = 0;
            $response["message"] = "Required field(s) is missing";

            // echo no users JSON
            echo json_encode($response);
        }
    }

    function live_vacancy()
    {
        $response = array();
        $result = $this->model_jobapi_v1->live_vacancies();
        $result_number_rows = $result->num_rows();

        if (!empty($result)) {
            // check for empty result
            if ($result_number_rows > 0) {

                $result = $result->row();
                $vacancy = array();
                $vacancy["total_vacancy"] ="Live vacancies: " . $result->total_vacancy;

                // success
                $response["success"] = 1;

                // user node
                $response["vacancies"] = array();
                array_push($response["vacancies"], $vacancy);

                // echoing JSON response
                echo json_encode($response);
            } else {
                // no vacancy found
                $response["success"] = 0;
                $response["message"] = "No vacancy found";

                // echo no users JSON
                echo json_encode($response);
            }
        } else {
            // no vacancy found
            $response["success"] = 0;
            $response["message"] = "No vacancy found";

            // echo no users JSON
            echo json_encode($response);
        }

    }
	
	 function live_vacancy_kh()
    {
        $response = array();
        $result = $this->model_jobapi_v1->live_vacancies();
        $result_number_rows = $result->num_rows();

        if (!empty($result)) {
            // check for empty result
            if ($result_number_rows > 0) {

                $result = $result->row();
                $vacancy = array();
                $vacancy["total_vacancy"] = "តម្រូវការកម្លាំងពលកម្ម: " . $result->total_vacancy;

                // success
                $response["success"] = 1;

                // user node
                $response["vacancies"] = array();
                array_push($response["vacancies"], $vacancy);

                // echoing JSON response
                echo json_encode($response);
            } else {
                // no vacancy found
                $response["success"] = 0;
                $response["message"] = "No vacancy found";

                // echo no users JSON
                echo json_encode($response);
            }
        } else {
            // no vacancy found
            $response["success"] = 0;
            $response["message"] = "No vacancy found";

            // echo no users JSON
            echo json_encode($response);
        }

    }

    function get_contact_us()
    {
        // array for JSON response
        $response = array();
        $result = $this->model_jobapi_v1->get_contact_us_api();
        $result_number_rows = $result->num_rows();
        if ($result_number_rows > 0) {
            // looping through all results
            // contacts node
            $response["contacts"] = array();
            foreach ($result->result() as $row) {
                // temp user array
                $contact = array();
                $contact["id"] = $row->id;
                $contact["office_name"] = $row->office_name_english;
                $contact["address"] = $row->address;
                $contact["contacts"] = $row->contacts;
                $contact["contact_no1"] = $row->contact_no1;
                $contact["contact_no2"] = $row->contact_no2;
                $contact["contact_no3"] = $row->contact_no3;
                $contact["contact_no4"] = $row->contact_no4;
                $contact["email"] = $row->email;
                $contact["facebook"] = $row->facebook;
                $contact["website"] = $row->website;
                $contact["image"]=$row->image;
                $contact["description"] = $row->description;
                // push single job into final response array
                array_push($response["contacts"], $contact);
            }

            $response["success"] = 1;
            $response["row_number"] = $result_number_rows;
            $response["total_jc"] = $result_number_rows - 1;

            echo json_encode($response);
        } else {
            // no contacts found
            $response["success"] = 0;
            $response["message"] = "No contacts found";

            // echo no users JSON
            echo json_encode($response);
        }
    }
	 function get_contact_us_kh()
    {
        // array for JSON response
        $response = array();
        $result = $this->model_jobapi_v1->get_contact_us_api();
        $result_number_rows = $result->num_rows();
        if ($result_number_rows > 0) {
            // looping through all results
            // contacts node
            $response["contacts"] = array();
            foreach ($result->result() as $row) {
                // temp user array
                $contact = array();
                $contact["id"] = $row->id;
                $contact["office_name"] = $row->office_name_khmer;
                $contact["address"] = $row->address_khmer;
                $contact["contacts"] = $row->contacts;
                $contact["contact_no1"] = $row->contact_no1;
                $contact["contact_no2"] = $row->contact_no2;
                $contact["contact_no3"] = $row->contact_no3;
                $contact["contact_no4"] = $row->contact_no4;
                $contact["email"] = $row->email;
                $contact["facebook"] = $row->facebook;
                $contact["website"] = $row->website;
                $contact["image"]=$row->image;
                $contact["description"] = $row->description;
                // push single job into final response array
                array_push($response["contacts"], $contact);
            }

            $response["success"] = 1;
            $response["row_number"] = $result_number_rows;
            $response["total_jc"] = $result_number_rows - 1;

            echo json_encode($response);
        } else {
            // no contacts found
            $response["success"] = 0;
            $response["message"] = "No contacts found";

            // echo no users JSON
            echo json_encode($response);
        }
    }
	function cleanHTML($html) {
 
	$html = str_replace('</h1>', "\\r\==================</h1>", $html);
	$html = str_replace('</h2>', "\\r\------------------</h2>", $html);

	return strip_tags($html);
} 
	function strip_tags_content($text, $tags = '', $invert = FALSE) {

		  preg_match_all('/<(.+?)[\s]*\/?[\s]*>/si', trim($tags), $tags);
		  $tags = array_unique($tags[1]);
		   
		  if(is_array($tags) AND count($tags) > 0) {
			if($invert == FALSE) {
			  return preg_replace('@<(?!(?:'. implode('|', $tags) .')\b)(\w+)\b.*?>.*?</\1>@si', '', $text);
			}
			else {
			  return preg_replace('@<('. implode('|', $tags) .')\b.*?>.*?</\1>@si', '', $text);
			}
		  }
		  elseif($invert == FALSE) {
			return preg_replace('@<(\w+)\b.*?>.*?</\1>@si', '', $text);
		  }
		  return $text;
		} 

		// strip javascript, styles, html tags, normalize entities and spaces
// based on http://www.php.net/manual/en/function.strip-tags.php#68757
function html2text($html){
	$text = $html;
	static $search = array(
		'@<script.+?</script>@usi',  // Strip out javascript content
		'@<style.+?</style>@usi',    // Strip style content
		'@<!--.+?-->@us',            // Strip multi-line comments including CDATA
		'@</?[a-z].*?\>@usi',         // Strip out HTML tags
	);
	$text = preg_replace($search, ' ', $text);
	// normalize common entities
	$text = $this->normalizeEntities($text);
	// decode other entities
	$text = html_entity_decode($text, ENT_QUOTES, 'utf-8');
	// normalize possibly repeated newlines, tabs, spaces to spaces
	$text = preg_replace('/\s+/u', ' ', $text);
	$text = trim($text);
	// we must still run htmlentities on anything that comes out!
	// for instance:
	// <<a>script>alert('XSS')//<<a>/script>
	// will become
	// <script>alert('XSS')//</script>
	return $text;
} 

// replace encoded and double encoded entities to equivalent unicode character
// also see /app/bookmarkletPopup.js
function normalizeEntities($text) {
	static $find = array();
	static $repl = array();
	if (!count($find)) {
		// build $find and $replace from map one time
		$map = array(
			array('\'', 'apos', 39, 'x27'), // Apostrophe
			array('\'', '‘', 'lsquo', 8216, 'x2018'), // Open single quote
			array('\'', '’', 'rsquo', 8217, 'x2019'), // Close single quote
			array('"', '“', 'ldquo', 8220, 'x201C'), // Open double quotes
			array('"', '”', 'rdquo', 8221, 'x201D'), // Close double quotes
			array('\'', '‚', 'sbquo', 8218, 'x201A'), // Single low-9 quote
			array('"', '„', 'bdquo', 8222, 'x201E'), // Double low-9 quote
			array('\'', '′', 'prime', 8242, 'x2032'), // Prime/minutes/feet
			array('"', '″', 'Prime', 8243, 'x2033'), // Double prime/seconds/inches
			array(' ', 'nbsp', 160, 'xA0'), // Non-breaking space
			array('-', '‐', 8208, 'x2010'), // Hyphen
			array('-', '–', 'ndash', 8211, 150, 'x2013'), // En dash
			array('--', '—', 'mdash', 8212, 151, 'x2014'), // Em dash
			array(' ', ' ', 'ensp', 8194, 'x2002'), // En space
			array(' ', ' ', 'emsp', 8195, 'x2003'), // Em space
			array(' ', ' ', 'thinsp', 8201, 'x2009'), // Thin space
			array('*', '•', 'bull', 8226, 'x2022'), // Bullet
			array('*', '‣', 8227, 'x2023'), // Triangular bullet
			array('...', '…', 'hellip', 8230, 'x2026'), // Horizontal ellipsis
			array('°', 'deg', 176, 'xB0'), // Degree
			array('€', 'euro', 8364, 'x20AC'), // Euro
			array('¥', 'yen', 165, 'xA5'), // Yen
			array('£', 'pound', 163, 'xA3'), // British Pound
			array('©', 'copy', 169, 'xA9'), // Copyright Sign
			array('®', 'reg', 174, 'xAE'), // Registered Sign
			array('™', 'trade', 8482, 'x2122') // TM Sign
		);
		foreach ($map as $e) {
			for ($i = 1; $i < count($e); ++$i) {
				$code = $e[$i];
				if (is_int($code)) {
					// numeric entity
					$regex = "/&(amp;)?#0*$code;/";
				}
				elseif (preg_match('/^.$/u', $code)/* one unicode char*/) {
					// single character
					$regex = "/$code/u";
				}
				elseif (preg_match('/^x([0-9A-F]{2}){1,2}$/i', $code)) {
					// hex entity
					$regex = "/&(amp;)?#x0*" . substr($code, 1) . ";/i";
				}
				else {
					// named entity
					$regex = "/&(amp;)?$code;/";
				}
				$find[] = $regex;
				$repl[] = $e[0];
			}
		}
	} // end first time build
	return preg_replace($find, $repl, $text);	
}

}

