<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class register extends CI_Controller {

    var $min_username = 4;
    var $max_username = 20;
    var $min_password = 4;
    var $max_password = 20;

    public function __construct() {

        parent::__construct();
        $this->load->library('form_validation');

        $this->load->model("model_resume");
        $this->load->model('mod_vcount');
    }

    
		function _show_option() {
            
            /* Get Language */
            $data['lang_status']=$this->lang->lang();
            
            $data['likes_count']  = $this->mod_vcount->getFacebookDetails()[0]['like_count'];
            $data['youtube_views_count']  = $this->mod_vcount->youtube_view_count_channel()['viewCount'];
            return $data;
                    
        }

/*
     * Verify username in database
     */

    public function identification_check($identification) {

        $total = $this->model_resume->check_identification($identification);

        if ($total == 0) {
            return TRUE;
        } else {
            $this->form_validation->set_message('identification_check', $this->lang->line('label_check_iden'));
            return FALSE;
        }
    }
    public function username_check($username)
    {
        $result = $this->dx_auth->is_username_available(strtolower($username));
        if ( ! $result) {
            $this->form_validation->set_message('username_check', $this->lang->line("label_username_check"));
        }
        return $result;
    }

    /*
     * Verify email address in database
     */

    public function email_check($email) {
        $result = $this->dx_auth->is_email_available(strtolower($email));
        if ( ! $result)
        {
            $this->form_validation->set_message('email_check', $this->lang->line("label_email_check"));
        }

        return $result;
    }

    /*
     * Verify Dropbox
     */

    public function dropdown_check($str) {
        if ($str == 0) {
            $this->form_validation->set_message('dropdown_check', $this->lang->line('dropdown_choose').' %s.');
            return FALSE;
        } else {
            return TRUE;
        }
    }

    /*
     * Function Register Seeker
     * Route URI register-job-seeker
     */
    public function seeker() {
		$data = $this->_show_option();
        //$data['lang_status']=$this->lang->lang();

        $this->form_validation->set_error_delimiters('<div class="text-danger small">', '</div>');

        /*
            Page title and social share
        */

        $data['page_title'] = $this->lang->line("register_seeker_title");

        $data['share_title'] = $this->lang->line("register_seeker_title");
        $data['share_url'] = site_url("register-job-seeker");
        $data['share_image'] = $this->lang->line("register_seeker_image");

        /* Script Block */
        $data["script_add"] = array("select2","numeric","pwstrength");
        $data["script_extra"] = "register";

        $val = $this->form_validation;

        $val->set_rules('txtusername', $this->lang->line('label_username'), 'trim|required|xss_clean|min_length['.$this->min_username.']|max_length['.$this->max_username.']|callback_username_check|alpha_dash');
        $val->set_rules('txtpassword', $this->lang->line('label_password'), 'trim|required|xss_clean|min_length['.$this->min_password.']|max_length['.$this->max_password.']|matches[txtconfirmpass]');
        $val->set_rules('txtconfirmpass', $this->lang->line('label_confirm'), 'trim|required|xss_clean');
        $val->set_rules('txtfullname', $this->lang->line('label_fullname'), 'trim|required|max_length[255]|xss_clean');
        $val->set_rules('cbo_address', $this->lang->line('tr_address'), 'trim|callback_dropdown_check');
        $val->set_rules('txtpriconnum', $this->lang->line('label_primary_contact_number'), 'trim|required|max_length[10]|numeric');
        $val->set_rules('txtsecconnum', $this->lang->line('label_Second_contact_number'), 'trim|max_length[10]|numeric');
        $val->set_rules('txtemail', $this->lang->line('label_email_address'), 'trim|required|xss_clean|valid_email|callback_email_check');
        $val->set_rules('chk_check_agreement',$this->lang->line("label_job_seeker_agreement"),'required');


        /*
         *  Load view
         */

        if ($val->run() == FALSE) {

            /*
             *  Load model
             */
            $this->load->model("model_location", "location");

            $data["list_address"] = $this->location->select_location_level_one_two();

            $this->load->view("register/seeker", $data);
        } else {


            $username = strtolower($this->input->post('txtusername'));
            $passowrd = $this->input->post('txtpassword');
            $res_fullname = $this->input->post('txtfullname');
            $res_address = $this->input->post('cbo_address');
            $res_prime_cont_number = $this->input->post('txtpriconnum');
            $res_second_cont_number = $this->input->post('txtsecconnum');
            $res_email = $this->input->post('txtemail');

            $role_id='3';
            $center_id='0';
            $jc_staff_id='0';

            try {

                /*
                 * Block register user wait activate
                 */

                $this->dx_auth->register($username,$role_id,$center_id, $passowrd, strtolower($res_email));


                /*
                *  Load model Seeker
                */


                $this->load->model("model_resume_phone");
                $this->load->model("model_resume_email");

                /*
                 * Block register resume
                 */
                $data_array = array(
                    "user_id"                       => '0',
                    "username"                      => $username,
                    "center_id"                     => $center_id,
                    "jc_staff_user_id"              => $jc_staff_id,
                    "full_name_english"             => $res_fullname,
                    "present_address_location_id"   => $res_address,
                    "created_date"                  => date('Y-m-d H:i:s', time()),
                    "resume_status"                 => '1'
                );

                $resume_id = $this->model_resume->insert($data_array);

                /*
                 * Block insert resume phone
                 */

                $data_resume_phone = array(
                    "resume_id"     => $resume_id,
                    "phone_number"  => $res_prime_cont_number,
                    "phone_status"  => 0

                );

                $this->model_resume_phone->insert($data_resume_phone);

                if ($res_second_cont_number <> "") {
                    $data_resume_phone_second = array(
                        "resume_id"     => $resume_id,
                        "phone_number"  => $res_second_cont_number,
                        "phone_status"  => 0

                    );

                    $this->model_resume_phone->insert($data_resume_phone_second);
                }

                /*
                 * Block insert resume email address
                 */

                $data_resume_email = array(
                    "resume_id"         => $resume_id,
                    "email_address"     => $res_email,
                    "active"            => 0,
                    "type_email"        => 1
                );

                $this->model_resume_email->insert($data_resume_email);

                redirect("seeker", "location");

            } catch( Exception $e ) {

                /*
                 * Delete all date relate to resume
                 */
                echo $e->getMessage();
            }
        }
    }

    /*
     * Employer registration
     */
    public function employer() {
        $this->lang->load('employer');
        $data = $this->_show_option();
		//$data['lang_status']=$this->lang->lang();

        $this->form_validation->set_error_delimiters('<div class="alert alert-dismissable alert-danger">', '</div>');

        /*
            Page title and social share
        */
        $data['page_title'] = 'Employer registration';//$this->lang->line("register_seeker_title");

        $data['share_title'] = 'Employer registration';//$this->lang->line("register_seeker_title");
        $data['share_url'] = site_url("register-employer");
        $data['share_image'] = $this->lang->line("register_seeker_image");
        /* Script Block */
        $data["script_add"] = array("select2","numeric","pwstrength","wizard","maskedinput","alerts-notifications");
        $data["script_extra"] = "emp_register";
        
        $val = $this->form_validation;

        $val->set_rules('txt_username', $this->lang->line('label_username'), 'trim|required|xss_clean|min_length['.$this->min_username.']|max_length['.$this->max_username.']|callback_username_check|alpha_dash');
        $val->set_rules('txt_password', $this->lang->line('label_password'), 'trim|required|xss_clean|min_length['.$this->min_password.']|max_length['.$this->max_password.']|matches[txt_confirmpass]');
        $val->set_rules('txt_confirmpass', $this->lang->line('label_confirm'), 'trim|required|xss_clean');

        $val->set_rules('txtEmp_name', $this->lang->line('label_fullname'), 'trim|required|max_length[512]|xss_clean');
        $val->set_rules('cbo_emp_type', 'employer type', 'trim|callback_dropdown_check');

        $val->set_rules('cbo_sector','sector', 'trim|callback_dropdown_check');          //'*'
        $data['list_subsector']="";
        if($this->input->post("cbo_sector")<>0){
            $this->load->model("model_sector");
            $id = $this->input->post("cbo_sector");
            $data['list_subsector'] = $this->model_sector->subsector($id, 4);
            $val->set_rules('cbo_subsector', 'subsector', 'trim|callback_dropdown_check');       //'*'
        }

        $val->set_rules('txtReg_no', 'register no', 'trim|required|max_length[36]|xss_clean');
        $val->set_rules('txtPatent_no', 'patent', 'trim|required|max_length[36]|xss_clean');
        $val->set_rules('cbo_owner_nationality', 'nationality of owner', 'trim|callback_dropdown_check');
        $val->set_rules('txtEmployee_total', 'total emloyee', 'trim|required|max_length[10]|numeric');
        $val->set_rules('txtEmployee_female', 'total female', 'trim|required|max_length[10]|numeric');
        $val->set_rules('txtEmployee_disable', 'disability', 'trim|required|max_length[10]|numeric');
        $val->set_rules('txtEmployee_foreign', 'foreign', 'trim|required|max_length[10]|numeric');
        $val->set_rules('txtMain_title_employed', 'main title', 'trim|required|max_length[512]|xss_clean');
        $val->set_rules('txtMain_title_employed_percentage', 'percentage', 'trim|required|max_length[10]|numeric');

        $val->set_rules('cbo_address_country', $this->lang->line('label_country'), 'trim|callback_dropdown_check');
        $data['list_province']="";
        $data['list_district']="";
        $data['list_commune']="";
        $data['list_village']="";
        if($this->input->post("cbo_address_country")<>0){
            $this->load->model("model_location");
            $country = $this->input->post("cbo_address_country");
            $data['list_province'] = $this->model_location->select_province($country);
            if($this->input->post("cbo_address_province")<>0){
                $province = $this->input->post("cbo_address_province");
                $data['list_district'] = $this->model_location->select_district($province);
                if($this->input->post("cbo_address_district")<>0){
                    $district = $this->input->post("cbo_address_district");
                    $data['list_commune'] = $this->model_location->select_commune($district);
                    if($this->input->post("cbo_address_commune")<>0){
                        $commune = $this->input->post("cbo_address_commune");
                        $data['list_village'] = $this->model_location->select_village($commune);
                    }
                }
            }
        }
        $val->set_rules('cbo_address_province', 'province', 'trim|callback_dropdown_check');
        $val->set_rules('cbo_address_district', 'district', 'trim');
        $val->set_rules('cbo_address_commune', 'commune', 'trim');
        $val->set_rules('cbo_address_village', 'village', 'trim');
        $val->set_rules('txtAdd_detail', 'address detail', 'trim|max_length[256]');

        $val->set_rules('txtContact_person', 'contact person', 'trim|required|max_length[256]|xss_clean');
        $val->set_rules('txtPosition', 'position', 'trim|required|max_length[512]|xss_clean');
        $val->set_rules('txtMobile', 'mobile', 'trim|required|max_length[17]|xss_clean');
        $val->set_rules('txtEmail', $this->lang->line('label_email_address'), 'trim|required|xss_clean|valid_email|callback_email_check');
        $val->set_rules('txtOffice_phone', 'office phone', 'trim|max_length[100]|xss_clean');
        $val->set_rules('txtFax', 'fax', 'trim|max_length[17]|xss_clean');
        $val->set_rules('txtWebsite', 'website', 'trim|max_length[256]|xss_clean');
        $val->set_rules('txtFacebook', 'Facebook page', 'trim|max_length[256]|xss_clean');
        $val->set_rules('txtEmp_profile', 'employer profile', 'trim|max_length[512]|xss_clean');
        //$val->set_rules('dlgEmp_logo', 'logo', 'trim|max_length[256]|xss_clean');


        /*
         *  Load view
         */
        if ($val->run() == FALSE) {

            /*
             *  Load model
             */
            $this->load->model("model_location", "location");
            $this->load->model("model_emp_type", "emp_type");
            $this->load->model("model_sector", "sector");

            $data["list_location"] = $this->location->select_location_level_one();
            $data["list_nationality"] = $this->location->select_nationality();
            $data["list_emp_type"] = $this->emp_type->emp_type();
            $data["list_sector_1n2"]=$this->sector->sector_level_1n2();

            $this->load->view("register/employer", $data);
        } else {
            $username = strtolower($this->input->post('txt_username'));
            $passowrd = $this->input->post('txt_password');
            $emp_name = $this->input->post('txtEmp_name');
            $emp_type = $this->input->post('cbo_emp_type');
            $emp_sector = $this->input->post('cbo_subsector');
            $emp_regNo = $this->input->post('txtReg_no');
            $emp_patentNo = $this->input->post('txtPatent_no');
            $owner_nationality = $this->input->post('cbo_owner_nationality');
            $employee_total = $this->input->post('txtEmployee_total');
            $employee_female = $this->input->post('txtEmployee_female');
            $employee_disable = $this->input->post('txtEmployee_disable');
            $employee_foreign = $this->input->post('txtEmployee_foreign');
            $main_title_employed = $this->input->post('txtMain_title_employed');
            $main_title_employed_percentage = $this->input->post('txtMain_title_employed_percentage');

            $chk_country = $this->input->post("cbo_address_country");
            $chk_Province = $this->input->post("cbo_address_province");
            $chk_District = $this->input->post("cbo_address_district");
            $chk_Commune = $this->input->post("cbo_address_commune");
            $chk_Village = $this->input->post("cbo_address_village");

            $emp_address = 0;
            if ($chk_country == 1) {
                if ($chk_District == '0') {
                    $emp_address = $chk_Province;
                } elseif ($chk_Commune == '0') {
                    $emp_address = $chk_District;
                } elseif ($chk_Village == '0') {
                    $emp_address = $chk_Commune;
                } else {
                    $emp_address = $chk_Village;
                }
            } else {
                $emp_address = $chk_Province;
            }

            $emp_address_detail=$this->input->post('txtAdd_detail');

            $contact_person=$this->input->post('txtContact_person');
            $contact_position=$this->input->post('txtPosition');
            $contact_mobile=$this->input->post('txtMobile');
            $contact_email=$this->input->post('txtEmail');
            $emp_phone=$this->input->post('txtOffice_phone');
            $emp_fax=$this->input->post('txtFax');
            $emp_website=$this->input->post('txtWebsite');
            $emp_facebook = $this->input->post('txtFacebook');
            $emp_profile=$this->input->post('txtEmp_profile');


            $role_id='4';
            $center_id='0';
            $jc_staff_id='0';

            try {

                /*
                 * Block register user wait activate
                 */

                $this->dx_auth->register($username,$role_id,$center_id, $passowrd, strtolower($contact_email));

                /*
                *  Load model employer
                */
                $this->load->model("model_employer");

                /*
                 * Block register employer
                 */
                $data_employer_profile = array(
                    "user_id"                       => '0',
                    "username"                      => $username,
                    //"center_id"                     => $center_id,
                    //"jc_staff_user_id"              => $jc_staff_id,
                    "name"                          => $emp_name,
                    "employer_type_id"              => $emp_type,
                    "sector_isic_id"                => $emp_sector,
                    "registration_number"           => $emp_regNo,
                    "patent_number"                 => $emp_patentNo,
                    'owner_nationality'             => $owner_nationality,
                    "total_employee"                => $employee_total,
                    "total_female_employee"         => $employee_female,
                    "total_disabled_employee"       => $employee_disable,
                    "total_foreign"                 => $employee_foreign,
                    "main_job_title"                => $main_title_employed,
                    //"main_job_title_isco_id"        => '',
                    "main_job_title_percentage"     => $main_title_employed_percentage,
                    "address"                       => $emp_address_detail,
                    "location_id"                   => $emp_address,
                    //"address_longitude"             => '',
                    //"address_latitude"              => '',
                    "profile"                       => $emp_profile
                    //"logo"                          => '';
                    //"created_date"                  => date('Y-m-d H:i:s', time()),
                    //"resume_status"                 => '1'

                );

                //$employer_id = $this->model_employer->first_register_emp($data_employer_profile);

                /*
                 * Block insert employer reference
                 */

                $data_employer_reference = array(
                    "employer_id"                  => 'last_insert_id',
                    "contact_person"                => $contact_person,
                    "position_title"                => $contact_position,
                    "mobile_phone"                  => $contact_mobile,
                    "email"                         => $contact_email,
                    "office_phone"                  => $emp_phone,
                    "fax"                           => $emp_fax,
                    "website"                       => $emp_website,
                    "facebook"                      => $emp_facebook
                );

                $this->model_employer->first_register_emp($data_employer_profile,$data_employer_reference);

                redirect("employer-registration-message", "location");

            } catch( Exception $e ) {

                /*
                 * Delete all date relate to resume
                 */
                echo $e->getMessage();
            }
        }
    }


    /*
     * Training course
     */
    public function training()
    {
		$data = $this->_show_option();
        //$data['lang_status'] = $this->lang->lang();

        /*
            Page title and social share
        */
        $data['page_title'] = $this->lang->line("register_training_title");

        $data['share_title'] = $this->lang->line("register_seeker_title");
        $data['share_url'] = site_url("register-job-seeker");
        $data['share_image'] = $this->lang->line("register_seeker_image");

        /*
         * form validation
         */
        $this->load->model('model_training');

        $val = $this->form_validation;
        $val->set_rules('txtusername',$this->lang->line('tr_username'), 'trim|required|xss_clean|min_length['.$this->min_username.']|max_length['.$this->max_username.']|callback_username_check|alpha_dash');
        $val->set_rules('txtpassword',$this->lang->line('tr_password'), 'trim|required|xss_clean|min_length['.$this->min_password.']|max_length['.$this->max_password.']|matches[txtcomfirm]');
        $val->set_rules('txtcomfirm',$this->lang->line('tr_comfirm'), 'trim|required|xss_clean');
        $val->set_rules('txtinsti_name',$this->lang->line('tr_insti_name'), 'trim|required|max_length[255]|xss_clean');
        $val->set_rules('cbo_owner',$this->lang->line('tr_insti_owner'), 'trim|callback_dropdown_check');
        $val->set_rules('cbo_type',$this->lang->line('tr_insti_type'), 'trim|callback_dropdown_check');
        $val->set_rules('txtlicense',$this->lang->line('tr_license'), 'trim|required|max_length[10]|numeric');
        $val->set_rules('txtaddress',$this->lang->line('tr_address'), 'trim|required|max_length[255]');
        $val->set_rules('txtcont_person',$this->lang->line('tr_cont_person'), 'trim|max_length[255]|xss_clean');
        $val->set_rules('txtoffice_phone',$this->lang->line('tr_office_phone'), 'trim|max_length[10]|numeric');
        $val->set_rules('txtmobile',$this->lang->line('tr_mobile'), 'trim|required|max_length[10]|numeric');
        $val->set_rules('txtoffice_fax',$this->lang->line('tr_office_fax'), 'trim|max_length[10]|numeric');

        if($this->input->post('txtemail')=='jc_15'){
            $val->set_rules('txtemail', $this->lang->line('label_email'), 'trim');
        }elseif($this->input->post('txtemail')=='jc_21'){
            $val->set_rules('txtemail', $this->lang->line('label_email'), 'trim');
        }elseif($this->input->post('txtemail')=='jc_02'){
            $val->set_rules('txtemail', $this->lang->line('label_email'), 'trim');
        }elseif($this->input->post('txtemail')=='jc_03'){
            $val->set_rules('txtemail', $this->lang->line('label_email'), 'trim');
        }elseif($this->input->post('txtemail')=='jc_07'){
            $val->set_rules('txtemail', $this->lang->line('label_email'), 'trim');
        }elseif($this->input->post('txtemail')=='jc_23'){
            $val->set_rules('txtemail', $this->lang->line('label_email'), 'trim');
        }elseif($this->input->post('txtemail')=='nea_'){
            $val->set_rules('txtemail', $this->lang->line('label_email'), 'trim');
        }else{
            $val->set_rules('txtemail',$this->lang->line('tr_email'), 'trim|required|xss_clean|valid_email|callback_email_check');
        }
        $val->set_rules('txtwebsite',$this->lang->line('tr_website'));
        $val->set_rules('txtbackground',$this->lang->line('tr_insti_background'), 'trim|required|max_length[255]');

        if ($val->run() == FALSE) {
            /*
             * laod model
             */

            $data['insti_type'] = $this->model_training->get_insti_type();
            $data['insti_owner'] = $this->model_training->get_insti_owner();
            $this->load->view("register/training", $data);
        }else{

            $username = strtolower($this->input->post('txtusername'));
            $passowrd = $this->input->post('txtpassword');
            $comfirm = $this->input->post('txtcomfirm');
            $insti_name= $this->input->post('txtinsti_name');
            $owner = $this->input->post('cbo_owner');
            $type = $this->input->post('cbo_type');
            $license = $this->input->post('txtlicense');
            $address = $this->input->post('txtaddress');
            $cont_person = $this->input->post('txtcont_person');
            $office_phone = $this->input->post('txtoffice_phone');
            $mobile = $this->input->post('txtmobile');
            $office_fax = $this->input->post('txtoffice_fax');
            $email = $this->input->post('txtemail');
            $website = $this->input->post('txtwebsite');
            $background = $this->input->post('txtbackground');

            $role_id=5;
            $center_id= 0;


            try{
                /*
                * Block register user wait activate
                */
                if($this->input->post('txtemail')=='nea_' ||$this->input->post('txtemail')=='jc_15'||$this->input->post('txtemail')=='jc_21'||$this->input->post('txtemail')=='jc_02'||$this->input->post('txtemail')=='jc_03'||$this->input->post('txtemail')=='jc_07'||$this->input->post('txtemail')=='jc_23'){
                    $this->dx_auth->register_from_center($username,$role_id,$center_id,$passowrd,strtolower($email));
                }else{
                    //$this->dx_auth->register($username, $password, strtolower($inst_email),5,$this->lang->line('center_id'));
                    $this->dx_auth->register($username,$role_id,$center_id, $passowrd, strtolower($email));
                }

                /*
                 * Block register resume
                 */
                $data_array = array(
                    "username"                    => $username,
                    "inst_name"                   => $insti_name,
                    "inst_ownership"              => $owner,
                    "inst_type"                   => $type,
                    "inst_reg_num"                => $license,
                    "inst_address"                => $address,
                    "inst_profile_details"        => $background,
                    "inst_cont_person"            => $cont_person,
                    "inst_office_phone"           => $office_phone,
                    "inst_mobile_phone"           => $mobile,
                    "inst_fax"                    => $office_fax,
                    "inst_email"                  => $email,
                    "inst_website"                => $website,
                    "create_date"                => date('Y-m-d H:i:s', time()),
                    "latest_update"              => date('Y-m-d H:i:s', time()),
                    "inst_status"                 => '1'
                );
                $this->model_training->insert($data_array);

                redirect("training-registration-message", "location");
            }catch( Exception $e ) {

                /*
                 * Delete all date relate to resume
                 */
                echo $e->getMessage();
            }
        }

    }

    public function message($status) {
		$data = $this->_show_option();
        //$data['lang_status']=$this->lang->lang();
        if ($status == 1) {
            // Message seeker

            /*
                Page title and social share
            */
            $data['page_title'] = $this->lang->line("register_seeker_title");

            $data['share_title'] = $this->lang->line("register_seeker_title");
            $data['share_url'] = site_url("register-job-seeker");
            $data['share_image'] = $this->lang->line("register_seeker_image");

            $data['h_msg'] = $this->lang->line("msg_alert_h_seeker");


        } elseif ($status == 2) {
            // Message employer
            /*
                                Page title and social share
                            */
            $data['page_title'] = 'Employer Registration';//$this->lang->line("register_seeker_title");

            $data['share_title'] = 'Employer Registration';//$this->lang->line("register_seeker_title");
            $data['share_url'] = site_url("register-employer");
            $data['share_image'] = $this->lang->line("register_seeker_image");

            $data['h_msg'] = 'Employer registration';//$this->lang->line("msg_alert_h_seeker");

        } elseif ($status == 3) {
            // Message training

            $data['page_title'] = $this->lang->line("register_training_title");
            $data['share_title'] = $this->lang->line("register_seeker_title");
            $data['share_url'] = site_url("register-job-seeker");
            $data['share_image'] = $this->lang->line("register_seeker_image");
            $data['h_msg'] = $this->lang->line("msg_alert_h_training");

        } else {
            redirect("", "location");
        }

        $this->load->view("register/message", $data);

    }
    
    
}
?>