<?php
    Class model_author extends CI_Model {

        public function select_one($author_id) {

            $this->db->select("id, author_name");
            $this->db->from("lib_author");
            $this->db->where("id", $author_id);

            return $this->db->get();
        }

        public function select_all() {
            $this->db->from("lib_author");
            $this->db->order_by("author_name", "ASC");

            return $this->db->get();
        }

        public function select_author_by_center($center_id) {
            $this->db->select("id, author_name");
            $this->db->from("lib_author");
            $this->db->where("center_id", $center_id);

            return $this->db->get();
        }

        public function insert($data) {
            $this->db->trans_start();
            $this->db->insert('lib_author', $data);
            $this->db->trans_complete();
        }

        public function update($author_id, $center_id, $data) {
            $this->db->trans_start();
            $this->db->where('id', $author_id);
            $this->db->where('center_id', $center_id);
            $this->db->update('lib_author', $data);
            $this->db->trans_complete();
        }

        public function delete($author_id, $center_id) {
            $this->db->trans_start();
            $this->db->where('id', $author_id);
            $this->db->where('center_id', $center_id);
            $this->db->delete('lib_author');
            $this->db->trans_complete();
        }


    }
?>