<?php

    Class model_books extends CI_Model {

        public function get_latest_book() {

            $this->db->limit(12);
            $this->db->select("id, book_title, book_photo");
            $this->db->from("lib_books");
            $this->db->order_by("id", "DESC");

            return $this->db->get();
        }

        public function get_category_total_books($cate_id) {

            $this->db->from("lib_books");
            $this->db->where("book_category", $cate_id);

            return $this->db->count_all_results();
        }

        public function get_book_by_cate($cate_id, $limit, $offset){

            $this->db->limit($limit, $offset);
            $this->db->select("id, book_title, book_photo");
            $this->db->from("lib_books");
            $this->db->where("book_category", $cate_id);
            $this->db->order_by("id", "DESC");

            return $this->db->get();
        }

        public function select_one($book_id) {

            $this->db->select("A.*, B.category_name, C.author_name, D.org_name");
            $this->db->from("lib_books A, lib_category B, lib_author C, lib_donate D");
            $where = "A.book_category = B.id AND A.book_author_id = C.id AND A.book_donate_id = D.id";
            $this->db->where($where);
            $this->db->where("A.id", $book_id);

            return $this->db->get();
        }

        public function get_author_total_books($author_id) {
            $this->db->from("lib_books");
            $this->db->where("book_author_id", $author_id);

            return $this->db->count_all_results();
        }

        public function get_donate_total_books($donate_id) {
            $this->db->from("lib_books");
            $this->db->where("book_donate_id", $donate_id);

            return $this->db->count_all_results();
        }

        public function get_book_by_author($author_id, $limit, $offset){

            $this->db->limit($limit, $offset);
            $this->db->select("id, book_title, book_photo");
            $this->db->from("lib_books");
            $this->db->where("book_author_id", $author_id);
            $this->db->order_by("id", "DESC");

            return $this->db->get();
        }

        public function get_year_total_books($year) {
            $this->db->from("lib_books");
            $this->db->where("book_publish_year", $year);

            return $this->db->count_all_results();
        }

        public function get_book_by_year($year, $limit, $offset){

            $this->db->limit($limit, $offset);
            $this->db->select("id, book_title, book_photo");
            $this->db->from("lib_books");
            $this->db->where("book_publish_year", $year);
            $this->db->order_by("id", "DESC");

            return $this->db->get();
        }

        public function get_search_total_books($keyword) {
            $this->db->from("lib_books");
            //$where = "MATCH (book_title, book_keyword) AGAINST ('".$keyword."' IN BOOLEAN MODE)";
            $this->db->where("MATCH (book_title, book_keyword) AGAINST ('".$keyword."' IN BOOLEAN MODE)", NULL, FALSE);
            return $this->db->count_all_results();
        }

        public function get_book_by_search($keyword, $limit, $offset) {

            $this->db->limit($limit, $offset);
            $this->db->select("id, book_title, book_photo");
            $this->db->from("lib_books");
            //$where = "MATCH (book_title, book_keyword) AGAINST ('".$keyword."' IN BOOLEAN MODE)";
            $this->db->where("MATCH (book_title, book_keyword) AGAINST ('".$keyword."' IN BOOLEAN MODE)", NULL, FALSE);
            return $this->db->get();

        }

        public function searchbooktitle($title) {

            $this->db->like("book_title", $title, "both");
            $this->db->from("lib_books");
            return $this->db->get();
        }

        public function insert($data) {
            $this->db->trans_start();
            $this->db->insert('lib_books',$data);
            $insert_id = $this->db->insert_id();
            $this->db->trans_complete();
            return $insert_id;
        }

        public function update($book_id ,$data) {
            $this->db->trans_start();
            $this->db->where("id", $book_id);
            $this->db->update('lib_books',$data);
            $this->db->trans_complete();
            return "";
        }

        public function select_book_update($book_id) {

            $this->db->select("*");
            $this->db->from("lib_books");
            $this->db->where("id", $book_id);

            return $this->db->get();
        }
    }
?>