<?php
    Class model_membership extends CI_Model {
        
        public function insert($data) {
            $this->db->trans_start();
            $this->db->insert('lib_membership', $data); 
            $this->db->trans_complete();
        }
        
        public function get_total($center_id) {
            
            $this->db->where("center_id", $center_id);
            $this->db->from("lib_membership");
            
            return $this->db->count_all_results();
        }
        
        public function get_membership($center_id, $limit, $offset) {
            
            $this->db->limit($limit, $offset);
            $this->db->select("*");
            $this->db->from("lib_membership");
            $this->db->where("center_id", $center_id);
            $this->db->order_by("ID", "DESC");
            
            return $this->db->get();
        }
        
        public function select_one($id, $center_id) {
            
            $this->db->select("*");
            $this->db->from("lib_membership");
            $this->db->where("ID", $id);
            $this->db->where("center_id", $center_id);
            
            return $this->db->get();
        }
        
        public function update($id, $center_id, $data) {
            
            $this->db->trans_start();
            $this->db->where('ID', $id);
            $this->db->where('center_id', $center_id);
            $this->db->update('lib_membership', $data);
            $this->db->trans_complete(); 
            
        }
    }
?>