<?php
    class model_employer extends CI_Model {

        public function first_register_emp($data_employer_profile,$data_employer_reference) {

            $this->db->trans_start();

            $this->db->insert('employer', $data_employer_profile);
            $employer_id = array('employer_id' => $this->db->insert_id());
            $data_employer_reference = array_replace($data_employer_reference,$employer_id);
            $this->db->insert('employer_reference', $data_employer_reference);

            $this->db->trans_complete();
        }

        public function first_register_emp_reference($data_employer_reference) {

            $last_id = 0;
            $this->db->trans_start();
            $this->db->insert('employer_reference', $data_employer_reference);
            $last_id = $this->db->insert_id();
            $this->db->trans_complete();

            return $last_id;
        }

        public function update_emp_detail($data_employer_detail) {

            $this->db->trans_start();

            $this->db->where('employer_id', $this->session->userdata('employer_id'));
            $this->db->where('user_id', $this->dx_auth->get_user_id());
            $this->db->update('employer', $data_employer_detail);

            $this->db->trans_complete();
        }

        public function vacancies_list($vacancy_id){
            return $this->db->query("CALL emp_vacancies_list($vacancy_id)");
        }

        public function vacancies_expired($vacancy_id){
            return $this->db->query("CALL emp_vacancies_expired($vacancy_id)");
        }

        public function employer_id($user_id){
            $this->db->select('employer_id');
            $this->db->from('employer');
            $this->db->where('user_id', $user_id);
            return $this->db->get();
        }
        public function get_vacancy_detail_id1($vacancy_id){
            $result = $this->db->query("CALL emp_vacancy_detail_id($vacancy_id)");
            print_r($result->fetch_assoc());
        }

        public function get_vacancy_detail_id($vacancy_id){
            $k = 0;
            $arr_results_sets = array();
            /* execute multi query */
            if (mysqli_multi_query($this->db->conn_id, "CALL emp_vacancy_detail_id($vacancy_id)")) {
                do {
                    $result = mysqli_store_result($this->db->conn_id);
                    //print_r($result);
                    //echo '<br />';
                    if ($result) {
                        $l = 0;
                        while ($row = $result->fetch_assoc()) {
                            $arr_results_sets[$k][$l] = $row;
                            $l++;
                        }
                    }
                    $k++;
                } while (mysqli_more_results($this->db->conn_id) ? mysqli_next_result($this->db->conn_id) : "");
            }
            return $arr_results_sets;
        }

        public function get_employer_profile($user_id){
            $qry_result = $this->db->query("CALL emp_profile($user_id)");
            $return_emp_profile = $qry_result->row();

            $qry_result->next_result();
            $qry_result->free_result();
            return $return_emp_profile;
        }

        public function get_employer_profile_view($employer_id) {
            $qry_result = $this->db->query("CALL emp_profile_view($employer_id)");
            $return_emp_profile = $qry_result->row();

            $qry_result->next_result();
            $qry_result->free_result();
            return $return_emp_profile;
        }

        public function get_employer_reference($employer_id){
            $this->db->select("*");
            $this->db->from("employer_reference");
            $this->db->where("employer_id", $employer_id);
            $this->db->order_by("employer_reference_id", "asc");
            return $this->db->get();
        }
        public function get_employer_reference_byId($employer_reference_id){
            $this->db->select("*");
            $this->db->from("employer_reference");
            $this->db->where("employer_reference_id", $employer_reference_id);
            return $this->db->get();
        }
        public function get_employer_reference1($emp_id){
            $qry_result = $this->db->query("CALL emp_contact($emp_id)");
            $return_emp_contac = $qry_result->result();

            $qry_result->next_result();
            $qry_result->free_result();
            return $return_emp_contac;
        }
        public function edit_employer_reference_byId($employer_id,$employer_reference_id,$data_employer_reference){

            $this->db->trans_start();

            $this->db->where("employer_reference_id", $employer_reference_id);
            $this->db->where("employer_id", $employer_id);
            $this->db->update('employer_reference', $data_employer_reference);
            $this->db->trans_complete();

            return $last_id;
        }
        public function add_employer_reference($data_employer_reference){

            $this->db->trans_start();
            $this->db->insert('employer_reference', $data_employer_reference);
            $this->db->trans_complete();

            return $last_id;
        }
        public function delete_employer_reference($employer_id,$employer_reference_id){

            $this->db->trans_start();
            $this->db->where('employer_reference_id', $employer_reference_id);
            $this->db->where('employer_id', $employer_id);
            $this->db->delete('employer_reference');
            $this->db->trans_complete();

            return $last_id;
        }
    }