<?php
    class model_jobshop extends CI_Model
    {

        public function get_latest_vacancies()
        {
            $this->db->limit(10);
            $this->db->select("*");
            $this->db->from("jobshop_vacancies");
            $this->db->order_by("vacancy_id", "DESC");

            return $this->db->get();
        }

        public function get_latest_top_vacancies()
        {
            $this->db->limit(10);
            $this->db->select("*");
            $this->db->from("jobshop_vacancies");
            $this->db->group_by("vacancy_id");
            $this->db->order_by("total_vacancy", "DESC");

            return $this->db->get();
        }
        
        /* List All Vacancies */

        public function get_total_vacancies()
        {
            //$this->db->from('jobshop_vacancies');
            //return $this->db->count_all_results();
            
            $this->db->select("SUM(A.total_vacancy) AS 'total_vacancy'");
            $this->db->from("jobshop_vacancies A");
            $data = $this->db->get();
            $data_row = $data->row();
            return $data_row->total_vacancy;
        }
		
		public function get_total_vacancies_page()
        {
            $this->db->from('jobshop_vacancies');
            return $this->db->count_all_results();
        }

        public function get_all_vacancies($limit, $offset)
        {

            $this->db->limit($limit, $offset);
            $this->db->select("*");
            $this->db->from("jobshop_vacancies");
            $this->db->order_by("vacancy_id", "DESC");

            return $this->db->get();

            //return $this->db->query("CALL jobshop_all_vacancies($limit, $offset)");
        }

        public function get_location()
        {

            $this->db->select("*");
            $this->db->from("jobshop_location");
            $this->db->where("location_id!=", "1");
            $this->db->order_by("total_job", "DESC");

            return $this->db->get();
        }

        public function get_row_vacancies($job_id)
        {

            $this->db->select("*");
            $this->db->from("jobshop_vacancies");
            $this->db->where("vacancy_id", $job_id);

            return $this->db->get();
        }

        /* List All Vacancies By Location */

        public function get_total_vacancies_by_location($level_code)
        {

            $query_string = "SELECT COUNT(*) AS num_row FROM jobshop_vacancies A WHERE FIND_IN_SET($level_code, A.job_location_id) > 0";
            $list_data = $this->db->query($query_string)->row();
            return $list_data->num_row;

        }

        public function get_vacancies_by_location($level_code, $limit, $offset)
        {

            $query_string = "SELECT A.* FROM jobshop_vacancies A WHERE FIND_IN_SET($level_code, A.job_location_id) > 0 ORDER BY A.vacancy_id DESC LIMIT $offset, $limit";

            return $this->db->query($query_string);
        }

        /* List all vacacanies by search */

        public function get_total_vacancies_by_search($level_code, $value_sector, $keyword)
        {

            if ($keyword == "0") {
                if ($level_code == "0") {
                    if ($value_sector == "0") {
                        $query_string = "SELECT COUNT(*) AS num_row FROM jobshop_vacancies A";
                    } else {
                        $query_string = "SELECT COUNT(*) AS num_row FROM jobshop_vacancies A WHERE A.isic_level_code LIKE '" . $value_sector . "%'";
                    }
                } else {
                    if ($value_sector == "0") {
                        $query_string = "SELECT COUNT(*) AS num_row FROM jobshop_vacancies A WHERE FIND_IN_SET($level_code, A.job_location_id) > 0";
                    } else {
                        $query_string = "SELECT COUNT(*) AS num_row FROM jobshop_vacancies A WHERE FIND_IN_SET($level_code, A.job_location_id) > 0 AND A.isic_level_code LIKE '" . $value_sector . "%'";
                    }

                }
                //$query_string = "SELECT COUNT(*) AS num_row FROM jobshop_vacancies A WHERE FIND_IN_SET($level_code, A.job_location_id) > 0";
            } else {
                if ($level_code == "0") {
                    if ($value_sector == "0") {
                        $query_string = "SELECT COUNT(*) AS num_row " .
                            "FROM jobshop_vacancies A " .
                            "WHERE A.job_title LIKE '%" . $keyword . "%' " .
                            "OR A.job_title_isco_code IN (SELECT B.isco_id " .
                            "FROM isco B " .
                            "WHERE B.name_english LIKE '%" . $keyword . "%' " .
                            "OR B.name_khmer LIKE '%" . $keyword . "%') ";
                    } else {
                        $query_string = "SELECT COUNT(*) AS num_row " .
                            "FROM jobshop_vacancies A " .
                            "WHERE A.job_title LIKE '%" . $keyword . "%' " .
                            "OR A.job_title_isco_code IN (SELECT B.isco_id " .
                            "FROM isco B " .
                            "WHERE B.name_english LIKE '%" . $keyword . "%' " .
                            "OR B.name_khmer LIKE '%" . $keyword . "%') " .
                            "AND A.isic_level_code LIKE '" . $value_sector . "%'";
                    }

                } else {
                    if ($value_sector == "0") {
                        $query_string = "SELECT COUNT(*) AS num_row " .
                            "FROM jobshop_vacancies A " .
                            "WHERE FIND_IN_SET($level_code, A.job_location_id) > 0 " .
                            "AND A.job_title LIKE '%" . $keyword . "%' " .
                            "OR A.job_title_isco_code IN (SELECT B.isco_id " .
                            "FROM isco B " .
                            "WHERE B.name_english LIKE '%" . $keyword . "%' " .
                            "OR B.name_khmer LIKE '%" . $keyword . "%') ";
                    } else {
                        $query_string = "SELECT COUNT(*) AS num_row " .
                            "FROM jobshop_vacancies A " .
                            "WHERE FIND_IN_SET($level_code, A.job_location_id) > 0 " .
                            "AND A.job_title LIKE '%" . $keyword . "%' " .
                            "OR A.job_title_isco_code IN (SELECT B.isco_id " .
                            "FROM isco B " .
                            "WHERE B.name_english LIKE '%" . $keyword . "%' " .
                            "OR B.name_khmer LIKE '%" . $keyword . "%') " .
                            "AND A.isic_level_code LIKE '" . $value_sector . "%'";
                    }

                }
            }

            $list_data = $this->db->query($query_string)->row();
            return $list_data->num_row;
        }

        public function get_vacancies_by_search($level_code, $value_sector, $keyword, $limit, $offset)
        {

            if ($keyword == "0") {
                if ($level_code == "0") {
                    if ($value_sector == 0) {
                        $query_string = "SELECT A.* FROM jobshop_vacancies A ORDER BY A.vacancy_id DESC LIMIT $offset, $limit";
                    } else {
                        $query_string = "SELECT A.* FROM jobshop_vacancies A WHERE A.isced_level_code LIKE '" . $value_sector . "%' ORDER BY A.vacancy_id DESC LIMIT $offset, $limit";
                    }

                } else {
                    if ($value_sector == 0) {
                        $query_string = "SELECT A.* FROM jobshop_vacancies A WHERE FIND_IN_SET($level_code, A.job_location_id) > 0 ORDER BY A.vacancy_id DESC LIMIT $offset, $limit";
                    } else {
                        $query_string = "SELECT A.* FROM jobshop_vacancies A WHERE FIND_IN_SET($level_code, A.job_location_id) > 0 AND A.isic_level_code LIKE '" . $value_sector . "%' ORDER BY A.vacancy_id DESC LIMIT $offset, $limit";
                    }

                }
            } else {
                if ($level_code == "0") {
                    //$query_string = "SELECT A.* FROM jobshop_vacancies A WHERE A.job_location_eng LIKE '%" . $keyword . "%' OR A.job_location_kh LIKE '%" . $keyword . "%' ORDER BY A.vacancy_id DESC LIMIT $offset, $limit";

                    if ($value_sector == 0) {
                        $query_string = "SELECT A.* " .
                            "FROM jobshop_vacancies A " .
                            "WHERE A.job_title LIKE '%" . $keyword . "%' " .
                            "OR A.job_title_isco_code IN (SELECT B.isco_id " .
                            "FROM isco B " .
                            "WHERE B.name_english LIKE '%" . $keyword . "%' " .
                            "OR B.name_khmer LIKE '%" . $keyword . "%') " .
                            "ORDER BY A.vacancy_id DESC LIMIT $offset, $limit";
                    } else {
                        $query_string = "SELECT A.* " .
                            "FROM jobshop_vacancies A " .
                            "WHERE A.job_title LIKE '%" . $keyword . "%' " .
                            "OR A.job_title_isco_code IN (SELECT B.isco_id " .
                            "FROM isco B " .
                            "WHERE B.name_english LIKE '%" . $keyword . "%' " .
                            "OR B.name_khmer LIKE '%" . $keyword . "%') " .
                            "AND A.isic_level_code LIKE '" . $value_sector . "%' " .
                            "ORDER BY A.vacancy_id DESC LIMIT $offset, $limit";
                    }


                } else {
                    //$query_string = "SELECT A.* FROM jobshop_vacancies A WHERE FIND_IN_SET($level_code, A.job_location_id) > 0 AND A.job_location_eng LIKE '%" . $keyword . "%' OR A.job_location_kh LIKE '%" . $keyword . "%' ORDER BY A.vacancy_id DESC LIMIT $offset, $limit";
                    if ($value_sector == 0) {
                        $query_string = "SELECT A.* " .
                            "FROM jobshop_vacancies A " .
                            "WHERE FIND_IN_SET($level_code, A.job_location_id) > 0 " .
                            "AND A.job_title LIKE '%" . $keyword . "%' " .
                            "OR A.job_title_isco_code IN (SELECT B.isco_id " .
                            "FROM isco B " .
                            "WHERE B.name_english LIKE '%" . $keyword . "%' " .
                            "OR B.name_khmer LIKE '%" . $keyword . "%') " .
                            "ORDER BY A.vacancy_id DESC LIMIT $offset, $limit";
                    } else {
                        $query_string = "SELECT A.* " .
                            "FROM jobshop_vacancies A " .
                            "WHERE FIND_IN_SET($level_code, A.job_location_id) > 0 " .
                            "AND A.job_title LIKE '%" . $keyword . "%' " .
                            "OR A.job_title_isco_code IN (SELECT B.isco_id " .
                            "FROM isco B " .
                            "WHERE B.name_english LIKE '%" . $keyword . "%' " .
                            "OR B.name_khmer LIKE '%" . $keyword . "%') " .
                            "AND A.isic_level_code LIKE '" . $value_sector . "%' " .
                            "ORDER BY A.vacancy_id DESC LIMIT $offset, $limit";
                    }

                }
            }
            return $this->db->query($query_string);
        }

        public function get_latest_seeker()
        {
            return $this->db->query("CALL jobshop_get_latest_seeker()");
        }

        public function get_resume_by_resume_id($resume_id)
        {
            $k = 0;
            $arr_results_sets = array();
            /* execute multi query */
            if (mysqli_multi_query($this->db->conn_id, "CALL resume_select_resume_by_resume_id($resume_id)")) {
                do {
                    $result = mysqli_store_result($this->db->conn_id);
                    //print_r($result);
                    //echo '<br />';
                    if ($result) {
                        $l = 0;
                        while ($row = $result->fetch_assoc()) {
                            $arr_results_sets[$k][$l] = $row;
                            $l++;
                        }
                    }
                    $k++;
                } while (mysqli_next_result($this->db->conn_id));
            }
            return $arr_results_sets;
        }

        public function get_total_canidate()
        {
            $this->db->where("resume_status", "2");
            $this->db->from('resume');
            return $this->db->count_all_results();
        }

        public function get_canidate_all($ilimit, $ioffset)
        {
            return $this->db->query("CALL jobshop_get_seeker_all(" . $ilimit . "," . $ioffset . ")");
        }

        public function get_total_seeker()
        {
            $this->db->where("resume_status", "2");
            $this->db->from('resume');
            return $this->db->count_all_results();
        }

        /* Comment */
        public function get_seeker_by_location()
        {
            $this->db->select("*");
            $this->db->from("jobshop_seeker_by_location");
            $this->db->order_by("total_job", "DESC");

            return $this->db->get();
        }

        public function get_seeker_by_location_total_home() {
            $this->db->select("SUM(total_job) AS TotalJob");
            $this->db->from("jobshop_seeker_by_location");
            $data = $this->db->get();

            $data_row = $data->row();

            return $data_row->TotalJob;
        }

        public function get_seeker_by_education()
        {
            $this->db->select("*");
            $this->db->from("jobshop_seeker_by_education");
            return $this->db->get();
        }

        /* Jobshop by occupation */
        public function get_jobshop_by_occupation()
        {
            $this->db->select("*");
            $this->db->from("jobshop_vacancies_by_isco");

            return $this->db->get();
        }


        public function get_total_vacancies_by_occupation($isco_id)
        {
            $this->db->select("*");
            $this->db->from("jobshop_vacancies");
            $where = "jobshop_vacancies.job_title_isco_code IN (SELECT isco.isco_id FROM isco WHERE isco.level_code LIKE '" . $isco_id . "=>%' AND isco.level = 4)";
            $this->db->where($where);

            return $this->db->count_all_results();
        }

        public function get_vacancies_by_occupation($isco_id, $limit, $offset)
        {
            $this->db->limit($limit, $offset);
            $this->db->select("*");
            $this->db->from("jobshop_vacancies");
            $where = "jobshop_vacancies.job_title_isco_code IN (SELECT isco.isco_id FROM isco WHERE isco.level_code LIKE '" . $isco_id . "=>%' AND isco.level = 4)";
            $this->db->where($where);
            $this->db->order_by("vacancy_id", "DESC");
            return $this->db->get();
        }

        /* Jobshop by sector */
        public function get_jobshop_by_sector()
        {
            $this->db->select("*");
            $this->db->from("jobshop_vacancies_by_isic");

            return $this->db->get();
        }

        public function get_total_vacancies_by_sector($sector_id)
        {
            $this->db->select("*");
            $this->db->from("jobshop_vacancies");
            $where = "jobshop_vacancies.isic_level_code IN (SELECT isic.level_code FROM isic WHERE isic.level_code LIKE '" . $sector_id . "=>%' AND isic.level = 4)";
            $this->db->where($where);

            return $this->db->count_all_results();
        }

        public function get_vacancies_by_sector($sector_id, $limit, $offset)
        {
            $this->db->limit($limit, $offset);
            $this->db->select("*");
            $this->db->from("jobshop_vacancies");
            $where = "jobshop_vacancies.isic_level_code IN (SELECT isic.level_code FROM isic WHERE isic.level_code LIKE '" . $sector_id . "=>%' AND isic.level = 4)";
            $this->db->where($where);
            $this->db->order_by("vacancy_id", "DESC");
            return $this->db->get();
        }

        public function get_seeker_by_occupation_total($level1, $level2, $level3, $level4)
        {
            $this->db->select("*");
            $this->db->from("resume_job_wanted A");
            if ($level1 > 0 AND $level2 > 0 AND $level3 > 0 AND $level4 > 0) {
                $this->db->where("A.occupation_isco_id", $level4);
            } elseif ($level1 > 0 AND $level2 > 0 AND $level3 > 0 AND $level4 == "0") {
                $level_code = $level1 . "=>" . $level2 . "=>" . $level3 . "=>%";
                $where = "A.occupation_isco_id IN (SELECT B.isco_id FROM isco B WHERE B.level_code LIKE '$level_code' AND B.level = 4)";
                $this->db->where($where);
            } elseif ($level1 > 0 AND $level2 > 0 AND $level3 == 0 AND $level4 == "0") {
                $level_code = $level1 . "=>" . $level2 . "=>%";
                $where = "A.occupation_isco_id IN (SELECT B.isco_id FROM isco B WHERE B.level_code LIKE '$level_code' AND B.level = 4)";
                $this->db->where($where);
            } elseif ($level1 > 0 AND $level2 == 0 AND $level3 == 0 AND $level4 == "0") {
                $level_code = $level1 . "=>%";
                $where = "A.occupation_isco_id IN (SELECT B.isco_id FROM isco B WHERE B.level_code LIKE '$level_code' AND B.level = 4)";
                $this->db->where($where);
            }
            return $this->db->count_all_results();

        }

        public function get_seeker_by_occupation($level1, $level2, $level3, $level4, $limit, $offset)
        {
            if ($level1 > 0 AND $level2 > 0 AND $level3 > 0 AND $level4 > 0) {
                $qry_result = $this->db->query("CALL jobshop_employer_seeker_by_occupation_level_4($level4, $limit, $offset)");
                return $qry_result;
            } elseif ($level1 > 0 AND $level2 > 0 AND $level3 > 0 AND $level4 == "0") {
                $qry_result = $this->db->query("CALL jobshop_employer_seeker_by_occupation_level_3($level1, $level2, $level3, $limit, $offset)");
                return $qry_result;
            } elseif ($level1 > 0 AND $level2 > 0 AND $level3 == 0 AND $level4 == "0") {
                $qry_result = $this->db->query("CALL jobshop_employer_seeker_by_occupation_level_2($level1, $level2, $limit, $offset)");
                return $qry_result;
            } elseif ($level1 > 0 AND $level2 == 0 AND $level3 == 0 AND $level4 == "0") {
                $qry_result = $this->db->query("CALL jobshop_employer_seeker_by_occupation_level_1($level1, $limit, $offset)");
                return $qry_result;
            }
        }
     // Get Seeker for IOS
        public function get_js_by_occupation($level1, $level2, $level3, $level4)
        {
            if ($level1 > 0 AND $level2 > 0 AND $level3 > 0 AND $level4 > 0) {
                $qry_result = $this->db->query("CALL api_seeker_by_occupation_level_4($level4)");
                return $qry_result;
            } elseif ($level1 > 0 AND $level2 > 0 AND $level3 > 0 AND $level4 == "0") {
                $qry_result = $this->db->query("CALL api_seeker_by_occupation_level_3($level1, $level2, $level3)");
                return $qry_result;
            } elseif ($level1 > 0 AND $level2 > 0 AND $level3 == 0 AND $level4 == "0") {
                $qry_result = $this->db->query("CALL api_seeker_by_occupation_level_2($level1, $level2)");
                return $qry_result;
            } elseif ($level1 > 0 AND $level2 == 0 AND $level3 == 0 AND $level4 == "0") {
                $qry_result = $this->db->query("CALL api_seeker_by_occupation_level_1($level1)");
                return $qry_result;
            }
        }

        // Get Seeker by Location for IOS
        public function get_js_by_location($level_code) {
            $qry_result = $this->db->query("CALL api_seeker_by_location($level_code)");
            return $qry_result;
        }

        // Get Seeker by Education for IOS
        public function get_js_by_education($degree_id) {

            if ($degree_id >=211 AND $degree_id <= 221) {
                $qry_result = $this->db->query("CALL api_seeker_by_education_tvet($degree_id)");
                return $qry_result;
            } else {
                $qry_result = $this->db->query("CALL api_seeker_by_education_gen($degree_id)");
                return $qry_result;
            }
        }


        public function get_seeker_by_education_total($degree_id) {


            if ($degree_id == 101) {
                $this->db->select("*");
                $this->db->from("resume_general_education");
                $where = "education_degree_id BETWEEN 101 AND 108";
                $this->db->where($where);
                return $this->db->count_all_results();
            } elseif ($degree_id == 109) {
                $this->db->select("*");
                $this->db->from("resume_general_education");
                $where = "education_degree_id BETWEEN 109 AND 111";
                $this->db->where($where);
                return $this->db->count_all_results();
            } elseif ($degree_id == 112) {
                $this->db->select("*");
                $this->db->from("resume_general_education");
                $this->db->where("education_degree_id", $degree_id);
                return $this->db->count_all_results();
            } elseif ($degree_id == 113) {
                $this->db->select("*");
                $this->db->from("resume_general_education");
                $where = "education_degree_id BETWEEN 113 AND 115";
                $this->db->where($where);
                return $this->db->count_all_results();
            } elseif ($degree_id == 116) {
                $this->db->select("*");
                $this->db->from("resume_general_education");
                $this->db->where("education_degree_id", $degree_id);
                return $this->db->count_all_results();
            } elseif ($degree_id >=317 AND $degree_id <= 322) {
                $this->db->select("*");
                $this->db->from("resume_general_education");
                $where = "education_degree_id BETWEEN 116 AND 321";
                $this->db->where($where);
                return $this->db->count_all_results();
            } else {
                $this->db->select("*");
                $this->db->from("resume_tvet_education");
                $this->db->where("education_degree_id", $degree_id);
                return $this->db->count_all_results();
            }
        }

        public function emp_get_seeker_by_education($degree_id, $limit, $offset) {

            if ($degree_id >=211 AND $degree_id <= 221) {
                $qry_result = $this->db->query("CALL jobshop_employer_seeker_by_eduction_tvet($degree_id, $limit, $offset)");
                return $qry_result;
            } else {
                $qry_result = $this->db->query("CALL jobshop_employer_seeker_by_eduction_gen($degree_id, $limit, $offset)");
                return $qry_result;
            }
        }

        public function get_seeker_by_location_total($level_code) {
            $this->db->select("*");
            $this->db->from("resume A");
            $where = "SUBSTRING(A.present_address_location_id,1,3) = $level_code";
            $this->db->where($where);
            return $this->db->count_all_results();
        }

        public function emp_get_seeker_by_location($level_code, $limit, $offset) {
            $qry_result = $this->db->query("CALL jobshop_employer_seeker_by_location($level_code, $limit, $offset)");
            return $qry_result;
        }

        public function get_total_vacancies_by_id($vacancy_id) {

            $this->db->select("SUM(number_vacancy) AS TotalVacancy");
            $this->db->from("vacancy_location");
            $this->db->where("vacancy_id", $vacancy_id);
            $data = $this->db->get();

            $data_row = $data->row();

            return $data_row->TotalVacancy;

        }

        public function get_employer_seeker_search_total($location_id, $education_degree, $keyword) {

            if ($keyword == 0) {
                if ($location_id == 0) {
                    if ($education_degree == 0) {
                        $query_string = "SELECT COUNT(*) AS num_row FROM resume A WHERE A.resume_status = 2";
                    } else {
                        if ($education_degree >= 211 AND $education_degree <=221) {
                            $query_string = "SELECT COUNT(*) AS num_row FROM resume A LEFT JOIN resume_tvet_education B ON B.resume_id = A.resume_id WHERE A.resume_status = 2 AND B.education_degree_id = ". $education_degree;
                        } else {
                            $query_string = "SELECT COUNT(*) AS num_row FROM resume A LEFT JOIN resume_general_education B ON B.resume_id = A.resume_id WHERE A.resume_status = 2 AND B.education_degree_id = ". $education_degree;
                        }
                    }
                } else {
                    if ($education_degree == 0) {
                        $query_string = "SELECT COUNT(*) AS num_row FROM resume A WHERE A.resume_status = 2 AND SUBSTRING(A.present_address_location_id,1,3) = " . $location_id;
                    } else {
                        if ($education_degree >= 211 AND $education_degree <=221) {
                            $query_string = "SELECT COUNT(*) AS num_row FROM resume A LEFT JOIN resume_tvet_education B ON B.resume_id = A.resume_id  WHERE A.resume_status = 2 AND B.education_degree_id = " . $education_degree . " AND SUBSTRING(A.present_address_location_id,1,3) = " . $location_id;
                        } else {
                            $query_string = "SELECT COUNT(*) AS num_row FROM resume A LEFT JOIN resume_general_education B ON B.resume_id = A.resume_id WHERE A.resume_status = 2 AND B.education_degree_id = ". $education_degree . " AND SUBSTRING(A.present_address_location_id,1,3) = " . $location_id;
                        }
                    }
                }
            } else {
                if ($location_id == 0) {
                    if ($education_degree == 0) {
                        $query_string = "SELECT COUNT(*) AS num_row ".
                                            "FROM resume A LEFT JOIN resume_job_wanted B ON B.resume_id = A.resume_id ".
                                            "WHERE A.resume_status = 2 ".
                                            "AND B.occupation_isco_id IN (SELECT C.isco_id " .
                                                "FROM isco C " .
                                                "WHERE C.name_english LIKE '%" . $keyword . "%' " .
                                                "OR C.name_khmer LIKE '%" . $keyword . "%') ";
                    } else {
                        if ($education_degree >= 211 AND $education_degree <=221) {
                            $query_string = "SELECT COUNT(*) AS num_row ".
                                                "FROM resume A LEFT JOIN resume_tvet_education B ON B.resume_id = A.resume_id LEFT JOIN resume_job_wanted C ON C.resume_id = A.resume_id ".
                                                "WHERE A.resume_status = 2 AND B.education_degree_id = ". $education_degree.
                                                    " AND C.occupation_isco_id IN (SELECT B.isco_id " .
                                                    "FROM isco D " .
                                                    "WHERE D.name_english LIKE '%" . $keyword . "%' " .
                                                    "OR D.name_khmer LIKE '%" . $keyword . "%') ";
                        } else {
                            $query_string = "SELECT COUNT(*) AS num_row ".
                                                "FROM resume A LEFT JOIN resume_general_education B ON B.resume_id = A.resume_id LEFT JOIN resume_job_wanted C ON C.resume_id = A.resume_id ".
                                                "WHERE A.resume_status = 2 AND B.education_degree_id = ". $education_degree.
                                                    " AND C.occupation_isco_id IN (SELECT B.isco_id " .
                                                    "FROM isco D " .
                                                    "WHERE D.name_english LIKE '%" . $keyword . "%' " .
                                                    "OR D.name_khmer LIKE '%" . $keyword . "%') ";
                        }
                    }
                } else {
                    if ($education_degree == 0) {
                        $query_string = "SELECT COUNT(*) AS num_row ".
                                            "FROM resume A LEFT JOIN resume_job_wanted B ON B.resume_id = A.resume_id ".
                                            "WHERE A.resume_status = 2 ".
                                                "AND SUBSTRING(A.present_address_location_id,1,3) = " . $location_id.
                                                " AND B.occupation_isco_id IN (SELECT C.isco_id " .
                                                "FROM isco C " .
                                                "WHERE C.name_english LIKE '%" . $keyword . "%' " .
                                                "OR C.name_khmer LIKE '%" . $keyword . "%') ";
                    } else {
                        if ($education_degree >= 211 AND $education_degree <=221) {
                            $query_string = "SELECT COUNT(*) AS num_row ".
                                "FROM resume A LEFT JOIN resume_tvet_education B ON B.resume_id = A.resume_id LEFT JOIN resume_job_wanted C ON C.resume_id = A.resume_id ".
                                "WHERE A.resume_status = 2 AND B.education_degree_id = ". $education_degree.
                                    " AND SUBSTRING(A.present_address_location_id,1,3) = " . $location_id.
                                    " AND C.occupation_isco_id IN (SELECT B.isco_id " .
                                    "FROM isco D " .
                                    "WHERE D.name_english LIKE '%" . $keyword . "%' " .
                                    "OR D.name_khmer LIKE '%" . $keyword . "%') ";
                        } else {
                            $query_string = "SELECT COUNT(*) AS num_row ".
                                "FROM resume A LEFT JOIN resume_general_education B ON B.resume_id = A.resume_id LEFT JOIN resume_job_wanted C ON C.resume_id = A.resume_id ".
                                "WHERE A.resume_status = 2 AND B.education_degree_id = ". $education_degree.
                                    " AND SUBSTRING(A.present_address_location_id,1,3) = " . $location_id.
                                    " AND C.occupation_isco_id IN (SELECT B.isco_id " .
                                    "FROM isco D " .
                                    "WHERE D.name_english LIKE '%" . $keyword . "%' " .
                                    "OR D.name_khmer LIKE '%" . $keyword . "%') ";
                        }
                    }
                }
            }

            $list_data = $this->db->query($query_string)->row();
            return $list_data->num_row;
        }

        public function get_employer_seeker_search($location_id, $education_degree, $keyword, $limit, $offset) {

            if ($keyword == 0) {
                if ($location_id == 0) {
                    if ($education_degree == 0) {
                        $qry_result = $this->db->query("CALL get_employer_seeker_search_1($limit, $offset)");
                        return $qry_result;
                    } else {
                        if ($education_degree >= 211 AND $education_degree <=221) {
                            $qry_result = $this->db->query("CALL get_employer_seeker_search_2($education_degree, $limit, $offset)");
                            return $qry_result;
                        } else {
                            $qry_result = $this->db->query("CALL get_employer_seeker_search_3($education_degree, $limit, $offset)");
                            return $qry_result;
                        }
                    }
                } else {
                    if ($education_degree == 0) {
                        $qry_result = $this->db->query("CALL get_employer_seeker_search_4($location_id, $limit, $offset)");
                        return $qry_result;
                    } else {
                        if ($education_degree >= 211 AND $education_degree <=221) {
                            $qry_result = $this->db->query("CALL get_employer_seeker_search_5($location_id, $education_degree, $limit, $offset)");
                            return $qry_result;
                        } else {
                            $qry_result = $this->db->query("CALL get_employer_seeker_search_6($location_id, $education_degree, $limit, $offset)");
                            return $qry_result;
                        }
                    }
                }
            } else {
                if ($location_id == 0) {
                    if ($education_degree == 0) {
                        $qry_result = $this->db->query("CALL get_employer_seeker_search_7($keyword, $limit, $offset)");
                        return $qry_result;
                    } else {
                        if ($education_degree >= 211 AND $education_degree <=221) {
                            $qry_result = $this->db->query("CALL get_employer_seeker_search_8($keyword, $education_degree, $limit, $offset)");
                            return $qry_result;
                        } else {
                            $qry_result = $this->db->query("CALL get_employer_seeker_search_9($keyword, $education_degree, $limit, $offset)");
                            return $qry_result;
                        }
                    }
                } else {
                    if ($education_degree == 0) {
                        $qry_result = $this->db->query("CALL get_employer_seeker_search_10($keyword, $location_id, $limit, $offset)");
                        return $qry_result;
                    } else {
                        if ($education_degree >= 211 AND $education_degree <=221) {
                            $qry_result = $this->db->query("CALL get_employer_seeker_search_11($keyword, $location_id, $education_degree, $limit, $offset)");
                            return $qry_result;
                        } else {
                            $qry_result = $this->db->query("CALL get_employer_seeker_search_12($keyword, $location_id, $education_degree, $limit, $offset)");
                            return $qry_result;
                        }
                    }
                }
            }
        }
    }